/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyListLiteralExpressionImpl
extends PyElementImpl
implements PyListLiteralExpression {
    public PyListLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyListLiteralExpression(this);
    }

    @Override
    @NotNull
    public PyExpression[] getElements() {
        PyExpression[] pyExpressionArray = (PyExpression[])this.childrenToPsi(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens(), PyExpression.EMPTY_ARRAY);
        if (pyExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "getElements"));
        }
        return pyExpressionArray;
    }

    @Override
    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "add"));
        }
        PyListLiteralExpressionImpl.checkPyExpression(psiElement);
        PyExpression element = (PyExpression)psiElement;
        PyExpression[] els = this.getElements();
        PyExpression lastArg = els.length == 0 ? null : els[els.length - 1];
        return PyElementGenerator.getInstance(this.getProject()).insertItemIntoList(this, lastArg, element);
    }

    private static void checkPyExpression(PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PyExpression)) {
            throw new IncorrectOperationException("Element must be PyExpression: " + psiElement);
        }
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement psiElement, PsiElement afterThis) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "addAfter"));
        }
        PyListLiteralExpressionImpl.checkPyExpression(psiElement);
        PyListLiteralExpressionImpl.checkPyExpression(afterThis);
        return PyElementGenerator.getInstance(this.getProject()).insertItemIntoList(this, (PyExpression)afterThis, (PyExpression)psiElement);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement psiElement, PsiElement beforeThis) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "addBefore"));
        }
        PyListLiteralExpressionImpl.checkPyExpression(psiElement);
        return PyElementGenerator.getInstance(this.getProject()).insertItemIntoList(this, null, (PyExpression)psiElement);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "deleteChildInternal"));
        }
        if (child.getPsi() instanceof PyExpression) {
            PyExpression expression = (PyExpression)child.getPsi();
            ASTNode node = this.getNode();
            ASTNode exprNode = expression.getNode();
            ASTNode next = PyPsiUtils.getNextComma(exprNode);
            ASTNode prev = PyPsiUtils.getPrevComma(exprNode);
            super.deleteChildInternal(child);
            if (next != null) {
                this.deleteChildInternal(next);
            } else if (prev != null) {
                this.deleteChildInternal(prev);
            }
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyListLiteralExpressionImpl", "getType"));
        }
        return PyBuiltinCache.getInstance((PsiElement)this).createLiteralCollectionType(this, "list", context);
    }
}

