/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyKeywordArgumentReference
extends PsiReferenceBase.Poly<PyKeywordArgument> {
    public PyKeywordArgumentReference(@NotNull PyKeywordArgument element, TextRange textRange) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "<init>"));
        }
        super((PsiElement)element, textRange, true);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String keyword = ((PyKeywordArgument)this.myElement).getKeyword();
        if (keyword == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement call = PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{PyCallExpression.class, PyClass.class});
        if (!(call instanceof PyCallExpression)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PyExpression callee = ((PyCallExpression)call).getCallee();
        if (callee == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiPolyVariantReference calleeReference = (PsiPolyVariantReference)callee.getReference();
        if (calleeReference == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] calleeCandidates = calleeReference.multiResolve(incompleteCode);
        ArrayList<PsiElementResolveResult> resultList = new ArrayList<PsiElementResolveResult>();
        for (ResolveResult calleeCandidate : calleeCandidates) {
            PyNamedParameter result;
            PyFunction calleeFunction;
            PsiElement element;
            if (!calleeCandidate.isValidResult() || (element = calleeCandidate.getElement()) == null || (calleeFunction = PyKeywordArgumentReference.resolveToFunction(element, new HashSet<PsiElement>())) == null || (result = calleeFunction.getParameterList().findParameterByName(keyword)) == null) continue;
            resultList.add(new PsiElementResolveResult((PsiElement)result));
        }
        ResolveResult[] resolveResultArray = resultList.toArray(new ResolveResult[resultList.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    private static PyFunction resolveToFunction(PsiElement element, HashSet<PsiElement> visited) {
        if (visited.contains(element)) {
            return null;
        }
        visited.add(element);
        if (element instanceof PyFunction) {
            return (PyFunction)element;
        }
        if (element instanceof PyTargetExpression) {
            PyExpression assignedValue = ((PyTargetExpression)element).findAssignedValue();
            return PyKeywordArgumentReference.resolveToFunction((PsiElement)assignedValue, visited);
        }
        if (element instanceof PyReferenceExpression) {
            PsiElement resolveResult = ((PyReferenceExpression)element).getReference().resolve();
            return PyKeywordArgumentReference.resolveToFunction(resolveResult, visited);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = new Object[]{};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyKeywordArgumentReference", "getVariants"));
        }
        return objectArray;
    }
}

