/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyKeywordArgument;
import org.jetbrains.annotations.NotNull;

public class PyKeywordArgumentManipulator
extends AbstractElementManipulator<PyKeywordArgument> {
    public PyKeywordArgument handleContentChange(@NotNull PyKeywordArgument element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyKeywordArgumentManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/psi/impl/PyKeywordArgumentManipulator", "handleContentChange"));
        }
        ASTNode keywordNode = element.getKeywordNode();
        if (keywordNode != null && keywordNode.getTextRange().shiftRight(-element.getTextRange().getStartOffset()).equals((Object)range)) {
            LanguageLevel langLevel = LanguageLevel.forElement((PsiElement)element);
            PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
            PyCallExpression callExpression = (PyCallExpression)generator.createExpressionFromText(langLevel, "foo(" + newContent + "=None)");
            PyKeywordArgument kwArg = callExpression.getArgumentList().getKeywordArgument(newContent);
            element.getKeywordNode().getPsi().replace(kwArg.getKeywordNode().getPsi());
            return element;
        }
        throw new IncorrectOperationException("unsupported manipulation on keyword argument");
    }
}

