/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportedModule
extends LightElement
implements NameDefiner {
    @Nullable
    private PyImportElement myImportElement;
    @NotNull
    private final PyFile myContainingFile;
    @NotNull
    private final QualifiedName myImportedPrefix;

    public PyImportedModule(@Nullable PyImportElement importElement, @NotNull PyFile containingFile, @NotNull QualifiedName importedPrefix) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/jetbrains/python/psi/impl/PyImportedModule", "<init>"));
        }
        if (importedPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedPrefix", "com/jetbrains/python/psi/impl/PyImportedModule", "<init>"));
        }
        super(containingFile.getManager(), PythonLanguage.getInstance());
        this.myImportElement = importElement;
        this.myContainingFile = containingFile;
        this.myImportedPrefix = importedPrefix;
    }

    @Override
    @NotNull
    public PyFile getContainingFile() {
        PyFile pyFile = this.myContainingFile;
        if (pyFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportedModule", "getContainingFile"));
        }
        return pyFile;
    }

    @NotNull
    public QualifiedName getImportedPrefix() {
        QualifiedName qualifiedName = this.myImportedPrefix;
        if (qualifiedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportedModule", "getImportedPrefix"));
        }
        return qualifiedName;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement getElementNamed(String the_name) {
        QualifiedName prefix = this.myImportedPrefix.append(the_name);
        if (this.myImportElement != null) {
            QualifiedName qName = this.myImportElement.getImportedQName();
            if (qName != null && qName.getComponentCount() == prefix.getComponentCount()) {
                return PyImportedModule.resolve(this.myImportElement, prefix);
            }
            return new PyImportedModule(this.myImportElement, this.myContainingFile, prefix);
        }
        PyImportElement fromImportElement = this.findMatchingFromImport(this.myImportedPrefix, the_name);
        if (fromImportElement != null) {
            return fromImportElement.resolve();
        }
        return null;
    }

    @Nullable
    private PyImportElement findMatchingFromImport(QualifiedName prefix, String name) {
        List<PyFromImportStatement> fromImports = this.getContainingFile().getFromImports();
        for (PyFromImportStatement fromImport : fromImports) {
            PyImportElement[] importElements;
            QualifiedName qName = fromImport.getImportSourceQName();
            if (!prefix.equals((Object)qName)) continue;
            for (PyImportElement importElement : importElements = fromImport.getImportElements()) {
                QualifiedName importedName = importElement.getImportedQName();
                if (importedName == null || !importedName.matches(new String[]{name})) continue;
                return importElement;
            }
        }
        return null;
    }

    @Override
    public boolean mustResolveOutside() {
        return true;
    }

    @Override
    public String getText() {
        return "import " + this.myImportedPrefix;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/psi/impl/PyImportedModule", "accept"));
        }
        visitor.visitElement((PsiElement)this);
    }

    @Override
    public PsiElement copy() {
        return new PyImportedModule(this.myImportElement, this.myContainingFile, this.myImportedPrefix);
    }

    @Override
    public String toString() {
        return "PyImportedModule:" + this.myImportedPrefix;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element;
        if (this.myImportElement != null && (element = PyImportedModule.resolve(this.myImportElement, this.myImportedPrefix)) != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportedModule", "getNavigationElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportedModule", "getNavigationElement"));
        }
        return psiElement;
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.myImportElement;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement element = this.myImportElement != null ? ResolveImportUtil.resolveImportElement(this.myImportElement, this.myImportedPrefix) : ResolveImportUtil.resolveModuleInRoots(this.myImportedPrefix, this.myContainingFile);
        if (element instanceof PsiDirectory) {
            return PyUtil.getPackageElement((PsiDirectory)element, this);
        }
        return element;
    }

    @Nullable
    private static PsiElement resolve(PyImportElement importElement, @NotNull QualifiedName prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/psi/impl/PyImportedModule", "resolve"));
        }
        PsiElement resolved = ResolveImportUtil.resolveImportElement(importElement, prefix);
        PsiElement packageInit = PyUtil.turnDirIntoInit(resolved);
        return packageInit != null ? packageInit : resolved;
    }

    public boolean isAncestorOf(PyImportedModule other) {
        return PsiTreeUtil.isAncestor((PsiElement)this.myContainingFile, (PsiElement)other.myContainingFile, (boolean)true);
    }
}

