/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayFactory;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.stubs.PyImportStatementStub;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyImportStatementImpl
extends PyBaseElementImpl<PyImportStatementStub>
implements PyImportStatement {
    public PyImportStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyImportStatementImpl(PyImportStatementStub stub) {
        this(stub, (IStubElementType)PyElementTypes.IMPORT_STATEMENT);
    }

    public PyImportStatementImpl(PyImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @NotNull
    public PyImportElement[] getImportElements() {
        PyImportStatementStub stub = (PyImportStatementStub)this.getStub();
        if (stub != null) {
            PyImportElement[] pyImportElementArray = (PyImportElement[])stub.getChildrenByType((IElementType)PyElementTypes.IMPORT_ELEMENT, (ArrayFactory)new ArrayFactory<PyImportElement>(){

                @NotNull
                public PyImportElement[] create(int count) {
                    PyImportElement[] pyImportElementArray = new PyImportElement[count];
                    if (pyImportElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportStatementImpl$1", "create"));
                    }
                    return pyImportElementArray;
                }
            });
            if (pyImportElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportStatementImpl", "getImportElements"));
            }
            return pyImportElementArray;
        }
        PyImportElement[] pyImportElementArray = (PyImportElement[])this.childrenToPsi(TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.IMPORT_ELEMENT}), new PyImportElement[0]);
        if (pyImportElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportStatementImpl", "getImportElements"));
        }
        return pyImportElementArray;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyImportStatement(this);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/psi/impl/PyImportStatementImpl", "deleteChildInternal"));
        }
        PyPsiUtils.deleteAdjacentComma(this, child, this.getImportElements());
        super.deleteChildInternal(child);
    }

    @Override
    @NotNull
    public List<String> getFullyQualifiedObjectNames() {
        List<String> list = PyImportStatementImpl.getImportElementNames(this.getImportElements());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportStatementImpl", "getFullyQualifiedObjectNames"));
        }
        return list;
    }

    @NotNull
    public static List<String> getImportElementNames(PyImportElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/psi/impl/PyImportStatementImpl", "getImportElementNames"));
        }
        ArrayList<String> result = new ArrayList<String>(elements.length);
        for (PyImportElement element : elements) {
            QualifiedName qName = element.getImportedQName();
            if (qName == null) continue;
            result.add(qName.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportStatementImpl", "getImportElementNames"));
        }
        return arrayList;
    }
}

