/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.EmptyIterable;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyImportElementStub;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportElementImpl
extends PyBaseElementImpl<PyImportElementStub>
implements PyImportElement {
    public PyImportElementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyImportElementImpl(PyImportElementStub stub) {
        this(stub, (IStubElementType)PyElementTypes.IMPORT_ELEMENT);
    }

    public PyImportElementImpl(PyImportElementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public PyReferenceExpression getImportReferenceExpression() {
        ASTNode node = this.getNode().findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens());
        return node == null ? null : (PyReferenceExpression)node.getPsi();
    }

    @Override
    public QualifiedName getImportedQName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            return stub.getImportedQName();
        }
        PyReferenceExpression importReference = this.getImportReferenceExpression();
        return importReference != null ? importReference.asQualifiedName() : null;
    }

    @Override
    public PyTargetExpression getAsNameElement() {
        return this.getStubOrPsiChild(PyElementTypes.TARGET_EXPRESSION);
    }

    @Override
    public String getAsName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            String asName = stub.getAsName();
            return StringUtil.isEmpty((String)asName) ? null : asName;
        }
        PyTargetExpression element = this.getAsNameElement();
        return element != null ? element.getName() : null;
    }

    @Override
    @Nullable
    public String getVisibleName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            String asName = stub.getAsName();
            if (!StringUtil.isEmpty((String)asName)) {
                return asName;
            }
            QualifiedName importedName = stub.getImportedQName();
            if (importedName != null && importedName.getComponentCount() > 0) {
                return (String)importedName.getComponents().get(0);
            }
        } else {
            PyTargetExpression asNameElement = this.getAsNameElement();
            if (asNameElement != null) {
                return asNameElement.getName();
            }
            QualifiedName importedName = this.getImportedQName();
            if (importedName != null && importedName.getComponentCount() > 0) {
                return (String)importedName.getComponents().get(0);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PyStatement getContainingImportStatement() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        PsiElement parent = stub != null ? stub.getParentStub().getPsi() : this.getParent();
        return parent instanceof PyStatement ? (PyStatement)parent : null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            private String getRefName(String default_name) {
                String refName;
                PyReferenceExpression ref = PyImportElementImpl.this.getImportReferenceExpression();
                if (ref != null && (refName = ref.getName()) != null) {
                    String string = refName;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportElementImpl$1", "getRefName"));
                    }
                    return string;
                }
                String string = default_name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportElementImpl$1", "getRefName"));
                }
                return string;
            }

            public String getPresentableText() {
                return this.getRefName("<none>");
            }

            public String getLocationString() {
                PyElement elt = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)PyImportElementImpl.this, (Class[])new Class[]{PyImportStatement.class, PyFromImportStatement.class});
                StringBuilder buf = new StringBuilder("| ");
                if (elt != null) {
                    if (elt instanceof PyFromImportStatement) {
                        buf.append("from ");
                        PyReferenceExpression imp_src = ((PyFromImportStatement)elt).getImportSource();
                        if (imp_src != null) {
                            buf.append(PyPsiUtils.toPath(imp_src));
                        } else {
                            buf.append("<?>");
                        }
                        buf.append(" import ");
                    } else {
                        buf.append("import ");
                    }
                    buf.append(this.getRefName("<?>"));
                } else {
                    buf.append("import?.. ");
                }
                PyTargetExpression as_part = PyImportElementImpl.this.getAsNameElement();
                if (as_part != null) {
                    buf.append(" as ").append(as_part.getName());
                }
                return buf.toString();
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        PyReferenceExpression importReference;
        PyExpression ret = this.getAsNameElement();
        if (ret == null && (importReference = this.getImportReferenceExpression()) != null) {
            ret = PyPsiUtils.getFirstQualifier(importReference);
        }
        if (ret == null) {
            EmptyIterable emptyIterable = EmptyIterable.getInstance();
            if (emptyIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportElementImpl", "iterateNames"));
            }
            return emptyIterable;
        }
        Set<PyElement> set = Collections.singleton(ret);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportElementImpl", "iterateNames"));
        }
        return set;
    }

    @Override
    public PsiElement getElementNamed(String name) {
        return this.getElementNamed(name, true);
    }

    @Override
    public PsiElement getElementNamed(String name, boolean resolveImportElement) {
        String asName = this.getAsName();
        if (asName != null) {
            if (!Comparing.equal((String)name, (String)asName)) {
                return null;
            }
            return resolveImportElement ? this.resolve() : this;
        }
        QualifiedName qName = this.getImportedQName();
        if (qName == null || qName.getComponentCount() == 0 || !((String)qName.getComponents().get(0)).equals(name)) {
            return null;
        }
        if (qName.getComponentCount() == 1) {
            if (resolveImportElement) {
                return ResolveImportUtil.resolveImportElement(this, QualifiedName.fromComponents((String[])new String[]{name}));
            }
            return this;
        }
        return this.createImportedModule(name);
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        QualifiedName qName = this.getImportedQName();
        return qName == null ? null : ResolveImportUtil.resolveImportElement(this, qName);
    }

    @Override
    public boolean mustResolveOutside() {
        return true;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyImportElement(this);
    }

    @Override
    public String toString() {
        QualifiedName qName = this.getImportedQName();
        return String.format("%s:%s", super.toString(), qName != null ? qName : "null");
    }

    @Nullable
    private PsiElement createImportedModule(String name) {
        PsiFile file = this.getContainingFile();
        if (file instanceof PyFile) {
            return new PyImportedModule(this, (PyFile)file, QualifiedName.fromComponents((String[])new String[]{name}));
        }
        return null;
    }
}

