/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyElementImpl;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyGlobalStatementImpl
extends PyElementImpl
implements PyGlobalStatement {
    private static final TokenSet TARGET_EXPRESSION_SET = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.TARGET_EXPRESSION});

    public PyGlobalStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyGlobalStatement(this);
    }

    @Override
    @NotNull
    public PyTargetExpression[] getGlobals() {
        PyTargetExpression[] pyTargetExpressionArray = (PyTargetExpression[])this.childrenToPsi(TARGET_EXPRESSION_SET, PyTargetExpression.EMPTY_ARRAY);
        if (pyTargetExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyGlobalStatementImpl", "getGlobals"));
        }
        return pyTargetExpressionArray;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        List<PyElement> list = Arrays.asList(this.getGlobals());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyGlobalStatementImpl", "iterateNames"));
        }
        return list;
    }

    public PyElement getElementNamed(String the_name) {
        return NameDefiner.IterHelper.findName(this.iterateNames(), the_name);
    }

    @Override
    public boolean mustResolveOutside() {
        return true;
    }

    @Override
    public void addGlobal(String name) {
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(this.getProject());
        this.add(pyElementGenerator.createComma().getPsi());
        this.add((PsiElement)pyElementGenerator.createFromText(LanguageLevel.getDefault(), PyGlobalStatement.class, "global " + name).getGlobals()[0]);
    }
}

