/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyComprehensionElementImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyGeneratorExpressionImpl
extends PyComprehensionElementImpl
implements PyGeneratorExpression {
    public PyGeneratorExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyGeneratorExpression(this);
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyGeneratorExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyGeneratorExpressionImpl", "getType"));
        }
        PyExpression resultExpr = this.getResultExpression();
        PyBuiltinCache cache = PyBuiltinCache.getInstance(this);
        PyClass generator = cache.getClass("__generator");
        if (resultExpr != null && generator != null) {
            PyType elementType = context.getType(resultExpr);
            return new PyCollectionTypeImpl(generator, false, elementType);
        }
        return null;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        List<ComprhForComponent> fors = this.getForComponents();
        PyExpression[] for_targets = new PyExpression[fors.size()];
        int i = 0;
        for (ComprhForComponent for_comp : fors) {
            for_targets[i] = for_comp.getIteratorVariable();
            ++i;
        }
        ArrayList<PyElement> arrayList = new ArrayList<PyElement>(PyUtil.flattenedParensAndStars(for_targets));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyGeneratorExpressionImpl", "iterateNames"));
        }
        return arrayList;
    }

    @Override
    public PsiElement getElementNamed(String the_name) {
        return NameDefiner.IterHelper.findName(this.iterateNames(), the_name);
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }
}

