/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionImpl
extends PyBaseElementImpl<PyFunctionStub>
implements PyFunction {
    private CachedStructuredDocStringProvider myCachedStructuredDocStringProvider = new CachedStructuredDocStringProvider();

    public PyFunctionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFunctionImpl(PyFunctionStub stub) {
        this(stub, (IStubElementType)PyElementTypes.FUNCTION_DECLARATION);
    }

    public PyFunctionImpl(PyFunctionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public String getName() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyFunctionImpl", "setName"));
        }
        ASTNode nameElement = PyUtil.createNewName(this, name);
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            this.getNode().replaceChild(nameNode, nameElement);
        }
        return this;
    }

    public Icon getIcon(int flags) {
        Property property;
        if (this.isValid() && (property = this.getProperty()) != null) {
            if (property.getGetter().valueOrNull() == this) {
                return PythonIcons.Python.PropertyGetter;
            }
            if (property.getSetter().valueOrNull() == this) {
                return PythonIcons.Python.PropertySetter;
            }
            if (property.getDeleter().valueOrNull() == this) {
                return PythonIcons.Python.PropertyDeleter;
            }
            return PlatformIcons.PROPERTY_ICON;
        }
        return PlatformIcons.METHOD_ICON;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    @Override
    @NotNull
    public PyParameterList getParameterList() {
        PyParameterList pyParameterList = this.getRequiredStubOrPsiChild(PyElementTypes.PARAMETER_LIST);
        if (pyParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getParameterList"));
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        PyStatementList statementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (statementList != null) : "Statement list missing for function " + this.getText();
        PyStatementList pyStatementList = statementList;
        if (pyStatementList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getStatementList"));
        }
        return pyStatementList;
    }

    @Override
    public PyClass getContainingClass() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, StubBasedPsiElement.class);
        if (parent instanceof PyClass) {
            return (PyClass)parent;
        }
        return null;
    }

    @Override
    @Nullable
    public PyDecoratorList getDecoratorList() {
        return this.getStubOrPsiChild(PyElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyType type;
        PyAnnotation annotation;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getReturnType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getReturnType"));
        }
        for (PyTypeProvider typeProvider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            PyType returnType = typeProvider.getReturnType(this, context);
            if (returnType == null) continue;
            returnType.assertValid(typeProvider.toString());
            return returnType;
        }
        if (context.maySwitchToAST(this) && LanguageLevel.forElement(this).isAtLeast(LanguageLevel.PYTHON30) && (annotation = this.getAnnotation()) != null && (type = context.getType(annotation)) != null) {
            return type;
        }
        PyType docStringType = this.getReturnTypeFromDocString();
        if (docStringType != null) {
            docStringType.assertValid("from docstring");
            return docStringType;
        }
        if (context.allowReturnTypes(this)) {
            Ref<? extends PyType> yieldTypeRef = this.getYieldStatementType(context);
            if (yieldTypeRef != null) {
                return (PyType)yieldTypeRef.get();
            }
            return this.getReturnStatementType(context);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        PyTypeChecker.AnalyzeCallResults results;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getCallType"));
        }
        if (callSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSite", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getCallType"));
        }
        PyType type = null;
        for (PyTypeProvider typeProvider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            type = typeProvider.getCallType(this, callSite, context);
            if (type == null) continue;
            type.assertValid(typeProvider.toString());
            break;
        }
        if (type == null) {
            type = context.getReturnType(this);
        }
        if ((results = PyTypeChecker.analyzeCallSite(callSite, context)) != null) {
            return this.analyzeCallType(type, results.getReceiver(), results.getArguments(), context);
        }
        return type;
    }

    @Override
    @Nullable
    public PyType getCallType(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyNamedParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getCallType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getCallType"));
        }
        return this.analyzeCallType(context.getReturnType(this), receiver, parameters, context);
    }

    @Nullable
    private PyType analyzeCallType(@Nullable PyType type, @Nullable PyExpression receiver, @NotNull Map<PyExpression, PyNamedParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/impl/PyFunctionImpl", "analyzeCallType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "analyzeCallType"));
        }
        if (PyTypeChecker.hasGenerics(type, context)) {
            Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyGenericCall(receiver, parameters, context);
            type = substitutions != null ? PyTypeChecker.substitute(type, substitutions, context) : null;
        }
        if (receiver != null) {
            type = this.replaceSelf(type, receiver, context);
        }
        if (type != null && PyFunctionImpl.isDynamicallyEvaluated(parameters.values(), context)) {
            type = PyUnionType.createWeakType(type);
        }
        return type;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @Nullable
            public String getPresentableText() {
                return StringUtil.notNullize((String)PyFunctionImpl.this.getName(), (String)"<unnamed>") + PyFunctionImpl.this.getParameterList().getPresentableText(true);
            }

            @Override
            @Nullable
            public String getLocationString() {
                PyClass containingClass = PyFunctionImpl.this.getContainingClass();
                if (containingClass != null) {
                    return "(" + containingClass.getName() + " in " + 1.getPackageForFile(PyFunctionImpl.this.getContainingFile()) + ")";
                }
                return super.getLocationString();
            }
        };
    }

    @Nullable
    private PyType replaceSelf(@Nullable PyType returnType, @Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        PyType receiverType;
        PyClassType returnClassType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "replaceSelf"));
        }
        if (receiver != null && returnType instanceof PyClassType && (returnClassType = (PyClassType)returnType).getPyClass() == this.getContainingClass() && (receiverType = context.getType(receiver)) instanceof PyClassType && PyTypeChecker.match(returnType, receiverType, context)) {
            return returnClassType.isDefinition() ? receiverType : ((PyClassType)receiverType).toInstance();
        }
        return returnType;
    }

    private static boolean isDynamicallyEvaluated(@NotNull Collection<PyNamedParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/impl/PyFunctionImpl", "isDynamicallyEvaluated"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "isDynamicallyEvaluated"));
        }
        for (PyNamedParameter parameter : parameters) {
            PyType type = context.getType(parameter);
            if (!(type instanceof PyDynamicallyEvaluatedType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Ref<? extends PyType> getYieldStatementType(final @NotNull TypeEvalContext context) {
        PyClass generator;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getYieldStatementType"));
        }
        Ref elementType = null;
        PyBuiltinCache cache = PyBuiltinCache.getInstance(this);
        PyStatementList statements = this.getStatementList();
        final LinkedHashSet<PyType> types = new LinkedHashSet<PyType>();
        statements.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyYieldExpression(PyYieldExpression node) {
                PyType type = context.getType(node);
                if (node.isDelegating() && type instanceof PyCollectionType) {
                    PyCollectionType collectionType = (PyCollectionType)type;
                    types.add(collectionType.getElementType(context));
                } else {
                    types.add(type);
                }
            }

            @Override
            public void visitPyFunction(PyFunction node) {
            }
        });
        int n = types.size();
        if (n == 1) {
            elementType = Ref.create(types.iterator().next());
        } else if (n > 0) {
            elementType = Ref.create((Object)PyUnionType.union(types));
        }
        if (elementType != null && (generator = cache.getClass("__generator")) != null) {
            return Ref.create((Object)new PyCollectionTypeImpl(generator, false, (PyType)elementType.get()));
        }
        if (!types.isEmpty()) {
            return Ref.create(null);
        }
        return null;
    }

    @Nullable
    public PyType getReturnStatementType(TypeEvalContext typeEvalContext) {
        ReturnVisitor visitor = new ReturnVisitor(this, typeEvalContext);
        PyStatementList statements = this.getStatementList();
        statements.accept(visitor);
        if (this.isGeneratedStub() && !visitor.myHasReturns) {
            if ("__init__".equals(this.getName())) {
                return PyNoneType.INSTANCE;
            }
            return null;
        }
        return visitor.result();
    }

    @Override
    public PyFunction asMethod() {
        if (this.getContainingClass() != null) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnTypeFromDocString() {
        String typeName = this.extractReturnType();
        return typeName != null ? PyTypeParser.getTypeByName(this, typeName) : null;
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getDeprecationMessage();
        }
        return this.extractDeprecationMessage();
    }

    @Nullable
    public String extractDeprecationMessage() {
        PyStatementList statementList = this.getStatementList();
        return PyFunctionImpl.extractDeprecationMessage(Arrays.asList(statementList.getStatements()));
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getType"));
        }
        for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            PyType type = provider.getCallableType(this, context);
            if (type == null) continue;
            return type;
        }
        boolean hasCustomDecorators = PyUtil.hasCustomDecorators(this) && !PyUtil.isDecoratedAsAbstract(this) && this.getProperty() == null;
        PyFunctionType type = new PyFunctionType(this);
        if (hasCustomDecorators) {
            return PyUnionType.createWeakType(type);
        }
        return type;
    }

    @Nullable
    public static String extractDeprecationMessage(List<PyStatement> statements) {
        for (PyStatement statement : statements) {
            PyReferenceExpression warningClass;
            PyCallExpression callExpression;
            PyExpressionStatement expressionStatement;
            if (!(statement instanceof PyExpressionStatement) || !((expressionStatement = (PyExpressionStatement)statement).getExpression() instanceof PyCallExpression) || !(callExpression = (PyCallExpression)expressionStatement.getExpression()).isCalleeText("warn") || (warningClass = callExpression.getArgument(1, PyReferenceExpression.class)) == null || !"DeprecationWarning".equals(warningClass.getReferencedName()) && !"PendingDeprecationWarning".equals(warningClass.getReferencedName())) continue;
            return PyPsiUtils.strValue(callExpression.getArguments()[0]);
        }
        return null;
    }

    @Override
    public String getDocStringValue() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return (StructuredDocString)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)this.myCachedStructuredDocStringProvider);
    }

    private boolean isGeneratedStub() {
        VirtualFile vFile = this.getContainingFile().getVirtualFile();
        return vFile != null && (vFile = vFile.getParent()) != null && (vFile = vFile.getParent()) != null && vFile.getName().equals("python_stubs");
    }

    @Nullable
    private String extractReturnType() {
        String ARROW = "->";
        StructuredDocString structuredDocString = this.getStructuredDocString();
        if (structuredDocString != null) {
            return structuredDocString.getReturnType();
        }
        String docString = this.getDocStringValue();
        if (docString != null && docString.contains("->")) {
            String firstLine;
            int pos;
            List lines = StringUtil.split((String)docString, (String)"\n");
            while (lines.size() > 0 && ((String)lines.get(0)).trim().length() == 0) {
                lines.remove(0);
            }
            if (lines.size() > 1 && ((String)lines.get(1)).trim().length() == 0 && (pos = (firstLine = (String)lines.get(0)).lastIndexOf("->")) >= 0) {
                return firstLine.substring(pos + 2).trim();
            }
        }
        return null;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFunction(this);
    }

    @Override
    public int getTextOffset() {
        ASTNode name = this.getNameNode();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        ASTNode node = this.getNode();
        node.getTreeParent().removeChild(node);
    }

    @Override
    public PyStringLiteralExpression getDocStringExpression() {
        PyStatementList stmtList = this.getStatementList();
        return DocStringUtil.findDocStringExpression(stmtList);
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        Set<PyElement> set = Collections.singleton(this);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "iterateNames"));
        }
        return set;
    }

    public PyElement getElementNamed(String the_name) {
        return the_name.equals(this.getName()) ? this : null;
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + "('" + this.getName() + "')";
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
    }

    @Override
    public Property getProperty() {
        PyClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            return containingClass.findPropertyByCallable(this);
        }
        return null;
    }

    @Override
    public PyAnnotation getAnnotation() {
        return this.getStubOrPsiChild(PyElementTypes.ANNOTATION);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(this);
        if (scopeOwner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)scopeOwner);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PyFunction.Modifier getModifier() {
        PyAssignmentStatement assignment;
        String deconame = this.getClassOrStaticMethodDecorator();
        if ("classmethod".equals(deconame)) {
            return PyFunction.Modifier.CLASSMETHOD;
        }
        if ("staticmethod".equals(deconame)) {
            return PyFunction.Modifier.STATICMETHOD;
        }
        PyClass cls = this.getContainingClass();
        if (cls != null && "__new__".equals(this.getName()) && cls.isNewStyleClass()) {
            return PyFunction.Modifier.STATICMETHOD;
        }
        if (this.getStub() != null) {
            return this.getWrappersFromStub();
        }
        String func_name = this.getName();
        if (func_name != null && (assignment = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, PyAssignmentStatement.class)) != null) {
            for (Pair<PyExpression, PyExpression> pair : assignment.getTargetsToValuesMapping()) {
                PyFunction original;
                Pair<String, PyFunction> interpreted;
                PyExpression target;
                PyExpression value = (PyExpression)pair.getSecond();
                if (!(value instanceof PyCallExpression) || !((target = (PyExpression)pair.getFirst()) instanceof PyTargetExpression) || !func_name.equals(target.getName()) || (interpreted = PyCallExpressionHelper.interpretAsModifierWrappingCall((PyCallExpression)value, this)) == null || (original = (PyFunction)interpreted.getSecond()) != this) continue;
                String wrapper_name = (String)interpreted.getFirst();
                if ("classmethod".equals(wrapper_name)) {
                    return PyFunction.Modifier.CLASSMETHOD;
                }
                if (!"staticmethod".equals(wrapper_name)) continue;
                return PyFunction.Modifier.STATICMETHOD;
            }
        }
        return null;
    }

    @Nullable
    private PyFunction.Modifier getWrappersFromStub() {
        PyTargetExpressionStub targetExpressionStub;
        StubElement nextStub;
        StubElement parentStub = ((PyFunctionStub)this.getStub()).getParentStub();
        List childrenStubs = parentStub.getChildrenStubs();
        int index = childrenStubs.indexOf(this.getStub());
        if (index >= 0 && index < childrenStubs.size() - 1 && (nextStub = (StubElement)childrenStubs.get(index + 1)) instanceof PyTargetExpressionStub && (targetExpressionStub = (PyTargetExpressionStub)nextStub).getInitializerType() == PyTargetExpressionStub.InitializerType.CallExpression) {
            QualifiedName qualifiedName = targetExpressionStub.getInitializer();
            if (QualifiedName.fromComponents((String[])new String[]{"classmethod"}).equals((Object)qualifiedName)) {
                return PyFunction.Modifier.CLASSMETHOD;
            }
            if (QualifiedName.fromComponents((String[])new String[]{"staticmethod"}).equals((Object)qualifiedName)) {
                return PyFunction.Modifier.STATICMETHOD;
            }
        }
        return null;
    }

    @Nullable
    private String getClassOrStaticMethodDecorator() {
        PyDecorator[] decos;
        PyDecoratorList decolist = this.getDecoratorList();
        if (decolist != null && (decos = decolist.getDecorators()).length > 0) {
            for (int i = decos.length - 1; i >= 0; --i) {
                PyDecorator deco = decos[i];
                String deconame = deco.getName();
                if ("classmethod".equals(deconame) || "staticmethod".equals(deconame)) {
                    return deconame;
                }
                for (PyKnownDecoratorProvider provider : PyUtil.KnownDecoratorProviderHolder.KNOWN_DECORATOR_PROVIDERS) {
                    String name = provider.toKnownDecorator(deconame);
                    if (name == null) continue;
                    return name;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @NotNull
    public List<PyAssignmentStatement> findAttributes() {
        ArrayList<PyAssignmentStatement> result = new ArrayList<PyAssignmentStatement>();
        for (PyAssignmentStatement statement : new PsiQuery(this).siblings(PyAssignmentStatement.class).getElements()) {
            for (PyQualifiedExpression targetExpression : new PsiQuery((PsiElement[])statement.getTargets()).filter(PyQualifiedExpression.class).getElements()) {
                PsiReference qualifierReference;
                PyExpression qualifier = targetExpression.getQualifier();
                if (qualifier == null || (qualifierReference = qualifier.getReference()) == null || !qualifierReference.isReferenceTo((PsiElement)this)) continue;
                result.add(statement);
            }
        }
        ArrayList<PyAssignmentStatement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "findAttributes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyFunction.ProtectionLevel getProtectionLevel() {
        int underscoreLevels = PyUtil.getInitialUnderscores(this.getName());
        for (PyFunction.ProtectionLevel level : PyFunction.ProtectionLevel.values()) {
            if (level.getUnderscoreLevel() != underscoreLevels) continue;
            PyFunction.ProtectionLevel protectionLevel = level;
            if (protectionLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getProtectionLevel"));
            }
            return protectionLevel;
        }
        PyFunction.ProtectionLevel protectionLevel = PyFunction.ProtectionLevel.PRIVATE;
        if (protectionLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl", "getProtectionLevel"));
        }
        return protectionLevel;
    }

    private static class ReturnVisitor
    extends PyRecursiveElementVisitor {
        private final PyFunction myFunction;
        private final TypeEvalContext myContext;
        private PyType myResult = null;
        private boolean myHasReturns = false;
        private boolean myHasRaises = false;

        public ReturnVisitor(PyFunction function, TypeEvalContext context) {
            this.myFunction = function;
            this.myContext = context;
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            if (PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class, (boolean)true) == this.myFunction) {
                PyNoneType returnType;
                PyExpression expr = node.getExpression();
                PyType pyType = returnType = expr == null ? PyNoneType.INSTANCE : this.myContext.getType(expr);
                if (!this.myHasReturns) {
                    this.myResult = returnType;
                    this.myHasReturns = true;
                } else {
                    this.myResult = PyUnionType.union(this.myResult, returnType);
                }
            }
        }

        @Override
        public void visitPyRaiseStatement(PyRaiseStatement node) {
            this.myHasRaises = true;
        }

        @Nullable
        PyType result() {
            return this.myHasReturns || this.myHasRaises ? this.myResult : PyNoneType.INSTANCE;
        }
    }

    private class CachedStructuredDocStringProvider
    implements CachedValueProvider<StructuredDocString> {
        private CachedStructuredDocStringProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<StructuredDocString> compute() {
            PyFunctionImpl f = PyFunctionImpl.this;
            return CachedValueProvider.Result.create((Object)DocStringUtil.getStructuredDocString(f), (Object[])new Object[]{f});
        }
    }
}

