/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.documentation.StructuredDocStringBase;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PyFunctionBuilder {
    private static final String COMMENTS_BOUNDARY = "\"\"\"";
    private static final Pattern INDENT_REMOVE_PATTERN = Pattern.compile("^\\s+", 8);
    private final String myName;
    private final List<String> myParameters = new ArrayList<String>();
    private final List<String> myStatements = new ArrayList<String>();
    private final List<String> myDecorators = new ArrayList<String>();
    private String myAnnotation = null;
    private String[] myDocStringLines = null;
    @NotNull
    private final Map<String, String> myDecoratorValues = new HashMap<String, String>();

    @NotNull
    public static PyFunctionBuilder copySignature(@NotNull PyFunction source, String ... decoratorsToCopyIfExist) {
        String docString;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "copySignature"));
        }
        if (decoratorsToCopyIfExist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratorsToCopyIfExist", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "copySignature"));
        }
        String name = source.getName();
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder(name != null ? name : "");
        for (PyParameter parameter : source.getParameterList().getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            functionBuilder.parameter(parameterName);
        }
        PyDecoratorList decoratorList = source.getDecoratorList();
        if (decoratorList != null) {
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                String decoratorName = decorator.getName();
                if (decoratorName == null || !ArrayUtil.contains((String)decoratorName, (String[])decoratorsToCopyIfExist)) continue;
                functionBuilder.decorate(decoratorName);
            }
        }
        if ((docString = source.getDocStringValue()) != null) {
            functionBuilder.docString(docString);
        }
        PyFunctionBuilder pyFunctionBuilder = functionBuilder;
        if (pyFunctionBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "copySignature"));
        }
        return pyFunctionBuilder;
    }

    public void docString(@NotNull String docString) {
        if (docString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docString", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "docString"));
        }
        String[] stringsToAdd = StringUtil.splitByLines((String)PyFunctionBuilder.removeIndent(docString));
        this.myDocStringLines = this.myDocStringLines == null ? stringsToAdd : ArrayUtil.mergeArrays((String[])this.myDocStringLines, (String[])stringsToAdd);
    }

    @NotNull
    private static String removeIndent(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "removeIndent"));
        }
        String string2 = INDENT_REMOVE_PATTERN.matcher(string).replaceAll("");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "removeIndent"));
        }
        return string2;
    }

    public PyFunctionBuilder(String name) {
        this.myName = name;
    }

    @NotNull
    public PyFunctionBuilder parameterWithType(@NotNull String name, @NotNull String type, @NotNull StructuredDocStringBase docStyle) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "parameterWithType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "parameterWithType"));
        }
        if (docStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docStyle", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "parameterWithType"));
        }
        this.parameter(name);
        this.docString(docStyle.createParameterType(name, type));
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "parameterWithType"));
        }
        return pyFunctionBuilder;
    }

    public PyFunctionBuilder parameter(String baseName) {
        String name = baseName;
        int uniqueIndex = 0;
        while (this.myParameters.contains(name)) {
            name = baseName + ++uniqueIndex;
        }
        this.myParameters.add(name);
        return this;
    }

    public PyFunctionBuilder annotation(String text) {
        this.myAnnotation = text;
        return this;
    }

    public PyFunctionBuilder statement(String text) {
        this.myStatements.add(text);
        return this;
    }

    public PyFunction addFunction(PsiElement target, LanguageLevel languageLevel) {
        return (PyFunction)target.add((PsiElement)this.buildFunction(target.getProject(), languageLevel));
    }

    public PyFunction addFunctionAfter(PsiElement target, PsiElement anchor, LanguageLevel languageLevel) {
        return (PyFunction)target.addAfter((PsiElement)this.buildFunction(target.getProject(), languageLevel), anchor);
    }

    public PyFunction buildFunction(Project project, LanguageLevel languageLevel) {
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        String text = this.buildText(project, generator, languageLevel);
        return generator.createFromText(languageLevel, PyFunction.class, text);
    }

    private String buildText(Project project, PyElementGenerator generator, LanguageLevel languageLevel) {
        List<String> statements;
        StringBuilder builder = new StringBuilder();
        for (String decorator : this.myDecorators) {
            StringBuilder decoratorAppender = builder.append('@' + decorator);
            if (this.myDecoratorValues.containsKey(decorator)) {
                PyCallExpression fakeCall = generator.createCallExpression(languageLevel, "fakeFunction");
                fakeCall.getArgumentList().addArgument(generator.createStringLiteralFromString(this.myDecoratorValues.get(decorator)));
                decoratorAppender.append(fakeCall.getArgumentList().getText());
            }
            decoratorAppender.append("\n");
        }
        builder.append("def ");
        builder.append(this.myName).append("(");
        builder.append(StringUtil.join(this.myParameters, (String)", "));
        builder.append(")");
        if (this.myAnnotation != null) {
            builder.append(this.myAnnotation);
        }
        builder.append(":");
        List<String> list = statements = this.myStatements.isEmpty() ? Collections.singletonList("pass") : this.myStatements;
        if (this.myDocStringLines != null) {
            ArrayList<String> comments = new ArrayList<String>(this.myDocStringLines.length + 2);
            comments.add(COMMENTS_BOUNDARY);
            comments.addAll(Arrays.asList(this.myDocStringLines));
            comments.add(COMMENTS_BOUNDARY);
            statements = new ArrayList<String>(statements);
            statements.addAll(0, comments);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        int indentSize = codeStyleSettings.getIndentOptions((FileType)PythonFileType.INSTANCE).INDENT_SIZE;
        String indent = StringUtil.repeatSymbol((char)' ', (int)indentSize);
        for (String statement : statements) {
            builder.append("\n").append(indent).append(statement);
        }
        return builder.toString();
    }

    public void decorate(@NotNull String decoratorName, @NotNull String value) {
        if (decoratorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratorName", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "decorate"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "decorate"));
        }
        this.decorate(decoratorName);
        this.myDecoratorValues.put(decoratorName, value);
    }

    public void decorate(String decoratorName) {
        this.myDecorators.add(decoratorName);
    }

    @NotNull
    private static String getIndent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "getIndent"));
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        int indentSize = codeStyleSettings.getIndentOptions((FileType)PythonFileType.INSTANCE).INDENT_SIZE;
        String string = StringUtil.repeatSymbol((char)' ', (int)indentSize);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionBuilder", "getIndent"));
        }
        return string;
    }
}

