/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayFactory;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyImportStatementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyFromImportStatementStub;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFromImportStatementImpl
extends PyBaseElementImpl<PyFromImportStatementStub>
implements PyFromImportStatement {
    public PyFromImportStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFromImportStatementImpl(PyFromImportStatementStub stub) {
        this(stub, (IStubElementType)PyElementTypes.FROM_IMPORT_STATEMENT);
    }

    public PyFromImportStatementImpl(PyFromImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFromImportStatement(this);
    }

    @Override
    public boolean isStarImport() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isStarImport();
        }
        return this.getStarImportElement() != null;
    }

    @Override
    @Nullable
    public PyReferenceExpression getImportSource() {
        return (PyReferenceExpression)this.childToPsi(PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens(), 0);
    }

    @Override
    public QualifiedName getImportSourceQName() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            QualifiedName qName = stub.getImportSourceQName();
            if (qName != null && qName.getComponentCount() == 0) {
                return null;
            }
            return qName;
        }
        PyReferenceExpression importSource = this.getImportSource();
        if (importSource == null) {
            return null;
        }
        return importSource.asQualifiedName();
    }

    @Override
    @NotNull
    public PyImportElement[] getImportElements() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            PyImportElement[] pyImportElementArray = (PyImportElement[])stub.getChildrenByType((IElementType)PyElementTypes.IMPORT_ELEMENT, (ArrayFactory)new ArrayFactory<PyImportElement>(){

                @NotNull
                public PyImportElement[] create(int count) {
                    PyImportElement[] pyImportElementArray = new PyImportElement[count];
                    if (pyImportElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl$1", "create"));
                    }
                    return pyImportElementArray;
                }
            });
            if (pyImportElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "getImportElements"));
            }
            return pyImportElementArray;
        }
        ArrayList<PyImportElement> result = new ArrayList<PyImportElement>();
        ASTNode importKeyword = this.getNode().findChildByType((IElementType)PyTokenTypes.IMPORT_KEYWORD);
        if (importKeyword != null) {
            for (ASTNode node = importKeyword.getTreeNext(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() != PyElementTypes.IMPORT_ELEMENT) continue;
                result.add((PyImportElement)node.getPsi());
            }
        }
        PyImportElement[] pyImportElementArray = result.toArray(new PyImportElement[result.size()]);
        if (pyImportElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "getImportElements"));
        }
        return pyImportElementArray;
    }

    @Override
    public PyStarImportElement getStarImportElement() {
        return this.findChildByClass(PyStarImportElement.class);
    }

    @Override
    public int getRelativeLevel() {
        ASTNode seeker;
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getRelativeLevel();
        }
        int result = 0;
        for (seeker = this.getNode().getFirstChildNode(); seeker != null && (seeker.getElementType() == PyTokenTypes.FROM_KEYWORD || seeker.getElementType() == TokenType.WHITE_SPACE); seeker = seeker.getTreeNext()) {
        }
        while (seeker != null && seeker.getElementType() == PyTokenTypes.DOT) {
            ++result;
            seeker = seeker.getTreeNext();
        }
        return result;
    }

    @Override
    public boolean isFromFuture() {
        QualifiedName qName = this.getImportSourceQName();
        return qName != null && qName.matches(new String[]{"__future__"});
    }

    @Override
    public PsiElement getLeftParen() {
        return this.findChildByType(PyTokenTypes.LPAR);
    }

    @Override
    public PsiElement getRightParen() {
        return this.findChildByType(PyTokenTypes.RPAR);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "processDeclarations"));
        }
        if (place.getContainingFile() != this.getContainingFile()) {
            return true;
        }
        if (this.isStarImport()) {
            List<PsiElement> targets = ResolveImportUtil.resolveFromImportStatementSource(this, this.getImportSourceQName());
            for (PsiElement target : targets) {
                PsiElement importedFile = PyUtil.turnDirIntoInit(target);
                if (importedFile == null || importedFile.processDeclarations(processor, state2, null, place)) continue;
                return false;
            }
        } else {
            PyImportElement[] importElements;
            for (PyImportElement element : importElements = this.getImportElements()) {
                if (processor.execute((PsiElement)element, state2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode result;
        PsiElement lastChild;
        if (anchor == null && (lastChild = this.getLastChild()) != null) {
            while (lastChild instanceof PsiComment) {
                lastChild = lastChild.getPrevSibling();
                anchor = lastChild.getNode();
            }
            ASTNode rpar_node = lastChild.getNode();
            if (rpar_node != null && rpar_node.getElementType() == PyTokenTypes.RPAR) {
                anchor = rpar_node;
            }
        }
        ASTNode prevNode = result = super.addInternal(first, last, anchor, before);
        while ((prevNode = prevNode.getTreePrev()) != null && prevNode.getElementType() == TokenType.WHITE_SPACE) {
        }
        if (prevNode != null && prevNode.getElementType() == PyElementTypes.IMPORT_ELEMENT && result.getElementType() == PyElementTypes.IMPORT_ELEMENT) {
            ASTNode comma = PyElementGenerator.getInstance(this.getProject()).createComma();
            super.addInternal(comma, comma, prevNode, false);
        }
        return result;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "deleteChildInternal"));
        }
        PyPsiUtils.deleteAdjacentComma(this, child, this.getImportElements());
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public PsiElement resolveImportSource() {
        List<PsiElement> candidates = this.resolveImportSourceCandidates();
        return candidates.size() > 0 ? candidates.get(0) : null;
    }

    @Override
    @NotNull
    public List<PsiElement> resolveImportSourceCandidates() {
        int level;
        QualifiedName qName = this.getImportSourceQName();
        if (qName == null && (level = this.getRelativeLevel()) > 0) {
            PsiDirectory upper = ResolveImportUtil.stepBackFrom(this.getContainingFile().getOriginalFile(), level);
            List<Object> list = upper == null ? Collections.emptyList() : Collections.singletonList(upper);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "resolveImportSourceCandidates"));
            }
            return list;
        }
        List<PsiElement> list = ResolveImportUtil.resolveFromImportStatementSource(this, qName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "resolveImportSourceCandidates"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getFullyQualifiedObjectNames() {
        QualifiedName source = this.getImportSourceQName();
        String prefix = source != null ? source.join(".") + '.' : "";
        List<String> unqualifiedNames = PyImportStatementImpl.getImportElementNames(this.getImportElements());
        ArrayList<String> result = new ArrayList<String>(unqualifiedNames.size());
        for (String unqualifiedName : unqualifiedNames) {
            result.add(prefix + unqualifiedName);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFromImportStatementImpl", "getFullyQualifiedObjectNames"));
        }
        return arrayList;
    }
}

