/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPartitionedElementImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyForStatementImpl
extends PyPartitionedElementImpl
implements PyForStatement {
    public PyForStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyForStatement(this);
    }

    @Override
    public PyElsePart getElsePart() {
        return (PyElsePart)this.getPart(PyElementTypes.ELSE_PART);
    }

    @Override
    @NotNull
    public PyForPart getForPart() {
        PyForPart pyForPart = this.findNotNullChildByClass(PyForPart.class);
        if (pyForPart == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyForStatementImpl", "getForPart"));
        }
        return pyForPart;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        PyExpression tgt = this.getForPart().getTarget();
        if (tgt instanceof PyReferenceExpression) {
            Set<PyElement> set = Collections.singleton(tgt);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyForStatementImpl", "iterateNames"));
            }
            return set;
        }
        ArrayList<PyElement> arrayList = new ArrayList<PyElement>(PyUtil.flattenedParensAndStars(tgt));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyForStatementImpl", "iterateNames"));
        }
        return arrayList;
    }

    public PyElement getElementNamed(String the_name) {
        return NameDefiner.IterHelper.findName(this.iterateNames(), the_name);
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }
}

