/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.inspections.PythonVisitorFilter;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.LightNamedElement;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.VariantsProcessor;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFileImpl
extends PsiFileBase
implements PyFile,
PyExpression {
    protected PyType myType;
    private final ThreadLocal<List<String>> myFindExportedNameStack = new ArrayListThreadLocal();
    private final Map<FutureFeature, Boolean> myFutureFeatures;
    private List<String> myDunderAll;
    private boolean myDunderAllCalculated;
    private volatile SoftReference<ExportedNameCache> myExportedNameCache = new SoftReference(null);
    private final PsiModificationTracker myModificationTracker;
    private final Key<Set<PyFile>> PROCESSED_FILES = Key.create((String)"PyFileImpl.processDeclarations.processedFiles");

    public PyFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, PythonLanguage.getInstance());
    }

    public PyFileImpl(FileViewProvider viewProvider, Language language) {
        super(viewProvider, language);
        this.myFutureFeatures = new HashMap<FutureFeature, Boolean>();
        this.myModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)this.getProject());
    }

    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl", "getFileType"));
        }
        return pythonFileType;
    }

    @Override
    public String toString() {
        return "PyFile:" + this.getName();
    }

    @Override
    public PyFunction findTopLevelFunction(String name) {
        return PyFileImpl.findByName(name, this.getTopLevelFunctions());
    }

    @Override
    public PyClass findTopLevelClass(String name) {
        return PyFileImpl.findByName(name, this.getTopLevelClasses());
    }

    @Override
    public PyTargetExpression findTopLevelAttribute(String name) {
        return PyFileImpl.findByName(name, this.getTopLevelAttributes());
    }

    @Nullable
    private static <T extends PsiNamedElement> T findByName(String name, List<T> namedElements) {
        for (PsiNamedElement namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        if (this.myOriginalFile != null) {
            return ((PyFileImpl)this.myOriginalFile).getLanguageLevel();
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        if (virtualFile == null) {
            virtualFile = this.getViewProvider().getVirtualFile();
        }
        return PyUtil.getLanguageLevelForVirtualFile(this.getProject(), virtualFile);
    }

    public Icon getIcon(int flags) {
        return PythonFileType.INSTANCE.getIcon();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/psi/impl/PyFileImpl", "accept"));
        }
        if (this.isAcceptedFor(visitor.getClass())) {
            if (visitor instanceof PyElementVisitor) {
                ((PyElementVisitor)visitor).visitPyFile(this);
            } else {
                super.accept(visitor);
            }
        }
    }

    public boolean isAcceptedFor(@NotNull Class visitorClass) {
        if (visitorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitorClass", "com/jetbrains/python/psi/impl/PyFileImpl", "isAcceptedFor"));
        }
        for (Language lang : this.getViewProvider().getLanguages()) {
            List filters = PythonVisitorFilter.INSTANCE.allForLanguage(lang);
            for (PythonVisitorFilter filter : filters) {
                if (filter.isSupported(visitorClass, this)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/impl/PyFileImpl", "processDeclarations"));
        }
        if (resolveState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveState", "com/jetbrains/python/psi/impl/PyFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/python/psi/impl/PyFileImpl", "processDeclarations"));
        }
        List<String> dunderAll = this.getDunderAll();
        final ArrayList<String> remainingDunderAll = dunderAll == null ? null : new ArrayList<String>(dunderAll);
        PsiScopeProcessor wrapper = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyFileImpl$1", "execute"));
                }
                if (state2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/psi/impl/PyFileImpl$1", "execute"));
                }
                if (!processor.execute(element, state2)) {
                    return false;
                }
                if (remainingDunderAll != null && element instanceof PyElement) {
                    remainingDunderAll.remove(((PyElement)element).getName());
                }
                return true;
            }

            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/python/psi/impl/PyFileImpl$1", "getHint"));
                }
                return (T)processor.getHint(hintKey);
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/impl/PyFileImpl$1", "handleEvent"));
                }
                processor.handleEvent(event, associated);
            }
        };
        HashSet<PyFileImpl> pyFiles = (HashSet<PyFileImpl>)resolveState.get(this.PROCESSED_FILES);
        if (pyFiles == null) {
            pyFiles = new HashSet<PyFileImpl>();
            resolveState = resolveState.put(this.PROCESSED_FILES, pyFiles);
        }
        if (pyFiles.contains(this)) {
            return true;
        }
        pyFiles.add(this);
        for (PyClass pyClass : this.getTopLevelClasses()) {
            if (pyClass == lastParent || wrapper.execute((PsiElement)pyClass, resolveState)) continue;
            return false;
        }
        for (PyFunction pyFunction : this.getTopLevelFunctions()) {
            if (pyFunction == lastParent || wrapper.execute((PsiElement)pyFunction, resolveState)) continue;
            return false;
        }
        for (PyTargetExpression pyTargetExpression : this.getTopLevelAttributes()) {
            if (pyTargetExpression == lastParent || wrapper.execute((PsiElement)pyTargetExpression, resolveState)) continue;
            return false;
        }
        for (PyImportElement pyImportElement : this.getImportTargets()) {
            if (pyImportElement == lastParent || wrapper.execute((PsiElement)pyImportElement, resolveState)) continue;
            return false;
        }
        for (PyFromImportStatement pyFromImportStatement : this.getFromImports()) {
            if (pyFromImportStatement == lastParent || pyFromImportStatement.processDeclarations(wrapper, resolveState, null, this)) continue;
            return false;
        }
        if (remainingDunderAll != null) {
            for (String string : remainingDunderAll) {
                if (!PyNames.isIdentifier(string) || processor.execute((PsiElement)new LightNamedElement(this.myManager, PythonLanguage.getInstance(), string), resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<PyStatement> getStatements() {
        ArrayList<PyStatement> stmts = new ArrayList<PyStatement>();
        for (PsiElement child : this.getChildren()) {
            if (!(child instanceof PyStatement)) continue;
            PyStatement statement = (PyStatement)child;
            stmts.add(statement);
        }
        return stmts;
    }

    @Override
    public List<PyClass> getTopLevelClasses() {
        return PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.CLASS_DECLARATION, PyClass.class);
    }

    @Override
    @NotNull
    public List<PyFunction> getTopLevelFunctions() {
        List<PyFunction> list = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.FUNCTION_DECLARATION, PyFunction.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl", "getTopLevelFunctions"));
        }
        return list;
    }

    @Override
    public List<PyTargetExpression> getTopLevelAttributes() {
        return PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.TARGET_EXPRESSION, PyTargetExpression.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiElement findExportedName(String name) {
        List<String> stack = this.myFindExportedNameStack.get();
        if (stack.contains(name)) {
            return null;
        }
        stack.add(name);
        try {
            PsiElement result = this.getExportedNameCache().resolve(name);
            if (result != null) {
                PsiElement psiElement = result;
                return psiElement;
            }
            List<String> allNames = this.getDunderAll();
            if (allNames != null && allNames.contains(name)) {
                PsiElement psiElement = this.findExportedName("__all__");
                return psiElement;
            }
            PsiElement psiElement = null;
            return psiElement;
        }
        finally {
            stack.remove(name);
        }
    }

    private ExportedNameCache getExportedNameCache() {
        ExportedNameCache cache = this.myExportedNameCache != null ? (ExportedNameCache)this.myExportedNameCache.get() : null;
        long modificationStamp = this.getModificationStamp();
        if (this.myExportedNameCache != null && cache != null && modificationStamp != cache.getModificationStamp()) {
            this.myExportedNameCache.clear();
            cache = null;
        }
        if (cache == null) {
            cache = new ExportedNameCache(modificationStamp);
            this.myExportedNameCache = new SoftReference((Object)cache);
        }
        return cache;
    }

    @Nullable
    private PsiElement findNameInStarImport(String name, PyFromImportStatement statement) {
        PsiElement element;
        QualifiedName qName;
        PyFile file;
        PsiElement result;
        if (PyUtil.isClassPrivateName(name)) {
            return null;
        }
        PsiElement starImportSource = statement.resolveImportSource();
        if (starImportSource != null && (starImportSource = PyUtil.turnDirIntoInit(starImportSource)) instanceof PyFile && (result = (file = (PyFile)starImportSource).getElementNamed(name)) != null && PyUtil.isStarImportableFrom(name, file)) {
            return result;
        }
        if ("__init__.py".equals(this.getName()) && (qName = statement.getImportSourceQName()) != null && qName.endsWith(name) && (element = PyUtil.turnInitIntoDir(statement.resolveImportSource())) != null && element.getParent() == this.getContainingDirectory()) {
            return element;
        }
        return null;
    }

    @Nullable
    private PsiElement findNameInImportElement(String name, PyImportElement importElement, boolean resolveImportElement) {
        PsiElement result = importElement.getElementNamed(name, resolveImportElement);
        if (result != null) {
            return result;
        }
        QualifiedName qName = importElement.getImportedQName();
        if (qName != null && qName.getComponentCount() > 1 && name.equals(qName.getLastComponent()) && "__init__.py".equals(this.getName())) {
            List<RatedResolveResult> elements = ResolveImportUtil.resolveNameInImportStatement(importElement, qName.removeLastComponent());
            for (RatedResolveResult element : elements) {
                if (PyUtil.turnDirIntoInit(element.getElement()) != this) continue;
                return importElement;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getElementNamed(String name) {
        PsiElement exportedName = this.findExportedName(name);
        if (exportedName instanceof PyImportElement) {
            PsiElement importedElement = ((PyImportElement)exportedName).getElementNamed(name);
            if (importedElement != null && !importedElement.isValid()) {
                throw new PsiInvalidElementAccessException(importedElement);
            }
            return importedElement;
        }
        if (exportedName != null && !exportedName.isValid()) {
            throw new PsiInvalidElementAccessException(exportedName);
        }
        return exportedName;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        final ArrayList<PyElement> result = new ArrayList<PyElement>();
        VariantsProcessor processor = new VariantsProcessor(this){

            @Override
            protected void addElement(String name, PsiElement element) {
                if ((element = PyUtil.turnDirIntoInit(element)) instanceof PyElement) {
                    result.add((PyElement)element);
                }
            }
        };
        processor.setAllowedNames(this.getDunderAll());
        this.processDeclarations(processor, ResolveState.initial(), null, this);
        ArrayList<PyElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl", "iterateNames"));
        }
        return arrayList;
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }

    @Override
    @NotNull
    public List<PyImportElement> getImportTargets() {
        ArrayList<PyImportElement> ret = new ArrayList<PyImportElement>();
        List<PyImportStatement> imports = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.IMPORT_STATEMENT, PyImportStatement.class);
        for (PyImportStatement one : imports) {
            ContainerUtil.addAll(ret, (Object[])one.getImportElements());
        }
        ArrayList<PyImportElement> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl", "getImportTargets"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PyFromImportStatement> getFromImports() {
        List<PyFromImportStatement> list = PyPsiUtils.collectStubChildren(this, this.getStub(), PyElementTypes.FROM_IMPORT_STATEMENT, PyFromImportStatement.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl", "getFromImports"));
        }
        return list;
    }

    @Override
    public List<String> getDunderAll() {
        StubElement stubElement = this.getStub();
        if (stubElement instanceof PyFileStub) {
            return ((PyFileStub)stubElement).getDunderAll();
        }
        if (!this.myDunderAllCalculated) {
            List<String> dunderAll = this.calculateDunderAll();
            this.myDunderAll = dunderAll == null ? null : Collections.unmodifiableList(dunderAll);
            this.myDunderAllCalculated = true;
        }
        return this.myDunderAll;
    }

    @Nullable
    public List<String> calculateDunderAll() {
        DunderAllBuilder builder = new DunderAllBuilder();
        this.accept(builder);
        return builder.result();
    }

    @Nullable
    public static List<String> getStringListFromTargetExpression(String name, List<PyTargetExpression> attrs) {
        for (PyTargetExpression attr : attrs) {
            if (!name.equals(attr.getName())) continue;
            return PyUtil.getStringListFromTargetExpression(attr);
        }
        return null;
    }

    @Override
    public boolean hasImportFromFuture(FutureFeature feature) {
        StubElement stub = this.getStub();
        if (stub instanceof PyFileStub) {
            return ((PyFileStub)stub).getFutureFeatures().get(feature.ordinal());
        }
        Boolean enabled = this.myFutureFeatures.get((Object)feature);
        if (enabled == null) {
            enabled = this.calculateImportFromFuture(feature);
            this.myFutureFeatures.put(feature, enabled);
        }
        return enabled;
    }

    @Override
    public String getDeprecationMessage() {
        StubElement stub = this.getStub();
        if (stub instanceof PyFileStub) {
            return ((PyFileStub)stub).getDeprecationMessage();
        }
        return this.extractDeprecationMessage();
    }

    @Override
    public List<PyImportStatementBase> getImportBlock() {
        ASTNode firstImport;
        ArrayList<PyImportStatementBase> result = new ArrayList<PyImportStatementBase>();
        for (firstImport = this.getNode().getFirstChildNode(); firstImport != null && !PyFileImpl.isImport(firstImport, false); firstImport = firstImport.getTreeNext()) {
        }
        if (firstImport != null) {
            result.add((PyImportStatementBase)firstImport.getPsi(PyImportStatementBase.class));
            for (ASTNode lastImport = firstImport.getTreeNext(); lastImport != null && PyFileImpl.isImport(lastImport.getTreeNext(), true); lastImport = lastImport.getTreeNext()) {
                if (!PyFileImpl.isImport(lastImport, false)) continue;
                result.add((PyImportStatementBase)lastImport.getPsi(PyImportStatementBase.class));
            }
        }
        return result;
    }

    public String extractDeprecationMessage() {
        if (PyFileImpl.canHaveDeprecationMessage(this.getText())) {
            return PyFunctionImpl.extractDeprecationMessage(this.getStatements());
        }
        return null;
    }

    private static boolean canHaveDeprecationMessage(String text) {
        return text.contains("DeprecationWarning") || text.contains("PendingDeprecationWarning");
    }

    public boolean calculateImportFromFuture(FutureFeature feature) {
        if (this.getText().contains(feature.toString())) {
            List<PyFromImportStatement> fromImports = this.getFromImports();
            for (PyFromImportStatement fromImport : fromImports) {
                PyImportElement[] pyImportElements;
                if (!fromImport.isFromFuture()) continue;
                for (PyImportElement element : pyImportElements = fromImport.getImportElements()) {
                    QualifiedName qName = element.getImportedQName();
                    if (qName == null || !qName.matches(new String[]{feature.toString()})) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyFileImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyFileImpl", "getType"));
        }
        if (this.myType == null) {
            this.myType = new PyModuleType(this);
        }
        return this.myType;
    }

    @Override
    @Nullable
    public String getDocStringValue() {
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        return DocStringUtil.findDocStringExpression(this);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        this.myDunderAllCalculated = false;
        this.myFutureFeatures.clear();
        this.myExportedNameCache.clear();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        String path = this.getVirtualFile().getPath();
        super.delete();
        PyUtil.deletePycFiles(path);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyFileImpl", "setName"));
        }
        String path = this.getVirtualFile().getPath();
        PsiElement newElement = super.setName(name);
        PyUtil.deletePycFiles(path);
        return newElement;
    }

    public static boolean isImport(ASTNode node, boolean orWhitespace) {
        if (node == null) {
            return false;
        }
        IElementType elementType = node.getElementType();
        if (orWhitespace && elementType == TokenType.WHITE_SPACE) {
            return true;
        }
        return elementType == PyElementTypes.IMPORT_STATEMENT || elementType == PyElementTypes.FROM_IMPORT_STATEMENT;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return this.getModuleName(PyFileImpl.this);
            }

            public String getLocationString() {
                String name = this.getLocationName();
                return name != null ? "(" + name + ")" : null;
            }

            public Icon getIcon(boolean open) {
                if (PyUtil.isPackage(PyFileImpl.this)) {
                    return AllIcons.Modules.SourceFolder;
                }
                return PyFileImpl.this.getIcon(0);
            }

            @NotNull
            private String getModuleName(@NotNull PyFile file) {
                PsiDirectory dir;
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PyFileImpl$3", "getModuleName"));
                }
                if (PyUtil.isPackage(file) && (dir = file.getContainingDirectory()) != null) {
                    String string = dir.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl$3", "getModuleName"));
                    }
                    return string;
                }
                String string = FileUtil.getNameWithoutExtension((String)file.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFileImpl$3", "getModuleName"));
                }
                return string;
            }

            @Nullable
            private String getLocationName() {
                QualifiedName prefix;
                QualifiedName name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)PyFileImpl.this);
                if (name != null && (prefix = name.removeTail(1)).getComponentCount() > 0) {
                    return prefix.toString();
                }
                String relativePath = this.getRelativeContainerPath();
                if (relativePath != null) {
                    return relativePath;
                }
                PsiDirectory psiDirectory = PyFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Nullable
            private String getRelativeContainerPath() {
                VirtualFile root;
                VirtualFile virtualFile;
                PsiDirectory psiDirectory = PyFileImpl.this.getParent();
                if (psiDirectory != null && (virtualFile = PyFileImpl.this.getVirtualFile()) != null && (root = ProjectFileIndex.SERVICE.getInstance((Project)PyFileImpl.this.getProject()).getContentRootForFile(virtualFile)) != null) {
                    VirtualFile parent = virtualFile.getParent();
                    VirtualFile rootParent = root.getParent();
                    if (rootParent != null && parent != null) {
                        return VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)rootParent, (char)File.separatorChar);
                    }
                }
                return null;
            }
        };
    }

    private static class ArrayListThreadLocal
    extends ThreadLocal<List<String>> {
        private ArrayListThreadLocal() {
        }

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    }

    private static class DunderAllBuilder
    extends PyRecursiveElementVisitor {
        private List<String> myResult = null;
        private boolean myDynamic = false;
        private boolean myFoundDunderAll = false;
        private final Map<String, List<String>> myDunderLike = new HashMap<String, List<String>>();

        private DunderAllBuilder() {
        }

        @Override
        public void visitPyFile(PyFile node) {
            if (node.getText().contains("__all__")) {
                super.visitPyFile(node);
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            List<String> names;
            if ("__all__".equals(node.getName())) {
                this.myFoundDunderAll = true;
                PyExpression value = node.findAssignedValue();
                if (value instanceof PyBinaryExpression) {
                    PyBinaryExpression binaryExpression = (PyBinaryExpression)value;
                    if (binaryExpression.isOperator("+")) {
                        List<String> lhs = this.getStringListFromValue(binaryExpression.getLeftExpression());
                        List<String> rhs = this.getStringListFromValue(binaryExpression.getRightExpression());
                        if (lhs != null && rhs != null) {
                            this.myResult = new ArrayList<String>(lhs);
                            this.myResult.addAll(rhs);
                        }
                    }
                } else {
                    this.myResult = PyUtil.getStringListFromTargetExpression(node);
                }
            }
            if (!this.myFoundDunderAll && (names = PyUtil.getStringListFromTargetExpression(node)) != null) {
                this.myDunderLike.put(node.getName(), names);
            }
        }

        @Nullable
        private List<String> getStringListFromValue(PyExpression expression) {
            if (expression instanceof PyReferenceExpression && !((PyReferenceExpression)expression).isQualified()) {
                return this.myDunderLike.get(((PyReferenceExpression)expression).getReferencedName());
            }
            return PyUtil.strListValue(expression);
        }

        @Override
        public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
            if ("__all__".equals(node.getTarget().getName())) {
                this.myDynamic = true;
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyExpression qualifier;
            PyExpression callee = node.getCallee();
            if (callee instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null && "__all__".equals(qualifier.getText())) {
                this.myDynamic = true;
            }
        }

        @Nullable
        List<String> result() {
            return this.myDynamic ? null : this.myResult;
        }
    }

    private class ExportedNameCache {
        private final Map<String, PsiElement> myLocalDeclarations = new HashMap<String, PsiElement>();
        private final MultiMap<String, PsiElement> myLocalAmbiguousDeclarations = new MultiMap();
        private final Map<String, PsiElement> myExceptPartDeclarations = new HashMap<String, PsiElement>();
        private final MultiMap<String, PsiElement> myExceptPartAmbiguousDeclarations = new MultiMap();
        private final List<PsiElement> myNameDefiners = new ArrayList<PsiElement>();
        private final List<String> myNameDefinerNegativeCache = new ArrayList<String>();
        private long myNameDefinerOOCBModCount = -1L;
        private final long myModificationStamp;

        private ExportedNameCache(long modificationStamp) {
            this.myModificationStamp = modificationStamp;
            List<PsiElement> children = PyPsiUtils.collectAllStubChildren(PyFileImpl.this, PyFileImpl.this.getStub());
            ArrayList<PyExceptPart> exceptParts = new ArrayList<PyExceptPart>();
            for (PsiElement child : children) {
                if (child instanceof PyExceptPart) {
                    exceptParts.add((PyExceptPart)child);
                    continue;
                }
                this.addDeclaration(child, this.myLocalDeclarations, this.myLocalAmbiguousDeclarations, this.myNameDefiners);
            }
            if (!exceptParts.isEmpty()) {
                for (PyExceptPart part : exceptParts) {
                    List<PsiElement> exceptChildren = PyPsiUtils.collectAllStubChildren(part, part.getStub());
                    for (PsiElement child : exceptChildren) {
                        this.addDeclaration(child, this.myExceptPartDeclarations, this.myExceptPartAmbiguousDeclarations, this.myNameDefiners);
                    }
                }
            }
        }

        private void addDeclaration(PsiElement child, Map<String, PsiElement> localDeclarations, MultiMap<String, PsiElement> ambiguousDeclarations, List<PsiElement> nameDefiners) {
            if (child instanceof PsiNamedElement) {
                String name = ((PsiNamedElement)child).getName();
                localDeclarations.put(name, child);
            } else if (child instanceof PyFromImportStatement) {
                PyFromImportStatement fromImportStatement = (PyFromImportStatement)child;
                if (fromImportStatement.isStarImport()) {
                    nameDefiners.add((PsiElement)fromImportStatement);
                } else {
                    for (PyImportElement importElement : fromImportStatement.getImportElements()) {
                        this.addImportElementDeclaration(importElement, localDeclarations, ambiguousDeclarations);
                    }
                }
            } else if (child instanceof PyImportStatement) {
                PyImportStatement importStatement = (PyImportStatement)child;
                for (PyImportElement importElement : importStatement.getImportElements()) {
                    this.addImportElementDeclaration(importElement, localDeclarations, ambiguousDeclarations);
                }
            } else if (child instanceof NameDefiner) {
                nameDefiners.add(child);
            }
        }

        private void addImportElementDeclaration(PyImportElement importElement, Map<String, PsiElement> localDeclarations, MultiMap<String, PsiElement> ambiguousDeclarations) {
            String visibleName = importElement.getVisibleName();
            if (visibleName != null) {
                if (ambiguousDeclarations.containsKey((Object)visibleName)) {
                    ambiguousDeclarations.putValue((Object)visibleName, (Object)importElement);
                } else if (localDeclarations.containsKey(visibleName)) {
                    PsiElement oldElement = localDeclarations.get(visibleName);
                    ambiguousDeclarations.putValue((Object)visibleName, (Object)oldElement);
                    ambiguousDeclarations.putValue((Object)visibleName, (Object)importElement);
                } else {
                    localDeclarations.put(visibleName, importElement);
                }
            }
        }

        @Nullable
        private PsiElement resolve(String name) {
            PsiElement result;
            PsiElement named = this.resolveNamed(name, this.myLocalDeclarations, this.myLocalAmbiguousDeclarations);
            if (named != null) {
                return named;
            }
            if (!this.myNameDefiners.isEmpty() && (result = this.findNameInNameDefiners(name)) != null) {
                return result;
            }
            return this.resolveNamed(name, this.myExceptPartDeclarations, this.myExceptPartAmbiguousDeclarations);
        }

        @Nullable
        private PsiElement resolveNamed(String name, Map<String, PsiElement> declarations, MultiMap<String, PsiElement> ambiguousDeclarations) {
            if (ambiguousDeclarations.containsKey((Object)name)) {
                ArrayList localAmbiguous = new ArrayList(this.myLocalAmbiguousDeclarations.get((Object)name));
                for (int i = localAmbiguous.size() - 1; i >= 0; --i) {
                    PsiElement ambiguous = (PsiElement)localAmbiguous.get(i);
                    PsiElement result = this.resolveDeclaration(name, ambiguous, true);
                    if (result == null) continue;
                    return result;
                }
            } else {
                PsiElement result = declarations.get(name);
                if (result != null) {
                    boolean resolveImportElement = result instanceof PyImportElement && ((PyImportElement)result).getContainingImportStatement() instanceof PyFromImportStatement;
                    return this.resolveDeclaration(name, result, resolveImportElement);
                }
            }
            return null;
        }

        @Nullable
        private PsiElement resolveDeclaration(String name, PsiElement result, boolean resolveImportElement) {
            if (result instanceof PyImportElement) {
                PyImportElement importElement = (PyImportElement)result;
                return PyFileImpl.this.findNameInImportElement(name, importElement, resolveImportElement);
            }
            if (result instanceof PyFromImportStatement) {
                return ((PyFromImportStatement)result).resolveImportSource();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private PsiElement findNameInNameDefiners(String name) {
            List<String> list = this.myNameDefinerNegativeCache;
            synchronized (list) {
                long oocbModCount = PyFileImpl.this.myModificationTracker.getOutOfCodeBlockModificationCount();
                if (oocbModCount != this.myNameDefinerOOCBModCount) {
                    this.myNameDefinerNegativeCache.clear();
                    this.myNameDefinerOOCBModCount = oocbModCount;
                } else if (this.myNameDefinerNegativeCache.contains(name)) {
                    return null;
                }
            }
            for (PsiElement definer : this.myNameDefiners) {
                PsiElement result = definer instanceof PyFromImportStatement ? PyFileImpl.this.findNameInStarImport(name, (PyFromImportStatement)definer) : ((NameDefiner)definer).getElementNamed(name);
                if (result == null) continue;
                return result;
            }
            list = this.myNameDefinerNegativeCache;
            synchronized (list) {
                this.myNameDefinerNegativeCache.add(name);
            }
            return null;
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }
    }
}

