/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFQDNNames;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyEvaluator {
    private Set<PyExpression> myVisited = new HashSet<PyExpression>();
    private Map<String, Object> myNamespace;
    private boolean myEvaluateCollectionItems = true;
    private boolean myEvaluateKeys = true;

    public void setNamespace(Map<String, Object> namespace) {
        this.myNamespace = namespace;
    }

    public void setEvaluateCollectionItems(boolean evaluateCollectionItems) {
        this.myEvaluateCollectionItems = evaluateCollectionItems;
    }

    public void setEvaluateKeys(boolean evaluateKeys) {
        this.myEvaluateKeys = evaluateKeys;
    }

    @Nullable
    public Object evaluate(@Nullable PyExpression expr) {
        PyBinaryExpression binaryExpr;
        PyElementType op;
        if (expr == null || this.myVisited.contains(expr)) {
            return null;
        }
        this.myVisited.add(expr);
        if (expr instanceof PyParenthesizedExpression) {
            return this.evaluate(((PyParenthesizedExpression)expr).getContainedExpression());
        }
        if (expr instanceof PySequenceExpression) {
            return this.evaluateSequenceExpression((PySequenceExpression)expr);
        }
        Boolean booleanExpression = PyEvaluator.getBooleanExpression(expr);
        if (booleanExpression != null) {
            return booleanExpression;
        }
        if (expr instanceof PyCallExpression) {
            return this.evaluateCall((PyCallExpression)expr);
        }
        if (expr instanceof PyReferenceExpression) {
            return this.evaluateReferenceExpression((PyReferenceExpression)expr);
        }
        if (expr instanceof PyStringLiteralExpression) {
            return ((PyStringLiteralExpression)expr).getStringValue();
        }
        if (expr instanceof PyBinaryExpression && (op = (binaryExpr = (PyBinaryExpression)expr).getOperator()) == PyTokenTypes.PLUS) {
            Object lhs = this.evaluate(binaryExpr.getLeftExpression());
            Object rhs = this.evaluate(binaryExpr.getRightExpression());
            if (lhs != null && rhs != null) {
                return this.concatenate(lhs, rhs);
            }
        }
        return null;
    }

    @Nullable
    private static Boolean getBooleanExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyEvaluator", "getBooleanExpression"));
        }
        boolean py3K = LanguageLevel.forElement((PsiElement)expression).isPy3K();
        if (py3K && expression instanceof PyBoolLiteralExpression) {
            return ((PyBoolLiteralExpression)expression).getValue();
        }
        if (!py3K && expression instanceof PyReferenceExpression) {
            String text = ((PyReferenceExpression)expression).getReferencedName();
            if ("True".equals(text)) {
                return true;
            }
            if ("False".equals(text)) {
                return false;
            }
        }
        return null;
    }

    protected Object evaluateSequenceExpression(PySequenceExpression expr) {
        PyExpression[] elements = expr.getElements();
        if (expr instanceof PyDictLiteralExpression) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (PyKeyValueExpression keyValueExpression : ((PyDictLiteralExpression)expr).getElements()) {
                this.addRecordFromDict(result, keyValueExpression.getKey(), keyValueExpression.getValue());
            }
            return result;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (PyExpression element : elements) {
            result.add(this.myEvaluateCollectionItems ? this.evaluate(element) : element);
        }
        return result;
    }

    public Object concatenate(Object lhs, Object rhs) {
        if (lhs instanceof String && rhs instanceof String) {
            return (String)lhs + (String)rhs;
        }
        if (lhs instanceof List && rhs instanceof List) {
            ArrayList result = new ArrayList();
            result.addAll((List)lhs);
            result.addAll((List)rhs);
            return result;
        }
        return null;
    }

    protected Object evaluateReferenceExpression(PyReferenceExpression expr) {
        if (!expr.isQualified()) {
            if (this.myNamespace != null) {
                return this.myNamespace.get(expr.getReferencedName());
            }
            Object result = expr.getReference(PyResolveContext.noImplicits()).resolve();
            if (result instanceof PyTargetExpression) {
                result = ((PyTargetExpression)result).findAssignedValue();
            }
            if (result instanceof PyExpression) {
                return this.evaluate((PyExpression)result);
            }
        }
        return null;
    }

    @Nullable
    protected Object evaluateCall(PyCallExpression call) {
        Collection tuples;
        PyExpression[] args = call.getArguments();
        if (call.isCalleeText("replace") && args.length == 2) {
            PyExpression callee = call.getCallee();
            if (!(callee instanceof PyQualifiedExpression)) {
                return null;
            }
            PyExpression qualifier = ((PyQualifiedExpression)callee).getQualifier();
            Object result = this.evaluate(qualifier);
            if (result instanceof String) {
                Object arg1 = this.evaluate(args[0]);
                Object arg2 = this.evaluate(args[1]);
                if (arg1 instanceof String && arg2 instanceof String) {
                    return ((String)result).replace((String)arg1, (String)arg2);
                }
            }
        }
        if (call.isCallee(PythonFQDNNames.DICT_CLASS) && !(tuples = PsiTreeUtil.findChildrenOfType((PsiElement)call, PyTupleExpression.class)).isEmpty()) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (PyTupleExpression tuple : tuples) {
                PsiElement[] tupleElements = tuple.getChildren();
                if (tupleElements.length != 2) {
                    return null;
                }
                PyExpression key = PyUtil.as(tupleElements[0], PyExpression.class);
                PyExpression value = PyUtil.as(tupleElements[1], PyExpression.class);
                if (key == null) continue;
                this.addRecordFromDict(result, key, value);
            }
            return result;
        }
        return null;
    }

    private void addRecordFromDict(@NotNull Map<Object, Object> result, @NotNull PyExpression key, @Nullable PyExpression value) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/psi/impl/PyEvaluator", "addRecordFromDict"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyEvaluator", "addRecordFromDict"));
        }
        result.put(this.myEvaluateKeys ? this.evaluate(key) : key, this.myEvaluateCollectionItems ? this.evaluate(value) : value);
    }

    @Nullable
    public static <T> T evaluate(@Nullable PyExpression expression, @NotNull Class<T> resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/jetbrains/python/psi/impl/PyEvaluator", "evaluate"));
        }
        return PyUtil.as(new PyEvaluator().evaluate(expression), resultType);
    }
}

