/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyElementPresentation
implements ColoredItemPresentation {
    @NotNull
    private final PyElement myElement;

    public PyElementPresentation(@NotNull PyElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyElementPresentation", "<init>"));
        }
        this.myElement = element;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return null;
    }

    @Nullable
    public String getPresentableText() {
        String name = this.myElement.getName();
        return name != null ? name : "<unnamed>";
    }

    @Nullable
    public String getLocationString() {
        return "(" + PyElementPresentation.getPackageForFile(this.myElement.getContainingFile()) + ")";
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.myElement.getIcon(0);
    }

    public static String getPackageForFile(@NotNull PsiFile containingFile) {
        String importableName;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/jetbrains/python/psi/impl/PyElementPresentation", "getPackageForFile"));
        }
        VirtualFile vFile = containingFile.getVirtualFile();
        if (vFile != null && (importableName = QualifiedNameFinder.findShortestImportableName((PsiElement)containingFile, vFile)) != null) {
            return importableName;
        }
        return "";
    }
}

