/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Formatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyElementGeneratorImpl
extends PyElementGenerator {
    private static final CommasOnly COMMAS_ONLY = new CommasOnly();
    private final Project myProject;
    static final int[] FROM_ROOT = new int[]{0};
    static int[] PATH_PARAMETER = new int[]{0, 3, 1};

    public PyElementGeneratorImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public ASTNode createNameIdentifier(String name, LanguageLevel languageLevel) {
        PsiFile dummyFile = this.createDummyFile(languageLevel, name);
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        PyReferenceExpression refExpression = (PyReferenceExpression)expressionStatement.getFirstChild();
        return refExpression.getNode().getFirstChildNode();
    }

    @Override
    public PsiFile createDummyFile(LanguageLevel langLevel, String contents) {
        return this.createDummyFile(langLevel, contents, false);
    }

    public PsiFile createDummyFile(LanguageLevel langLevel, String contents, boolean physical) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        String name = "dummy." + PythonFileType.INSTANCE.getDefaultExtension();
        LightVirtualFile virtualFile = new LightVirtualFile(name, (FileType)PythonFileType.INSTANCE, (CharSequence)contents);
        virtualFile.putUserData(LanguageLevel.KEY, (Object)langLevel);
        PsiFile psiFile = ((PsiFileFactoryImpl)factory).trySetupPsiForFile(virtualFile, PythonLanguage.getInstance(), physical, true);
        assert (psiFile != null);
        return psiFile;
    }

    @Override
    public PyStringLiteralExpression createStringLiteralAlreadyEscaped(String str) {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a=(" + str + ")");
        PyAssignmentStatement expressionStatement = (PyAssignmentStatement)dummyFile.getFirstChild();
        return (PyStringLiteralExpression)((PyParenthesizedExpression)expressionStatement.getAssignedValue()).getContainedExpression();
    }

    @Override
    public PyStringLiteralExpression createStringLiteralFromString(@NotNull String unescaped) {
        if (unescaped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unescaped", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createStringLiteralFromString"));
        }
        return this.createStringLiteralFromString(null, unescaped, true);
    }

    @Override
    public PyStringLiteralExpression createStringLiteral(@NotNull PyStringLiteralExpression oldElement, @NotNull String unescaped) {
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createStringLiteral"));
        }
        if (unescaped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unescaped", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createStringLiteral"));
        }
        Pair<String, String> quotes = PythonStringUtil.getQuotes(oldElement.getText());
        if (quotes != null) {
            return this.createStringLiteralAlreadyEscaped((String)quotes.first + unescaped + (String)quotes.second);
        }
        return this.createStringLiteralFromString(unescaped);
    }

    @Override
    public PyStringLiteralExpression createStringLiteralFromString(@Nullable PsiFile destination, @NotNull String unescaped, boolean preferUTF8) {
        VirtualFile vfile;
        if (unescaped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unescaped", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createStringLiteralFromString"));
        }
        boolean useDouble = !unescaped.contains("\"");
        boolean useMulti = unescaped.matches(".*(\r|\n).*");
        String quotes = useMulti ? (useDouble ? "\"\"\"" : "'''") : (useDouble ? "\"" : "'");
        StringBuilder buf = new StringBuilder(unescaped.length() * 2);
        buf.append(quotes);
        VirtualFile virtualFile = vfile = destination == null ? null : destination.getVirtualFile();
        Charset charset = vfile == null ? (preferUTF8 ? CharsetToolkit.UTF8_CHARSET : Charset.forName("US-ASCII")) : vfile.getCharset();
        CharsetEncoder encoder = charset.newEncoder();
        Formatter formatter = new Formatter(buf);
        boolean unicode = false;
        for (int i = 0; i < unescaped.length(); ++i) {
            int c = unescaped.codePointAt(i);
            if (c == 34 && useDouble) {
                buf.append("\\\"");
                continue;
            }
            if (c == 39 && !useDouble) {
                buf.append("\\'");
                continue;
            }
            if (!(c != 13 && c != 10 || useMulti)) {
                if (c == 13) {
                    buf.append("\\r");
                    continue;
                }
                if (c != 10) continue;
                buf.append("\\n");
                continue;
            }
            if (!encoder.canEncode(new String(Character.toChars(c)))) {
                if (c <= 255) {
                    formatter.format("\\x%02x", c);
                    continue;
                }
                if (c < 65535) {
                    unicode = true;
                    formatter.format("\\u%04x", c);
                    continue;
                }
                unicode = true;
                formatter.format("\\U%08x", c);
                continue;
            }
            buf.appendCodePoint(c);
        }
        buf.append(quotes);
        if (unicode) {
            buf.insert(0, "u");
        }
        return this.createStringLiteralAlreadyEscaped(buf.toString());
    }

    @Override
    public PyListLiteralExpression createListLiteral() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "[]");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        return (PyListLiteralExpression)expressionStatement.getFirstChild();
    }

    @Override
    public ASTNode createComma() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "[0,]");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        ASTNode zero = expressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return zero.getTreeNext().copyElement();
    }

    @Override
    public ASTNode createDot() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a.b");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        ASTNode dot = expressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return dot.copyElement();
    }

    @Override
    @NotNull
    public PsiElement insertItemIntoListRemoveRedundantCommas(@NotNull PyElement list, @Nullable PyExpression afterThis, @NotNull PyExpression toInsert) {
        LeafPsiElement lastComma;
        ArrayDeque commas;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "insertItemIntoListRemoveRedundantCommas"));
        }
        if (toInsert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toInsert", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "insertItemIntoListRemoveRedundantCommas"));
        }
        PsiElement result = this.insertItemIntoList(list, afterThis, toInsert);
        LeafPsiElement[] leafs = (LeafPsiElement[])PsiTreeUtil.getChildrenOfType((PsiElement)list, LeafPsiElement.class);
        if (leafs != null && !(commas = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(leafs), (Predicate)COMMAS_ONLY))).isEmpty() && PsiTreeUtil.getNextSiblingOfType((PsiElement)(lastComma = (LeafPsiElement)commas.getLast()), PyExpression.class) == null) {
            lastComma.delete();
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "insertItemIntoListRemoveRedundantCommas"));
        }
        return psiElement;
    }

    @Override
    public PsiElement insertItemIntoList(PyElement list, @Nullable PyExpression afterThis, PyExpression toInsert) throws IncorrectOperationException {
        ASTNode add = toInsert.getNode().copyElement();
        if (afterThis == null) {
            ASTNode exprNode = list.getNode();
            ASTNode[] closingTokens = exprNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LPAR}));
            if (closingTokens.length == 0) {
                exprNode.addChild(add);
            } else {
                ASTNode next = PyUtil.getNextNonWhitespace(closingTokens[closingTokens.length - 1]);
                if (next != null) {
                    ASTNode comma = this.createComma();
                    exprNode.addChild(comma, next);
                    exprNode.addChild(add, comma);
                } else {
                    exprNode.addChild(add);
                }
            }
        } else {
            ASTNode lastArgNode = afterThis.getNode();
            ASTNode comma = this.createComma();
            ASTNode parent = lastArgNode.getTreeParent();
            ASTNode afterLast = lastArgNode.getTreeNext();
            if (afterLast == null) {
                parent.addChild(add);
            } else {
                parent.addChild(add, afterLast);
            }
            parent.addChild(comma, add);
        }
        return add.getPsi();
    }

    @Override
    public PyBinaryExpression createBinaryExpression(String s, PyExpression expr, PyExpression listLiteral) {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a " + s + " b");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        PyBinaryExpression binExpr = (PyBinaryExpression)expressionStatement.getExpression();
        ASTNode binnode = binExpr.getNode();
        binnode.replaceChild(binExpr.getLeftExpression().getNode(), expr.getNode().copyElement());
        binnode.replaceChild(binExpr.getRightExpression().getNode(), listLiteral.getNode().copyElement());
        return binExpr;
    }

    @Override
    public PyExpression createExpressionFromText(String text) {
        return this.createExpressionFromText(LanguageLevel.getDefault(), text);
    }

    @Override
    @NotNull
    public PyExpression createExpressionFromText(LanguageLevel languageLevel, String text) {
        PsiFile dummyFile = this.createDummyFile(languageLevel, text);
        PsiElement element = dummyFile.getFirstChild();
        if (element instanceof PyExpressionStatement) {
            PyExpression pyExpression = ((PyExpressionStatement)element).getExpression();
            if (pyExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createExpressionFromText"));
            }
            return pyExpression;
        }
        throw new IncorrectOperationException("could not parse text as expression: " + text);
    }

    @Override
    @NotNull
    public PyCallExpression createCallExpression(LanguageLevel langLevel, String functionName) {
        PsiElement element;
        PsiFile dummyFile = this.createDummyFile(langLevel, functionName + "()");
        PsiElement child = dummyFile.getFirstChild();
        if (child != null && (element = child.getFirstChild()) instanceof PyCallExpression) {
            PyCallExpression pyCallExpression = (PyCallExpression)element;
            if (pyCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createCallExpression"));
            }
            return pyCallExpression;
        }
        throw new IllegalArgumentException("Invalid call expression text " + functionName);
    }

    @Override
    public PyImportElement createImportElement(LanguageLevel languageLevel, String name) {
        return this.createFromText(languageLevel, PyImportElement.class, "from foo import " + name, new int[]{0, 6});
    }

    @Override
    public PyFunction createProperty(LanguageLevel languageLevel, String propertyName, String fieldName, AccessDirection accessDirection) {
        String propertyText = accessDirection == AccessDirection.DELETE ? "@" + propertyName + ".deleter\ndef " + propertyName + "(self):\n  del self." + fieldName : (accessDirection == AccessDirection.WRITE ? "@" + propertyName + ".setter\ndef " + propertyName + "(self, value):\n  self." + fieldName + " = value" : "@property\ndef " + propertyName + "(self):\n  return self." + fieldName);
        return this.createFromText(languageLevel, PyFunction.class, propertyText);
    }

    @Override
    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text) {
        T t = this.createFromText(langLevel, aClass, text, FROM_ROOT);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromText"));
        }
        return t;
    }

    @Override
    @NotNull
    public <T> T createPhysicalFromText(LanguageLevel langLevel, Class<T> aClass, String text) {
        T t = this.createFromText(langLevel, aClass, text, FROM_ROOT, true);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createPhysicalFromText"));
        }
        return t;
    }

    @Override
    public PyNamedParameter createParameter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createParameter"));
        }
        return this.createParameter(name, null, null, LanguageLevel.getDefault());
    }

    @Override
    public PyNamedParameter createParameter(@NotNull String name, @Nullable String defaultValue, @Nullable String annotation, @NotNull LanguageLevel languageLevel) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createParameter"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createParameter"));
        }
        String parameterText = name;
        if (annotation != null) {
            parameterText = parameterText + ": " + annotation;
        }
        if (defaultValue != null) {
            parameterText = parameterText + " = " + defaultValue;
        }
        return this.createFromText(languageLevel, PyNamedParameter.class, "def f(" + parameterText + "): pass", PATH_PARAMETER);
    }

    @Override
    public PyKeywordArgument createKeywordArgument(LanguageLevel languageLevel, String keyword, String value) {
        PyCallExpression callExpression = (PyCallExpression)this.createExpressionFromText(languageLevel, "foo(" + keyword + "=" + value + ")");
        return (PyKeywordArgument)callExpression.getArguments()[0];
    }

    @Override
    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text, int[] path) {
        T t = this.createFromText(langLevel, aClass, text, path, false);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromText"));
        }
        return t;
    }

    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text, int[] path, boolean physical) {
        PsiFile psiFile;
        PsiFile ret = this.createDummyFile(langLevel, text, physical);
        block2: for (int skip : path) {
            if (ret == null) break;
            ret = ret.getFirstChild();
            for (int i = 0; i < skip; ++i) {
                if (ret == null) {
                    ret = null;
                    continue block2;
                }
                ret = ret.getNextSibling();
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Can't find element matching path " + Arrays.toString(path) + " in text '" + text + "'");
        }
        try {
            psiFile = ret;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Can't create an expression of type " + aClass + " from text '" + text + "'");
        }
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromText"));
        }
        return (T)psiFile;
    }

    @Override
    public PyPassStatement createPassStatement() {
        PyStatementList statementList = this.createPassStatementList();
        return (PyPassStatement)statementList.getStatements()[0];
    }

    @Override
    @NotNull
    public PyDecoratorList createDecoratorList(String ... decoratorTexts) {
        if (decoratorTexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratorTexts", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createDecoratorList"));
        }
        assert (decoratorTexts.length > 0);
        StringBuilder functionText = new StringBuilder();
        for (String decoText : decoratorTexts) {
            functionText.append(decoText).append("\n");
        }
        functionText.append("def foo():\n\tpass");
        PyFunction function = this.createFromText(LanguageLevel.getDefault(), PyFunction.class, functionText.toString());
        PyDecoratorList decoratorList = function.getDecoratorList();
        assert (decoratorList != null);
        PyDecoratorList pyDecoratorList = decoratorList;
        if (pyDecoratorList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createDecoratorList"));
        }
        return pyDecoratorList;
    }

    private PyStatementList createPassStatementList() {
        PyFunction function = this.createFromText(LanguageLevel.getDefault(), PyFunction.class, "def foo():\n\tpass");
        return function.getStatementList();
    }

    @Override
    public PyExpressionStatement createDocstring(String content) {
        return this.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, content + "\n");
    }

    @Override
    @NotNull
    public PsiElement createNewLine() {
        PsiElement psiElement = (PsiElement)this.createFromText(LanguageLevel.getDefault(), PsiWhiteSpace.class, " \n\n ");
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createNewLine"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PyFromImportStatement createFromImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String qualifier, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromImportStatement"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromImportStatement"));
        }
        String asClause = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String statement = "from " + qualifier + " import " + name + asClause;
        PyFromImportStatement pyFromImportStatement = this.createFromText(languageLevel, PyFromImportStatement.class, statement);
        if (pyFromImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createFromImportStatement"));
        }
        return pyFromImportStatement;
    }

    @Override
    @NotNull
    public PyImportStatement createImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createImportStatement"));
        }
        String asClause = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String statement = "import " + name + asClause;
        PyImportStatement pyImportStatement = this.createFromText(languageLevel, PyImportStatement.class, statement);
        if (pyImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl", "createImportStatement"));
        }
        return pyImportStatement;
    }

    private static class CommasOnly
    extends NotNullPredicate<LeafPsiElement> {
        private CommasOnly() {
        }

        @Override
        protected boolean applyNotNull(@NotNull LeafPsiElement input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl$CommasOnly", "applyNotNull"));
            }
            return input.getNode().getElementType().equals((Object)PyTokenTypes.COMMA);
        }
    }
}

