/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyDecoratorStub;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDecoratorImpl
extends StubBasedPsiElementBase<PyDecoratorStub>
implements PyDecorator {
    public PyDecoratorImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyDecoratorImpl(PyDecoratorStub stub) {
        super(stub, PyElementTypes.DECORATOR_CALL);
    }

    @Override
    public String getName() {
        QualifiedName qname = this.getQualifiedName();
        return qname != null ? qname.getLastComponent() : null;
    }

    @Override
    @Nullable
    public PyFunction getTarget() {
        return (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)this, PyFunction.class);
    }

    @Override
    public boolean isBuiltin() {
        ASTNode node = this.getNode().findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens());
        if (node != null) {
            PyReferenceExpression ref = (PyReferenceExpression)node.getPsi();
            PsiElement target = ref.getReference().resolve();
            return PyBuiltinCache.getInstance((PsiElement)this).isBuiltin(target);
        }
        return false;
    }

    @Override
    public boolean hasArgumentList() {
        ASTNode arglistNode = this.getNode().findChildByType((IElementType)PyElementTypes.ARGUMENT_LIST);
        return arglistNode != null && arglistNode.findChildByType((IElementType)PyTokenTypes.LPAR) != null;
    }

    @Override
    public QualifiedName getQualifiedName() {
        PyDecoratorStub stub = (PyDecoratorStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PyReferenceExpression node = (PyReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)this, PyReferenceExpression.class);
        if (node != null) {
            return node.asQualifiedName();
        }
        return null;
    }

    @Override
    public PyExpression getCallee() {
        try {
            return (PyExpression)this.getFirstChild().getNextSibling();
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @Override
    @Nullable
    public PyArgumentList getArgumentList() {
        return (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
    }

    @Override
    @NotNull
    public PyExpression[] getArguments() {
        PyArgumentList argList = this.getArgumentList();
        PyExpression[] pyExpressionArray = argList != null ? argList.getArguments() : PyExpression.EMPTY_ARRAY;
        if (pyExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "getArguments"));
        }
        return pyExpressionArray;
    }

    @Override
    public <T extends PsiElement> T getArgument(int index, Class<T> argClass) {
        PyExpression[] args = this.getArguments();
        return (T)(args.length > index && argClass.isInstance(args[index]) ? (PsiElement)argClass.cast(args[index]) : null);
    }

    @Override
    public <T extends PsiElement> T getArgument(int index, String keyword, Class<T> argClass) {
        PyExpression argument = this.getKeywordArgument(keyword);
        if (argument != null) {
            return (T)(argClass.isInstance(argument) ? (PsiElement)argClass.cast(argument) : null);
        }
        return this.getArgument(index, argClass);
    }

    @Override
    @Nullable
    public <T extends PsiElement> T getArgument(@NotNull FunctionParameter parameter, @NotNull Class<T> argClass) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "getArgument"));
        }
        if (argClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argClass", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "getArgument"));
        }
        return PyCallExpressionHelper.getArgument(parameter, argClass, this);
    }

    @Override
    public PyExpression getKeywordArgument(String keyword) {
        return PyCallExpressionHelper.getKeywordArgument(this, keyword);
    }

    @Override
    public void addArgument(PyExpression expression) {
        PyCallExpressionHelper.addArgument(this, expression);
    }

    @Override
    public PyCallExpression.PyMarkedCallee resolveCallee(PyResolveContext resolveContext) {
        return this.resolveCallee(resolveContext, 0);
    }

    @Override
    public PyCallExpression.PyMarkedCallee resolveCallee(PyResolveContext resolveContext, int offset) {
        PyCallExpression.PyMarkedCallee callee = PyCallExpressionHelper.resolveCallee(this, resolveContext);
        if (callee == null) {
            return null;
        }
        if (!this.hasArgumentList()) {
            callee = new PyCallExpression.PyMarkedCallee(callee.getCallable(), callee.getModifier(), callee.getImplicitOffset() + 1, callee.isImplicitlyResolved());
        }
        return callee;
    }

    @Override
    public Callable resolveCalleeFunction(PyResolveContext resolveContext) {
        return PyCallExpressionHelper.resolveCalleeFunction(this, resolveContext);
    }

    @Override
    public boolean isCalleeText(String ... nameCandidates) {
        if (nameCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCandidates", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "isCalleeText"));
        }
        return PyCallExpressionHelper.isCalleeText(this, nameCandidates);
    }

    @Override
    public boolean isCallee(FQNamesProvider ... name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "isCallee"));
        }
        return PyCallExpressionHelper.isCallee(this, name);
    }

    public String toString() {
        return "PyDecorator: @" + PyUtil.getReadableRepr((PsiElement)this.getCallee(), true);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "setName"));
        }
        ASTNode node = this.getNode();
        ASTNode nameNode = node.findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
        if (nameNode != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            node.replaceChild(nameNode, nameElement);
            return this;
        }
        throw new IncorrectOperationException("No name node");
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyDecoratorImpl", "getType"));
        }
        return PyCallExpressionHelper.getCallType(this, context);
    }
}

