/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConditionalExpressionImpl
extends PyElementImpl
implements PyConditionalExpression {
    public PyConditionalExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyConditionalExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyConditionalExpressionImpl", "getType"));
        }
        PyExpression truePart = this.getTruePart();
        PyExpression falsePart = this.getFalsePart();
        if (truePart == null || falsePart == null) {
            return null;
        }
        return PyUnionType.union(context.getType(truePart), context.getType(falsePart));
    }

    @Override
    public PyExpression getTruePart() {
        List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PyExpression.class);
        return (PyExpression)expressions.get(0);
    }

    @Override
    public PyExpression getCondition() {
        List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PyExpression.class);
        return expressions.size() > 1 ? (PyExpression)expressions.get(1) : null;
    }

    @Override
    public PyExpression getFalsePart() {
        List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PyExpression.class);
        return expressions.size() == 3 ? (PyExpression)expressions.get(2) : null;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyConditionalExpression(this);
    }
}

