/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.ComprehensionComponent;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.ComprhIfComponent;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyComprehensionElementImpl
extends PyElementImpl
implements PyComprehensionElement {
    public PyComprehensionElementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @Nullable
    public PyExpression getResultExpression() {
        ASTNode[] exprs = this.getNode().getChildren(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        return exprs.length == 0 ? null : (PyExpression)exprs[0].getPsi();
    }

    @Override
    public List<ComprhForComponent> getForComponents() {
        final ArrayList<ComprhForComponent> list = new ArrayList<ComprhForComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitForComponent(ComprhForComponent component) {
                list.add(component);
            }
        });
        return list;
    }

    private void visitComponents(ComprehensionElementVisitor visitor) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            ASTNode next = PyComprehensionElementImpl.getNextExpression(node);
            if (next == null) break;
            if (type == PyTokenTypes.FOR_KEYWORD) {
                ASTNode next2 = PyComprehensionElementImpl.getNextExpression(next);
                if (next2 == null) break;
                final PyExpression variable = (PyExpression)next.getPsi();
                final PyExpression iterated = (PyExpression)next2.getPsi();
                visitor.visitForComponent(new ComprhForComponent(){

                    @Override
                    public PyExpression getIteratorVariable() {
                        return variable;
                    }

                    @Override
                    public PyExpression getIteratedList() {
                        return iterated;
                    }
                });
                continue;
            }
            if (type != PyTokenTypes.IF_KEYWORD) continue;
            final PyExpression test = (PyExpression)next.getPsi();
            visitor.visitIfComponent(new ComprhIfComponent(){

                @Override
                public PyExpression getTest() {
                    return test;
                }
            });
        }
    }

    @Override
    public List<ComprhIfComponent> getIfComponents() {
        final ArrayList<ComprhIfComponent> list = new ArrayList<ComprhIfComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitIfComponent(ComprhIfComponent component) {
                list.add(component);
            }
        });
        return list;
    }

    @Override
    public List<ComprehensionComponent> getComponents() {
        final ArrayList<ComprehensionComponent> list = new ArrayList<ComprehensionComponent>(5);
        this.visitComponents(new ComprehensionElementVisitor(){

            @Override
            void visitForComponent(ComprhForComponent component) {
                list.add(component);
            }

            @Override
            void visitIfComponent(ComprhIfComponent component) {
                list.add(component);
            }
        });
        return list;
    }

    @Nullable
    private static ASTNode getNextExpression(ASTNode after) {
        ASTNode node = after;
        while ((node = node.getTreeNext()) != null && !PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens().contains(node.getElementType())) {
        }
        return node;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        List<ComprhForComponent> fors = this.getForComponents();
        PyExpression[] for_targets = new PyExpression[fors.size()];
        int i = 0;
        for (ComprhForComponent for_comp : fors) {
            for_targets[i] = for_comp.getIteratorVariable();
            ++i;
        }
        ArrayList<PyElement> arrayList = new ArrayList<PyElement>(PyUtil.flattenedParensAndLists(for_targets));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyComprehensionElementImpl", "iterateNames"));
        }
        return arrayList;
    }

    @Override
    public PsiElement getElementNamed(String the_name) {
        return NameDefiner.IterHelper.findName(this.iterateNames(), the_name);
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }

    abstract class ComprehensionElementVisitor {
        ComprehensionElementVisitor() {
        }

        void visitIfComponent(ComprhIfComponent component) {
        }

        void visitForComponent(ComprhForComponent component) {
        }
    }
}

