/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PropertyBunch;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PropertyStubStorage;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassImpl
extends PyBaseElementImpl<PyClassStub>
implements PyClass {
    public static final PyClass[] EMPTY_ARRAY = new PyClassImpl[0];
    private List<PyTargetExpression> myInstanceAttributes;
    private final NotNullLazyValue<CachedValue<Boolean>> myNewStyle;
    private volatile Map<String, Property> myPropertyCache;
    private final Key<ParameterizedCachedValue<List<PyClassLikeType>, TypeEvalContext>> myCachedValueKey;
    private final CachedAncestorsProvider myCachedAncestorsProvider;
    private static final Maybe<Callable> UNKNOWN_CALL = new Maybe();
    private static final Maybe<Callable> NONE = new Maybe<Object>(null);

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyClassImpl", "getType"));
        }
        return new PyClassTypeImpl(this, true);
    }

    public PyClassImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/jetbrains/python/psi/impl/PyClassImpl", "<init>"));
        }
        super(astNode);
        this.myNewStyle = new NotNullLazyValue<CachedValue<Boolean>>(){

            @NotNull
            protected CachedValue<Boolean> compute() {
                CachedValue cachedValue = CachedValuesManager.getManager((Project)PyClassImpl.this.getProject()).createCachedValue((CachedValueProvider)new NewStyleCachedValueProvider(), false);
                if (cachedValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$1", "compute"));
                }
                return cachedValue;
            }
        };
        this.myCachedValueKey = Key.create((String)"cached ancestors");
        this.myCachedAncestorsProvider = new CachedAncestorsProvider();
    }

    public PyClassImpl(@NotNull PyClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/PyClassImpl", "<init>"));
        }
        this(stub, (IStubElementType)PyElementTypes.CLASS_DECLARATION);
    }

    public PyClassImpl(@NotNull PyClassStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/PyClassImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/jetbrains/python/psi/impl/PyClassImpl", "<init>"));
        }
        super(stub, nodeType);
        this.myNewStyle = new /* invalid duplicate definition of identical inner class */;
        this.myCachedValueKey = Key.create((String)"cached ancestors");
        this.myCachedAncestorsProvider = new CachedAncestorsProvider();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyClassImpl", "setName"));
        }
        ASTNode nameElement = PyUtil.createNewName(this, name);
        ASTNode node = this.getNameNode();
        if (node != null) {
            this.getNode().replaceChild(node, nameElement);
        }
        return this;
    }

    @Override
    @Nullable
    public String getName() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @Override
    public ASTNode getNameNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.CLASS_ICON;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyClass(this);
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        PyStatementList statementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (statementList != null) : "Statement list missing for class " + this.getText();
        PyStatementList pyStatementList = statementList;
        if (pyStatementList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getStatementList"));
        }
        return pyStatementList;
    }

    @Override
    public PyArgumentList getSuperClassExpressionList() {
        PyArgumentList argList = (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
        if (argList != null && argList.getFirstChild() != null) {
            return argList;
        }
        return null;
    }

    @Override
    @NotNull
    public PyExpression[] getSuperClassExpressions() {
        PyArgumentList argList = this.getSuperClassExpressionList();
        if (argList != null) {
            PyExpression[] pyExpressionArray = argList.getArguments();
            if (pyExpressionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClassExpressions"));
            }
            return pyExpressionArray;
        }
        if (PyExpression.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClassExpressions"));
        }
        return PyExpression.EMPTY_ARRAY;
    }

    @NotNull
    public static PyExpression unfoldClass(@NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyClassImpl", "unfoldClass"));
        }
        if (expression instanceof PyCallExpression) {
            PyExpression secondArgument;
            PyCallExpression call = (PyCallExpression)expression;
            PyExpression callee = call.getCallee();
            PyExpression[] arguments = call.getArguments();
            if (callee != null && "with_metaclass".equals(callee.getName()) && arguments.length > 1 && (secondArgument = arguments[1]) != null) {
                PyExpression pyExpression = secondArgument;
                if (pyExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "unfoldClass"));
                }
                return pyExpression;
            }
        } else if (expression instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)expression;
            PyExpression pyExpression = subscriptionExpr.getOperand();
            if (pyExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "unfoldClass"));
            }
            return pyExpression;
        }
        PyExpression pyExpression = expression;
        if (pyExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "unfoldClass"));
        }
        return pyExpression;
    }

    @Override
    @NotNull
    public List<PyClass> getAncestorClasses() {
        List<PyClass> list = this.getAncestorClasses(TypeEvalContext.codeInsightFallback(this.getProject()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getAncestorClasses"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyClass> getAncestorClasses(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getAncestorClasses"));
        }
        ArrayList<PyClass> results = new ArrayList<PyClass>();
        for (PyClassLikeType type : this.getAncestorTypes(context)) {
            if (!(type instanceof PyClassType)) continue;
            results.add(((PyClassType)type).getPyClass());
        }
        ArrayList<PyClass> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getAncestorClasses"));
        }
        return arrayList;
    }

    @Override
    public boolean isSubclass(PyClass parent) {
        if (this == parent) {
            return true;
        }
        for (PyClass superclass : this.getAncestorClasses()) {
            if (parent != superclass) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubclass(@NotNull String superClassQName) {
        if (superClassQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassQName", "com/jetbrains/python/psi/impl/PyClassImpl", "isSubclass"));
        }
        if (superClassQName.equals(this.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : this.getAncestorTypes(TypeEvalContext.codeInsightFallback(this.getProject()))) {
            if (type == null || !superClassQName.equals(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public PyDecoratorList getDecoratorList() {
        return this.getStubOrPsiChild(PyElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    public List<String> getSlots() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        boolean found = false;
        List<String> ownSlots = this.getOwnSlots();
        if (ownSlots != null) {
            found = true;
            result.addAll(ownSlots);
        }
        for (PyClass cls : this.getAncestorClasses()) {
            List<String> ancestorSlots = cls.getOwnSlots();
            if (ancestorSlots == null) continue;
            found = true;
            result.addAll(ancestorSlots);
        }
        return found ? new ArrayList(result) : null;
    }

    @Override
    @Nullable
    public List<String> getOwnSlots() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getSlots();
        }
        return PyFileImpl.getStringListFromTargetExpression("__slots__", this.getClassAttributes());
    }

    @Override
    @NotNull
    public PyClass[] getSuperClasses() {
        List<PyClassLikeType> superTypes = this.getSuperClassTypes(TypeEvalContext.codeInsightFallback(this.getProject()));
        if (superTypes.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClasses"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PyClass> result = new ArrayList<PyClass>();
        for (PyClassLikeType type : superTypes) {
            if (!(type instanceof PyClassType)) continue;
            result.add(((PyClassType)type).getPyClass());
        }
        PyClass[] pyClassArray = result.toArray(new PyClass[result.size()]);
        if (pyClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClasses"));
        }
        return pyClassArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @Nullable
            public String getPresentableText() {
                if (!PyClassImpl.this.isValid()) {
                    return null;
                }
                StringBuilder result = new StringBuilder(StringUtil.notNullize((String)PyClassImpl.this.getName(), (String)"<unnamed>"));
                PyExpression[] superClassExpressions = PyClassImpl.this.getSuperClassExpressions();
                if (superClassExpressions.length > 0) {
                    result.append("(");
                    result.append(StringUtil.join(Arrays.asList(superClassExpressions), (Function)new Function<PyExpression, String>(){

                        public String fun(PyExpression expr) {
                            String name = expr.getText();
                            return StringUtil.notNullize((String)name, (String)"<unnamed>");
                        }
                    }, (String)", "));
                    result.append(")");
                }
                return result.toString();
            }
        };
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    private static List<PyClassLikeType> mroMerge(@NotNull List<List<PyClassLikeType>> sequences) throws MROException {
        if (sequences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"sequences", "com/jetbrains/python/psi/impl/PyClassImpl", "mroMerge"}));
        }
        result = new LinkedList<PyClassLikeType>();
        block0: while (true) {
            nonBlankSequences = new ArrayList<List<PyClassLikeType>>(sequences.size());
            for (List<PyClassLikeType> item : sequences) {
                if (item.size() <= 0) continue;
                nonBlankSequences.add(item);
            }
            if (nonBlankSequences.isEmpty()) {
                v0 = result;
                if (v0 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/jetbrains/python/psi/impl/PyClassImpl", "mroMerge"}));
                }
                return v0;
            }
            found = false;
            head = null;
            for (List seq : nonBlankSequences) {
                head = (PyClassLikeType)seq.get(0);
                if (head == null) {
                    seq.remove(0);
                    found = true;
                    break;
                }
                head_in_tails = false;
                for (List tail_seq : nonBlankSequences) {
                    if (tail_seq.indexOf(head) <= 0) continue;
                    head_in_tails = true;
                    break;
                }
                if (!head_in_tails) {
                    found = true;
                    break;
                }
                head = null;
            }
            if (!found) {
                throw new MROException("Inconsistent class hierarchy");
            }
            result.add(head);
            if (head == null) continue;
            i$ = nonBlankSequences.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block0;
                seq = (List)i$.next();
                if (!Comparing.equal(seq.get(0), (Object)head)) continue;
                seq.remove(0);
            }
            break;
        }
    }

    @NotNull
    private static List<PyClassLikeType> mroLinearize(@NotNull PyClassLikeType type, @NotNull Set<PyClassLikeType> seen, boolean addThisType, @NotNull TypeEvalContext context) throws MROException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/impl/PyClassImpl", "mroLinearize"));
        }
        if (seen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seen", "com/jetbrains/python/psi/impl/PyClassImpl", "mroLinearize"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "mroLinearize"));
        }
        if (seen.contains(type)) {
            throw new MROException("Circular class inheritance");
        }
        List<PyClassLikeType> bases = type.getSuperClassTypes(context);
        ArrayList<List<PyClassLikeType>> lines = new ArrayList<List<PyClassLikeType>>();
        for (PyClassLikeType base : bases) {
            if (base == null) continue;
            HashSet<PyClassLikeType> newSeen = new HashSet<PyClassLikeType>(seen);
            newSeen.add(type);
            List<PyClassLikeType> lin = PyClassImpl.mroLinearize(base, newSeen, true, context);
            if (lin.isEmpty()) continue;
            lines.add(lin);
        }
        if (!bases.isEmpty()) {
            lines.add(bases);
        }
        List<PyClassLikeType> result = PyClassImpl.mroMerge(lines);
        if (addThisType) {
            result.add(0, type);
        }
        List<PyClassLikeType> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "mroLinearize"));
        }
        return list;
    }

    @Override
    @NotNull
    public PyFunction[] getMethods(boolean inherited) {
        PyFunction[] thisClassFunctions = (PyFunction[])this.getClassChildren(PythonDialectsTokenSetProvider.INSTANCE.getFunctionDeclarationTokens(), PyFunction.ARRAY_FACTORY);
        if (!inherited) {
            if (thisClassFunctions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getMethods"));
            }
            return thisClassFunctions;
        }
        HashMap<String, StubBasedPsiElement<PyClassStub>> result = new HashMap<String, StubBasedPsiElement<PyClassStub>>();
        for (PyClass pyClass : this.getSuperClasses()) {
            for (PyFunction function : pyClass.getMethods(false)) {
                String functionName = function.getName();
                if (functionName == null) continue;
                result.put(functionName, function);
            }
        }
        for (StubBasedPsiElement<PyClassStub> stubBasedPsiElement : thisClassFunctions) {
            String functionName = stubBasedPsiElement.getName();
            if (functionName == null) continue;
            result.put(functionName, stubBasedPsiElement);
        }
        Collection functionsToReturn = result.values();
        PyFunction[] pyFunctionArray = functionsToReturn.toArray(new PyFunction[functionsToReturn.size()]);
        if (pyFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getMethods"));
        }
        return pyFunctionArray;
    }

    @Override
    @NotNull
    public Map<String, Property> getProperties() {
        this.initProperties();
        HashMap<String, Property> hashMap = new HashMap<String, Property>(this.myPropertyCache);
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getProperties"));
        }
        return hashMap;
    }

    @Override
    public PyClass[] getNestedClasses() {
        return (PyClass[])this.getClassChildren(TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.CLASS_DECLARATION}), PyClass.ARRAY_FACTORY);
    }

    protected <T extends PsiElement> T[] getClassChildren(TokenSet elementTypes, ArrayFactory<T> factory) {
        PyClassStub classStub = (PyClassStub)this.getStub();
        if (classStub != null) {
            return classStub.getChildrenByType(elementTypes, factory);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PyStatementList statementList = this.getStatementList();
        for (PsiElement element : statementList.getChildren()) {
            if (!elementTypes.contains(element.getNode().getElementType())) continue;
            result.add(element);
        }
        return (PsiElement[])result.toArray(factory.create(result.size()));
    }

    @Override
    public PyFunction findMethodByName(@Nullable String name, boolean inherited) {
        if (name == null) {
            return null;
        }
        NameFinder<PyFunction> proc = new NameFinder<PyFunction>(name);
        this.visitMethods(proc, inherited);
        return proc.getResult();
    }

    @Override
    @Nullable
    public PyClass findNestedClass(String name, boolean inherited) {
        if (name == null) {
            return null;
        }
        NameFinder<PyClass> proc = new NameFinder<PyClass>(name);
        this.visitNestedClasses(proc, inherited);
        return proc.getResult();
    }

    @Override
    @Nullable
    public PyFunction findInitOrNew(boolean inherited) {
        NameFinder<PyFunction> proc = this.isNewStyleClass() ? new NameFinder("__init__", "__new__") : new NameFinder<PyFunction>("__init__");
        this.visitMethods(proc, inherited, true);
        return proc.getResult();
    }

    @Nullable
    private Property processPropertiesInClass(@Nullable String name, @Nullable Processor<Property> property_filter, boolean advanced) {
        Property prop = this.processDecoratedProperties(name, property_filter, advanced);
        if (prop != null) {
            return prop;
        }
        if (this.getStub() != null) {
            prop = this.processStubProperties(name, property_filter);
            if (prop != null) {
                return prop;
            }
        } else {
            for (PyTargetExpression target : this.getClassAttributes()) {
                if (name != null && !name.equals(target.getName()) || (prop = PropertyImpl.fromTarget(target)) == null || property_filter != null && !property_filter.process((Object)prop)) continue;
                return prop;
            }
        }
        return null;
    }

    @Nullable
    private Property processDecoratedProperties(@Nullable String name, @Nullable Processor<Property> filter, boolean useAdvancedSyntax) {
        HashMap<String, List> grouped = new HashMap<String, List>();
        for (PyFunction method : this.getMethods(false)) {
            String methodName = method.getName();
            if (name != null && !name.equals(methodName)) continue;
            List bucket = (List)grouped.get(methodName);
            if (bucket == null) {
                bucket = new SmartList();
                grouped.put(methodName, bucket);
            }
            bucket.add(method);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            Maybe<Callable> getter = NONE;
            Maybe<Callable> setter = NONE;
            Maybe<Callable> deleter = NONE;
            String doc = null;
            String decoratorName = (String)entry.getKey();
            for (PyFunction method : (List)entry.getValue()) {
                PyDecoratorList decoratorList = method.getDecoratorList();
                if (decoratorList != null) {
                    for (PyDecorator deco : decoratorList.getDecorators()) {
                        QualifiedName qname = deco.getQualifiedName();
                        if (qname == null) continue;
                        String decoName = qname.toString();
                        for (PyKnownDecoratorProvider provider : PyUtil.KnownDecoratorProviderHolder.KNOWN_DECORATOR_PROVIDERS) {
                            String knownName = provider.toKnownDecorator(decoName);
                            if (knownName == null) continue;
                            decoName = knownName;
                        }
                        if ("property".equals(decoName)) {
                            getter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (useAdvancedSyntax && qname.matches(new String[]{decoratorName, "getter"})) {
                            getter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (useAdvancedSyntax && qname.matches(new String[]{decoratorName, "setter"})) {
                            setter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (!useAdvancedSyntax || !qname.matches(new String[]{decoratorName, "deleter"})) continue;
                        deleter = new Maybe<PyFunction>(method);
                    }
                }
                if (getter == NONE || setter == NONE || deleter == NONE) continue;
                break;
            }
            if (getter == NONE && setter == NONE && deleter == NONE) continue;
            PropertyImpl prop = new PropertyImpl(decoratorName, getter, setter, deleter, doc, null);
            if (filter != null && !filter.process((Object)prop)) continue;
            return prop;
        }
        return null;
    }

    private Maybe<Callable> fromPacked(Maybe<String> maybeName) {
        if (maybeName.isDefined()) {
            String value = maybeName.value();
            if (value == null || "None".equals(value)) {
                return NONE;
            }
            PyFunction method = this.findMethodByName(value, true);
            if (method != null) {
                return new Maybe<Callable>(method);
            }
        }
        return UNKNOWN_CALL;
    }

    @Nullable
    private Property processStubProperties(@Nullable String name, @Nullable Processor<Property> propertyProcessor) {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            for (StubElement subStub : stub.getChildrenStubs()) {
                PyTargetExpressionStub targetStub;
                PropertyStubStorage prop;
                if (subStub.getStubType() != PyElementTypes.TARGET_EXPRESSION || (prop = (targetStub = (PyTargetExpressionStub)subStub).getCustomStub(PropertyStubStorage.class)) == null || name != null && !name.equals(targetStub.getName())) continue;
                Maybe<Callable> getter = this.fromPacked(prop.getGetter());
                Maybe<Callable> setter = this.fromPacked(prop.getSetter());
                Maybe<Callable> deleter = this.fromPacked(prop.getDeleter());
                String doc = prop.getDoc();
                if (getter == NONE && setter == NONE && deleter == NONE) continue;
                PropertyImpl property = new PropertyImpl(targetStub.getName(), getter, setter, deleter, doc, (PyTargetExpression)targetStub.getPsi());
                if (propertyProcessor != null && !propertyProcessor.process((Object)property)) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Property findProperty(@NotNull String name, boolean inherited) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyClassImpl", "findProperty"));
        }
        Property property = this.findLocalProperty(name);
        if (property != null) {
            return property;
        }
        if (this.findMethodByName(name, false) != null || this.findClassAttribute(name, false) != null) {
            return null;
        }
        if (inherited) {
            for (PyClass aClass : this.getAncestorClasses()) {
                Property ancestorProperty = ((PyClassImpl)aClass).findLocalProperty(name);
                if (ancestorProperty == null) continue;
                return ancestorProperty;
            }
        }
        return null;
    }

    @Override
    public Property findPropertyByCallable(Callable callable) {
        this.initProperties();
        for (Property property : this.myPropertyCache.values()) {
            if (property.getGetter().valueOrNull() != callable && property.getSetter().valueOrNull() != callable && property.getDeleter().valueOrNull() != callable) continue;
            return property;
        }
        return null;
    }

    private Property findLocalProperty(String name) {
        this.initProperties();
        return this.myPropertyCache.get(name);
    }

    private synchronized void initProperties() {
        if (this.myPropertyCache == null) {
            this.myPropertyCache = this.initializePropertyCache();
        }
    }

    private Map<String, Property> initializePropertyCache() {
        final HashMap<String, Property> result = new HashMap<String, Property>();
        this.processProperties(null, new Processor<Property>(){

            public boolean process(Property property) {
                result.put(property.getName(), property);
                return false;
            }
        }, false);
        return result;
    }

    @Override
    @Nullable
    public Property scanProperties(@Nullable Processor<Property> filter, boolean inherited) {
        return this.processProperties(null, filter, inherited);
    }

    @Nullable
    private Property processProperties(@Nullable String name, @Nullable Processor<Property> filter, boolean inherited) {
        boolean useAdvancedSyntax;
        Property local;
        PsiFile file;
        if (!this.isValid()) {
            return null;
        }
        LanguageLevel level = LanguageLevel.getDefault();
        PsiFile psiFile = file = this.getParentByStub() != null ? this.getContainingFile() : null;
        if (file != null) {
            level = LanguageLevel.forElement((PsiElement)file);
        }
        if ((local = this.processPropertiesInClass(name, filter, useAdvancedSyntax = level.isAtLeast(LanguageLevel.PYTHON26))) != null) {
            return local;
        }
        if (inherited) {
            if (name != null && (this.findMethodByName(name, false) != null || this.findClassAttribute(name, false) != null)) {
                return null;
            }
            for (PyClass cls : this.getAncestorClasses()) {
                Property property = ((PyClassImpl)cls).processPropertiesInClass(name, filter, useAdvancedSyntax);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    public boolean visitMethods(Processor<PyFunction> processor, boolean inherited) {
        return this.visitMethods(processor, inherited, false);
    }

    public boolean visitMethods(Processor<PyFunction> processor, boolean inherited, boolean skipClassObj) {
        Object[] methods = this.getMethods(false);
        if (!ContainerUtil.process((Object[])methods, processor)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses()) {
                if (skipClassObj && "___Classobj".equals(ancestor.getName()) || ancestor.visitMethods(processor, false)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean visitNestedClasses(Processor<PyClass> processor, boolean inherited) {
        Object[] nestedClasses = this.getNestedClasses();
        if (!ContainerUtil.process((Object[])nestedClasses, processor)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses()) {
                if (((PyClassImpl)ancestor).visitNestedClasses(processor, false)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visitClassAttributes(Processor<PyTargetExpression> processor, boolean inherited) {
        List<PyTargetExpression> methods = this.getClassAttributes();
        if (!ContainerUtil.process(methods, processor)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses()) {
                if (ancestor.visitClassAttributes(processor, false)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<PyTargetExpression> getClassAttributes() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            PyTargetExpression[] children = (PyTargetExpression[])stub.getChildrenByType((IElementType)PyElementTypes.TARGET_EXPRESSION, (PsiElement[])PyTargetExpression.EMPTY_ARRAY);
            return Arrays.asList(children);
        }
        ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        for (PsiElement psiElement : this.getStatementList().getChildren()) {
            PyExpression[] targets;
            if (!(psiElement instanceof PyAssignmentStatement)) continue;
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)psiElement;
            for (PyExpression target : targets = assignmentStatement.getTargets()) {
                if (!(target instanceof PyTargetExpression)) continue;
                result.add((PyTargetExpression)target);
            }
        }
        return result;
    }

    @Override
    public PyTargetExpression findClassAttribute(@NotNull String name, boolean inherited) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyClassImpl", "findClassAttribute"));
        }
        NameFinder<PyTargetExpression> processor = new NameFinder<PyTargetExpression>(name);
        this.visitClassAttributes(processor, inherited);
        return processor.getResult();
    }

    @Override
    public List<PyTargetExpression> getInstanceAttributes() {
        if (this.myInstanceAttributes == null) {
            this.myInstanceAttributes = this.collectInstanceAttributes();
        }
        return this.myInstanceAttributes;
    }

    @Override
    @Nullable
    public PyTargetExpression findInstanceAttribute(String name, boolean inherited) {
        List<PyTargetExpression> instanceAttributes = this.getInstanceAttributes();
        for (PyTargetExpression instanceAttribute : instanceAttributes) {
            if (!name.equals(instanceAttribute.getReferencedName())) continue;
            return instanceAttribute;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses()) {
                PyTargetExpression attribute = ancestor.findInstanceAttribute(name, false);
                if (attribute == null) continue;
                return attribute;
            }
        }
        return null;
    }

    private List<PyTargetExpression> collectInstanceAttributes() {
        PyFunction[] methods;
        HashMap<String, PyTargetExpression> result = new HashMap<String, PyTargetExpression>();
        this.collectAttributesInNew(result);
        PyFunctionImpl initMethod = (PyFunctionImpl)this.findMethodByName("__init__", false);
        if (initMethod != null) {
            PyClassImpl.collectInstanceAttributes(initMethod, result);
        }
        HashSet<String> namesInInit = new HashSet<String>(result.keySet());
        for (PyFunction method : methods = this.getMethods(false)) {
            if ("__init__".equals(method.getName())) continue;
            PyClassImpl.collectInstanceAttributes(method, result, namesInInit);
        }
        Collection expressions = result.values();
        return new ArrayList<PyTargetExpression>(expressions);
    }

    private void collectAttributesInNew(@NotNull Map<String, PyTargetExpression> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/psi/impl/PyClassImpl", "collectAttributesInNew"));
        }
        PyFunction newMethod = this.findMethodByName("__new__", false);
        if (newMethod != null) {
            for (PyTargetExpression target : PyClassImpl.getTargetExpressions(newMethod)) {
                result.put(target.getName(), target);
            }
        }
    }

    public static void collectInstanceAttributes(@NotNull PyFunction method, @NotNull Map<String, PyTargetExpression> result) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/python/psi/impl/PyClassImpl", "collectInstanceAttributes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/psi/impl/PyClassImpl", "collectInstanceAttributes"));
        }
        PyClassImpl.collectInstanceAttributes(method, result, null);
    }

    public static void collectInstanceAttributes(@NotNull PyFunction method, @NotNull Map<String, PyTargetExpression> result, Set<String> existing) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/python/psi/impl/PyClassImpl", "collectInstanceAttributes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/psi/impl/PyClassImpl", "collectInstanceAttributes"));
        }
        PyParameter[] params = method.getParameterList().getParameters();
        if (params.length == 0) {
            return;
        }
        for (PyTargetExpression target : PyClassImpl.getTargetExpressions(method)) {
            if (!PyUtil.isInstanceAttribute(target) || existing != null && existing.contains(target.getName())) continue;
            result.put(target.getName(), target);
        }
    }

    @NotNull
    private static List<PyTargetExpression> getTargetExpressions(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/psi/impl/PyClassImpl", "getTargetExpressions"));
        }
        PyFunctionStub stub = (PyFunctionStub)function.getStub();
        if (stub != null) {
            List<PsiElement> list = Arrays.asList(stub.getChildrenByType((IElementType)PyElementTypes.TARGET_EXPRESSION, (PsiElement[])PyTargetExpression.EMPTY_ARRAY));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getTargetExpressions"));
            }
            return list;
        }
        PyStatementList statementList = function.getStatementList();
        final ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        statementList.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyClass(PyClass node) {
            }

            @Override
            public void visitPyAssignmentStatement(PyAssignmentStatement node) {
                for (PyExpression expression : node.getTargets()) {
                    if (!(expression instanceof PyTargetExpression)) continue;
                    result.add((PyTargetExpression)expression);
                }
            }
        });
        ArrayList<PyTargetExpression> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getTargetExpressions"));
        }
        return arrayList;
    }

    @Override
    public boolean isNewStyleClass() {
        return (Boolean)((CachedValue)this.myNewStyle.getValue()).getValue();
    }

    private boolean calculateNewStyleClass() {
        PsiFile containingFile = this.getContainingFile();
        if (containingFile instanceof PyFile && ((PyFile)containingFile).getLanguageLevel().isPy3K()) {
            return true;
        }
        PyClass objClass = PyBuiltinCache.getInstance(this).getClass("object");
        if (this == objClass) {
            return true;
        }
        if (PyClassImpl.hasNewStyleMetaClass(this)) {
            return true;
        }
        for (PyClassLikeType type : this.getOldStyleAncestorTypes(TypeEvalContext.codeInsightFallback(this.getProject()))) {
            if (type == null) {
                return true;
            }
            if (!(type instanceof PyClassType)) continue;
            PyClass pyClass = ((PyClassType)type).getPyClass();
            if (pyClass == objClass) {
                return true;
            }
            if (!PyClassImpl.hasNewStyleMetaClass(pyClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNewStyleMetaClass(PyClass pyClass) {
        QualifiedName qName;
        PsiElement element;
        PsiFile containingFile = pyClass.getContainingFile();
        if (containingFile instanceof PyFile && (element = ((PyFile)containingFile).getElementNamed("__metaclass__")) instanceof PyTargetExpression && (qName = ((PyTargetExpression)element).getAssignedQName()) != null && qName.matches(new String[]{"type"})) {
            return true;
        }
        return pyClass.findClassAttribute("__metaclass__", false) != null;
    }

    @Override
    public boolean processClassLevelDeclarations(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/impl/PyClassImpl", "processClassLevelDeclarations"));
        }
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            List children = stub.getChildrenStubs();
            for (StubElement child : children) {
                if (processor.execute(child.getPsi(), ResolveState.initial())) continue;
                return false;
            }
        } else {
            PyResolveUtil.scopeCrawlUp(processor, this, null, (PsiElement)this);
        }
        return true;
    }

    @Override
    public boolean processInstanceLevelDeclarations(@NotNull PsiScopeProcessor processor, @Nullable PsiElement location) {
        PyClass containingClass;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/impl/PyClassImpl", "processInstanceLevelDeclarations"));
        }
        HashMap<String, PyTargetExpression> declarationsInMethod = new HashMap<String, PyTargetExpression>();
        PyFunction instanceMethod = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)location, PyFunction.class);
        PyClass pyClass = containingClass = instanceMethod != null ? instanceMethod.getContainingClass() : null;
        if (instanceMethod != null && containingClass != null && CompletionUtil.getOriginalElement(containingClass) == this) {
            PyClassImpl.collectInstanceAttributes(instanceMethod, declarationsInMethod);
            for (PyTargetExpression targetExpression : declarationsInMethod.values()) {
                if (processor.execute((PsiElement)targetExpression, ResolveState.initial())) continue;
                return false;
            }
        }
        for (PyTargetExpression expr : this.getInstanceAttributes()) {
            if (declarationsInMethod.containsKey(expr.getName()) || processor.execute((PsiElement)expr, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTextOffset() {
        ASTNode name = this.getNameNode();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Override
    public PyStringLiteralExpression getDocStringExpression() {
        return DocStringUtil.findDocStringExpression(this.getStatementList());
    }

    @Override
    public String getDocStringValue() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    public String toString() {
        return "PyClass: " + this.getName();
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        Set<PyElement> set = Collections.singleton(this);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "iterateNames"));
        }
        return set;
    }

    public PyElement getElementNamed(String the_name) {
        return the_name.equals(this.getName()) ? this : null;
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        if (this.myInstanceAttributes != null) {
            this.myInstanceAttributes = null;
        }
        this.myPropertyCache = null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(this);
        if (scopeOwner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)scopeOwner);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        PyType type;
        String implicitSuperName;
        PyClass implicitSuper;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClassTypes"));
        }
        if ("___Classobj".equals(this.getName())) {
            List<PyClassLikeType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClassTypes"));
            }
            return list;
        }
        PyClassStub stub = (PyClassStub)this.getStub();
        ArrayList<PyClassLikeType> result = new ArrayList<PyClassLikeType>();
        if (stub != null) {
            PsiFile file = this.getContainingFile();
            if (file instanceof PyFile) {
                for (QualifiedName name : stub.getSuperClasses()) {
                    result.add(name != null ? PyClassImpl.classTypeFromQName(name, (PyFile)file, context) : null);
                }
            }
        } else {
            for (PyExpression expression : this.getSuperClassExpressions()) {
                context.getType(expression);
                expression = PyClassImpl.unfoldClass(expression);
                if (expression instanceof PyKeywordArgument) continue;
                PyType type2 = context.getType(expression);
                result.add(type2 instanceof PyClassLikeType ? (PyClassLikeType)type2 : null);
            }
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(this);
        if (result.isEmpty() && this.isValid() && !builtinCache.isBuiltin(this) && (implicitSuper = builtinCache.getClass(implicitSuperName = LanguageLevel.forElement(this).isPy3K() ? "object" : "___Classobj")) != null && (type = context.getType(implicitSuper)) instanceof PyClassLikeType) {
            result.add((PyClassLikeType)type);
        }
        ArrayList<PyClassLikeType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getSuperClassTypes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getAncestorTypes"));
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)this.getProject());
        List list = (List)manager.getParameterizedCachedValue((UserDataHolder)this, this.myCachedValueKey, (ParameterizedCachedValueProvider)this.myCachedAncestorsProvider, false, (Object)context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getAncestorTypes"));
        }
        return list;
    }

    @Override
    @Nullable
    public PyType getMetaClassType(@NotNull TypeEvalContext context) {
        PyFile pyFile;
        PsiElement element;
        PsiFile file;
        LanguageLevel level;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getMetaClassType"));
        }
        if (context.maySwitchToAST(this)) {
            PyType type;
            PyExpression expression = this.getMetaClassExpression();
            if (expression != null && (type = context.getType(expression)) != null) {
                return type;
            }
        } else {
            PyClassStub stub = (PyClassStub)this.getStub();
            QualifiedName name = stub != null ? stub.getMetaClass() : PyPsiUtils.asQualifiedName(this.getMetaClassExpression());
            PsiFile file2 = this.getContainingFile();
            if (file2 instanceof PyFile) {
                PyFile pyFile2 = (PyFile)file2;
                if (name != null) {
                    return PyClassImpl.classTypeFromQName(name, pyFile2, context);
                }
            }
        }
        if ((level = LanguageLevel.forElement(this)).isOlderThan(LanguageLevel.PYTHON30) && (file = this.getContainingFile()) instanceof PyFile && (element = (pyFile = (PyFile)file).getElementNamed("__metaclass__")) instanceof PyTypedElement) {
            return context.getType((PyTypedElement)element);
        }
        return null;
    }

    @Override
    @Nullable
    public PyExpression getMetaClassExpression() {
        LanguageLevel level = LanguageLevel.forElement(this);
        if (level.isAtLeast(LanguageLevel.PYTHON30)) {
            for (PyExpression expression : this.getSuperClassExpressions()) {
                PyKeywordArgument argument;
                if (!(expression instanceof PyKeywordArgument) || !"metaclass".equals((argument = (PyKeywordArgument)expression).getKeyword())) continue;
                return argument.getValueExpression();
            }
        } else {
            PyTargetExpression attribute = this.findClassAttribute("__metaclass__", false);
            if (attribute != null) {
                return attribute.findAssignedValue();
            }
        }
        return null;
    }

    @NotNull
    private List<PyClassLikeType> getMROAncestorTypes(@NotNull TypeEvalContext context) throws MROException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getMROAncestorTypes"));
        }
        PyType thisType = context.getType(this);
        if (thisType instanceof PyClassLikeType) {
            PyClassLikeType thisClassLikeType = (PyClassLikeType)thisType;
            List<PyClassLikeType> ancestorTypes = PyClassImpl.mroLinearize(thisClassLikeType, new HashSet<PyClassLikeType>(), false, context);
            if (this.isOverriddenMRO(ancestorTypes, context)) {
                ancestorTypes.add(null);
            }
            List<PyClassLikeType> list = ancestorTypes;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getMROAncestorTypes"));
            }
            return list;
        }
        List<PyClassLikeType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getMROAncestorTypes"));
        }
        return list;
    }

    private boolean isOverriddenMRO(@NotNull List<PyClassLikeType> ancestorTypes, @NotNull TypeEvalContext context) {
        if (ancestorTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestorTypes", "com/jetbrains/python/psi/impl/PyClassImpl", "isOverriddenMRO"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "isOverriddenMRO"));
        }
        ArrayList<PyClass> classes = new ArrayList<PyClass>();
        classes.add(this);
        for (PyClassLikeType ancestorType : ancestorTypes) {
            if (!(ancestorType instanceof PyClassType)) continue;
            PyClassType classType = (PyClassType)ancestorType;
            classes.add(classType.getPyClass());
        }
        PyClass typeClass = PyBuiltinCache.getInstance(this).getClass("type");
        for (PyClass cls : classes) {
            PyClass mroClass;
            PyType metaClassType = cls.getMetaClassType(context);
            if (!(metaClassType instanceof PyClassType)) continue;
            PyClass metaClass = ((PyClassType)metaClassType).getPyClass();
            if (cls == metaClass) {
                return false;
            }
            PyFunction mroMethod = metaClass.findMethodByName("mro", true);
            if (mroMethod == null || (mroClass = mroMethod.getContainingClass()) == null || mroClass == typeClass) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<PyClassLikeType> getOldStyleAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getOldStyleAncestorTypes"));
        }
        ArrayList<PyClassLikeType> results = new ArrayList<PyClassLikeType>();
        ArrayList<PyClassLikeType> toProcess = new ArrayList<PyClassLikeType>();
        HashSet<PyClassLikeType> seen = new HashSet<PyClassLikeType>();
        HashSet<PyClassLikeType> visited = new HashSet<PyClassLikeType>();
        PyType thisType = context.getType(this);
        if (thisType instanceof PyClassLikeType) {
            toProcess.add((PyClassLikeType)thisType);
        }
        while (!toProcess.isEmpty()) {
            PyClassLikeType currentType = (PyClassLikeType)toProcess.remove(0);
            visited.add(currentType);
            for (PyClassLikeType superType : currentType.getSuperClassTypes(context)) {
                if (superType == null || !seen.contains(superType)) {
                    results.add(superType);
                    seen.add(superType);
                }
                if (superType == null || visited.contains(superType)) continue;
                toProcess.add(superType);
            }
        }
        ArrayList<PyClassLikeType> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl", "getOldStyleAncestorTypes"));
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement getElementQNamed(@NotNull PyFile file, @NotNull QualifiedName qualifiedName, @NotNull TypeEvalContext context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PyClassImpl", "getElementQNamed"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/psi/impl/PyClassImpl", "getElementQNamed"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getElementQNamed"));
        }
        int componentCount = qualifiedName.getComponentCount();
        String fullName = qualifiedName.toString();
        PyModuleType type = new PyModuleType(file);
        if (componentCount == 0) {
            return null;
        }
        if (componentCount == 1) {
            PsiElement element = PyClassImpl.resolveTypeMember(type, fullName, context);
            if (element == null) {
                element = PyBuiltinCache.getInstance(file).getByName(fullName);
            }
            return element;
        }
        String name = qualifiedName.getLastComponent();
        QualifiedName containingQName = qualifiedName.removeLastComponent();
        PyType currentType = type;
        for (String component : containingQName.getComponents()) {
            if ((currentType = PyClassImpl.getMemberType(currentType, component, context)) != null) continue;
            return null;
        }
        if (name != null) {
            return PyClassImpl.resolveTypeMember(currentType, name, context);
        }
        return null;
    }

    @Nullable
    private static PyType getMemberType(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        PyType result;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/impl/PyClassImpl", "getMemberType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyClassImpl", "getMemberType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getMemberType"));
        }
        PsiElement element = PyClassImpl.resolveTypeMember(type, name, context);
        if (element instanceof PyImportedModule) {
            result = new PyImportedModuleType((PyImportedModule)element);
        } else if (element instanceof PyTypedElement) {
            result = context.getType((PyTypedElement)element);
        } else {
            return null;
        }
        if (result instanceof PyClassLikeType) {
            return ((PyClassLikeType)result).toInstance();
        }
        return result;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/impl/PyClassImpl", "resolveTypeMember"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyClassImpl", "resolveTypeMember"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "resolveTypeMember"));
        }
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
        List<? extends RatedResolveResult> results = type.resolveMember(name, null, AccessDirection.READ, resolveContext);
        return results != null && !results.isEmpty() ? results.get(0).getElement() : null;
    }

    @Nullable
    private static PyClassLikeType classTypeFromQName(@NotNull QualifiedName qualifiedName, @NotNull PyFile containingFile, @NotNull TypeEvalContext context) {
        PyType type;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/psi/impl/PyClassImpl", "classTypeFromQName"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/jetbrains/python/psi/impl/PyClassImpl", "classTypeFromQName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "classTypeFromQName"));
        }
        PsiElement element = PyClassImpl.getElementQNamed(containingFile, qualifiedName, context);
        if (element instanceof PyTypedElement && (type = context.getType((PyTypedElement)element)) instanceof PyClassLikeType) {
            return (PyClassLikeType)type;
        }
        return null;
    }

    @Override
    @Nullable
    public PyClassLikeType getType(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl", "getType"));
        }
        return PyUtil.as(context.getType(this), PyClassLikeType.class);
    }

    private static class PropertyImpl
    extends PropertyBunch<Callable>
    implements Property {
        private final String myName;

        private PropertyImpl(String name, Maybe<Callable> getter, Maybe<Callable> setter, Maybe<Callable> deleter, String doc, PyTargetExpression site) {
            this.myName = name;
            this.myDeleter = deleter;
            this.myGetter = getter;
            this.mySetter = setter;
            this.myDoc = doc;
            this.mySite = site;
        }

        @Override
        @NotNull
        public Maybe<Callable> getGetter() {
            Maybe<Callable> maybe = PropertyImpl.filterNonStubExpression(this.myGetter);
            if (maybe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getGetter"));
            }
            return maybe;
        }

        @Override
        @NotNull
        public Maybe<Callable> getSetter() {
            Maybe<Callable> maybe = PropertyImpl.filterNonStubExpression(this.mySetter);
            if (maybe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getSetter"));
            }
            return maybe;
        }

        @Override
        @NotNull
        public Maybe<Callable> getDeleter() {
            Maybe<Callable> maybe = PropertyImpl.filterNonStubExpression(this.myDeleter);
            if (maybe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getDeleter"));
            }
            return maybe;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public PyTargetExpression getDefinitionSite() {
            return this.mySite;
        }

        @Override
        @NotNull
        public Maybe<Callable> getByDirection(@NotNull AccessDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getByDirection"));
            }
            switch (direction) {
                case READ: {
                    Maybe<Callable> maybe = this.getGetter();
                    if (maybe == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getByDirection"));
                    }
                    return maybe;
                }
                case WRITE: {
                    Maybe<Callable> maybe = this.getSetter();
                    if (maybe == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getByDirection"));
                    }
                    return maybe;
                }
                case DELETE: {
                    Maybe<Callable> maybe = this.getDeleter();
                    if (maybe == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getByDirection"));
                    }
                    return maybe;
                }
            }
            throw new IllegalArgumentException("Unknown direction " + PyUtil.nvl((Object)direction));
        }

        @Override
        @Nullable
        public PyType getType(@NotNull TypeEvalContext context) {
            PyType targetDocStringType;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "getType"));
            }
            if (this.mySite instanceof PyTargetExpressionImpl && (targetDocStringType = ((PyTargetExpressionImpl)this.mySite).getTypeFromDocString()) != null) {
                return targetDocStringType;
            }
            Callable callable = (Callable)this.myGetter.valueOrNull();
            if (callable != null) {
                if (!(callable instanceof StubBasedPsiElement) && !context.maySwitchToAST((PsiElement)callable)) {
                    return null;
                }
                return context.getReturnType(callable);
            }
            return null;
        }

        @Override
        @NotNull
        protected Maybe<Callable> translate(@Nullable PyExpression expr) {
            PsiElement something;
            if (expr == null) {
                Maybe maybe = NONE;
                if (maybe == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "translate"));
                }
                return maybe;
            }
            if ("None".equals(expr.getName())) {
                Maybe maybe = NONE;
                if (maybe == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "translate"));
                }
                return maybe;
            }
            if (expr instanceof Callable) {
                Maybe<Callable> maybe = new Maybe<Callable>((Callable)((Object)expr));
                if (maybe == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "translate"));
                }
                return maybe;
            }
            PsiReference ref = expr.getReference();
            if (ref != null && (something = ref.resolve()) instanceof Callable) {
                Maybe<Callable> maybe = new Maybe<Callable>((Callable)something);
                if (maybe == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "translate"));
                }
                return maybe;
            }
            Maybe maybe = NONE;
            if (maybe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "translate"));
            }
            return maybe;
        }

        @NotNull
        private static Maybe<Callable> filterNonStubExpression(@NotNull Maybe<Callable> maybeCallable) {
            if (maybeCallable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maybeCallable", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "filterNonStubExpression"));
            }
            Callable callable = maybeCallable.valueOrNull();
            if (callable != null && !(callable instanceof StubBasedPsiElement)) {
                Maybe maybe = UNKNOWN_CALL;
                if (maybe == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "filterNonStubExpression"));
                }
                return maybe;
            }
            Maybe<Callable> maybe = maybeCallable;
            if (maybe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl", "filterNonStubExpression"));
            }
            return maybe;
        }

        public String toString() {
            return "property(" + this.myGetter + ", " + this.mySetter + ", " + this.myDeleter + ", " + this.myDoc + ")";
        }

        @Nullable
        public static PropertyImpl fromTarget(PyTargetExpression target) {
            PropertyImpl prop;
            PyExpression expr = target.findAssignedValue();
            boolean success = PropertyImpl.fillFromCall(expr, prop = new PropertyImpl(target.getName(), null, null, null, null, target));
            return success ? prop : null;
        }
    }

    private static class NameFinder<T extends PyElement>
    implements Processor<T> {
        private T myResult;
        private final String[] myNames;

        public NameFinder(String ... names) {
            this.myNames = names;
            this.myResult = null;
        }

        public T getResult() {
            return this.myResult;
        }

        public boolean process(T target) {
            String targetName = target.getName();
            for (String name : this.myNames) {
                if (!name.equals(targetName)) continue;
                this.myResult = target;
                return false;
            }
            return true;
        }
    }

    private class NewStyleCachedValueProvider
    implements CachedValueProvider<Boolean> {
        private NewStyleCachedValueProvider() {
        }

        public CachedValueProvider.Result<Boolean> compute() {
            return new CachedValueProvider.Result((Object)PyClassImpl.this.calculateNewStyleClass(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }

    private class CachedAncestorsProvider
    implements ParameterizedCachedValueProvider<List<PyClassLikeType>, TypeEvalContext> {
        private CachedAncestorsProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<List<PyClassLikeType>> compute(@NotNull TypeEvalContext context) {
            List<Object> ancestorTypes;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyClassImpl$CachedAncestorsProvider", "compute"));
            }
            if (PyClassImpl.this.isNewStyleClass()) {
                try {
                    ancestorTypes = PyClassImpl.this.getMROAncestorTypes(context);
                }
                catch (MROException e) {
                    ancestorTypes = PyClassImpl.this.getOldStyleAncestorTypes(context);
                    boolean hasUnresolvedAncestorTypes = false;
                    for (PyClassLikeType pyClassLikeType : ancestorTypes) {
                        if (pyClassLikeType != null) continue;
                        hasUnresolvedAncestorTypes = true;
                        break;
                    }
                    if (!hasUnresolvedAncestorTypes) {
                        ancestorTypes = Collections.singletonList(null);
                    }
                }
            } else {
                ancestorTypes = PyClassImpl.this.getOldStyleAncestorTypes(context);
            }
            return CachedValueProvider.Result.create((Object)ancestorTypes, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }

    public static class MROException
    extends Exception {
        public MROException(String s) {
            super(s);
        }
    }
}

