/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallExpressionImpl
extends PyElementImpl
implements PyCallExpression {
    public PyCallExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyCallExpression(this);
    }

    @Override
    @Nullable
    public PyExpression getCallee() {
        Object seeker = this.getFirstChild();
        while (seeker instanceof PyParenthesizedExpression) {
            seeker = ((PyParenthesizedExpression)seeker).getContainedExpression();
        }
        return seeker instanceof PyExpression ? (PyExpression)seeker : null;
    }

    @Override
    public PyArgumentList getArgumentList() {
        return (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
    }

    @Override
    @NotNull
    public PyExpression[] getArguments() {
        PyArgumentList argList = this.getArgumentList();
        PyExpression[] pyExpressionArray = argList != null ? argList.getArguments() : PyExpression.EMPTY_ARRAY;
        if (pyExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "getArguments"));
        }
        return pyExpressionArray;
    }

    @Override
    public <T extends PsiElement> T getArgument(int index, Class<T> argClass) {
        PyExpression[] args = this.getArguments();
        return (T)(args.length > index && argClass.isInstance(args[index]) ? (PsiElement)argClass.cast(args[index]) : null);
    }

    @Override
    public <T extends PsiElement> T getArgument(int index, String keyword, Class<T> argClass) {
        PyExpression argument = this.getKeywordArgument(keyword);
        if (argument != null) {
            return (T)(argClass.isInstance(argument) ? (PsiElement)argClass.cast(argument) : null);
        }
        return this.getArgument(index, argClass);
    }

    @Override
    @Nullable
    public <T extends PsiElement> T getArgument(@NotNull FunctionParameter parameter, @NotNull Class<T> argClass) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "getArgument"));
        }
        if (argClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argClass", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "getArgument"));
        }
        return PyCallExpressionHelper.getArgument(parameter, argClass, this);
    }

    @Override
    public PyExpression getKeywordArgument(String keyword) {
        return PyCallExpressionHelper.getKeywordArgument(this, keyword);
    }

    @Override
    public void addArgument(PyExpression expression) {
        PyCallExpressionHelper.addArgument(this, expression);
    }

    @Override
    public PyCallExpression.PyMarkedCallee resolveCallee(PyResolveContext resolveContext) {
        return PyCallExpressionHelper.resolveCallee(this, resolveContext);
    }

    @Override
    public Callable resolveCalleeFunction(PyResolveContext resolveContext) {
        return PyCallExpressionHelper.resolveCalleeFunction(this, resolveContext);
    }

    @Override
    public PyCallExpression.PyMarkedCallee resolveCallee(PyResolveContext resolveContext, int offset) {
        return PyCallExpressionHelper.resolveCallee(this, resolveContext, offset);
    }

    @Override
    public boolean isCalleeText(String ... nameCandidates) {
        if (nameCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCandidates", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "isCalleeText"));
        }
        return PyCallExpressionHelper.isCalleeText(this, nameCandidates);
    }

    @Override
    public boolean isCallee(FQNamesProvider ... name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "isCallee"));
        }
        return PyCallExpressionHelper.isCallee(this, name);
    }

    @Override
    public String toString() {
        return "PyCallExpression: " + PyUtil.getReadableRepr((PsiElement)this.getCallee(), true);
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyCallExpressionImpl", "getType"));
        }
        return PyCallExpressionHelper.getCallType(this, context);
    }
}

