/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBoundFunction;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.TypeEvalStack;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallExpressionHelper {
    private PyCallExpressionHelper() {
    }

    public static void addArgument(PyCallExpression us, PyExpression expression) {
        PyExpression[] arguments = us.getArgumentList().getArguments();
        PyExpression last_arg = arguments.length == 0 ? null : arguments[arguments.length - 1];
        PyElementGenerator.getInstance(us.getProject()).insertItemIntoList(us, last_arg, expression);
    }

    @Nullable
    public static Pair<String, PyFunction> interpretAsModifierWrappingCall(PyCallExpression redefiningCall, PsiElement us) {
        PsiElement redefining_func;
        PyReferenceExpression refex;
        String refname;
        PyExpression redefining_callee = redefiningCall.getCallee();
        if (redefiningCall.isCalleeText("classmethod", "staticmethod") && ("classmethod".equals(refname = (refex = (PyReferenceExpression)redefining_callee).getReferencedName()) || "staticmethod".equals(refname)) && (redefining_func = refex.getReference().resolve()) != null) {
            PsiElement original;
            PyExpression possible_original_ref;
            PyExpression[] args;
            PyArgumentList arglist;
            PsiElement true_func = PyBuiltinCache.getInstance(us).getByName(refname);
            if (true_func instanceof PyClass) {
                true_func = ((PyClass)true_func).findInitOrNew(true);
            }
            if (true_func == redefining_func && (arglist = redefiningCall.getArgumentList()) != null && (args = arglist.getArguments()).length == 1 && (possible_original_ref = args[0]) instanceof PyReferenceExpression && (original = ((PyReferenceExpression)possible_original_ref).getReference().resolve()) instanceof PyFunction) {
                return Pair.create((Object)refname, (Object)((PyFunction)original));
            }
        }
        return null;
    }

    @Nullable
    public static PyClass resolveCalleeClass(PyCallExpression us) {
        PyExpression resolved;
        PyExpression callee = us.getCallee();
        QualifiedResolveResult resolveResult = null;
        if (callee instanceof PyReferenceExpression) {
            PyReferenceExpression ref = (PyReferenceExpression)callee;
            resolveResult = ref.followAssignmentsChain(PyResolveContext.noImplicits());
            resolved = resolveResult.getElement();
        } else {
            resolved = callee;
        }
        if (resolved instanceof PyClass) {
            return (PyClass)((Object)resolved);
        }
        if (resolved instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)((Object)resolved);
            return pyFunction.getContainingClass();
        }
        return null;
    }

    @Nullable
    public static Callable resolveCalleeFunction(PyCallExpression call, PyResolveContext resolveContext) {
        PyCallExpression redefiningCall;
        Pair<String, PyFunction> wrapperInfo;
        PyTypedElement resolved;
        PyExpression callee = call.getCallee();
        if (callee instanceof PyReferenceExpression) {
            PyReferenceExpression ref = (PyReferenceExpression)callee;
            QualifiedResolveResult resolveResult = ref.followAssignmentsChain(resolveContext);
            resolved = resolveResult.getElement();
        } else {
            resolved = callee;
        }
        if (resolved instanceof PyClass) {
            resolved = ((PyClass)resolved).findInitOrNew(true);
        } else if (resolved instanceof PyCallExpression && (wrapperInfo = PyCallExpressionHelper.interpretAsModifierWrappingCall(redefiningCall = (PyCallExpression)resolved, (PsiElement)call)) != null) {
            resolved = (PsiElement)wrapperInfo.getSecond();
        }
        if (resolved instanceof Callable) {
            return (Callable)resolved;
        }
        return null;
    }

    @Nullable
    public static PyCallExpression.PyMarkedCallee resolveCallee(PyCallExpression us, PyResolveContext resolveContext) {
        return PyCallExpressionHelper.resolveCallee(us, resolveContext, 0);
    }

    @Nullable
    public static PyCallExpression.PyMarkedCallee resolveCallee(PyCallExpression us, PyResolveContext resolveContext, int implicitOffset) {
        PyFunction function;
        Property property;
        PyCallExpression redefiningCall;
        Pair<String, PyFunction> wrapperInfo;
        PyTypedElement resolved;
        PyFunction.Modifier wrappedModifier = null;
        boolean isConstructorCall = false;
        PyExpression callee = us.getCallee();
        if (PyCallExpressionHelper.isResolvedToMultipleTargets(callee, resolveContext)) {
            return null;
        }
        QualifiedResolveResult resolveResult = null;
        if (callee instanceof PyReferenceExpression) {
            PyReferenceExpression ref = (PyReferenceExpression)callee;
            resolveResult = ref.followAssignmentsChain(resolveContext);
            resolved = resolveResult.getElement();
        } else {
            resolved = callee;
        }
        if (resolved instanceof PyClass) {
            resolved = ((PyClass)resolved).findInitOrNew(true);
            isConstructorCall = true;
        } else if (resolved instanceof PyCallExpression && (wrapperInfo = PyCallExpressionHelper.interpretAsModifierWrappingCall(redefiningCall = (PyCallExpression)resolved, (PsiElement)us)) != null) {
            resolved = (PsiElement)wrapperInfo.getSecond();
            String wrapper_name = (String)wrapperInfo.getFirst();
            if ("classmethod".equals(wrapper_name)) {
                wrappedModifier = PyFunction.Modifier.CLASSMETHOD;
            } else if ("staticmethod".equals(wrapper_name)) {
                wrappedModifier = PyFunction.Modifier.STATICMETHOD;
            }
        }
        List<PyExpression> qualifiers = resolveResult != null ? resolveResult.getQualifiers() : Collections.emptyList();
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        if (resolved instanceof PyFunction && (property = (function = (PyFunction)resolved).getProperty()) != null && PyCallExpressionHelper.isQualifiedByInstance((Callable)function, qualifiers, context)) {
            PyType type = context.getReturnType(function);
            resolved = type instanceof PyFunctionType ? ((PyFunctionType)type).getCallable() : null;
        }
        if (resolved instanceof Callable) {
            PyFunction.Modifier modifier;
            PyFunction.Modifier modifier2 = modifier = resolved instanceof PyFunction ? ((PyFunction)resolved).getModifier() : null;
            if (modifier == null && wrappedModifier != null) {
                modifier = wrappedModifier;
            }
            boolean isByInstance = isConstructorCall || PyCallExpressionHelper.isQualifiedByInstance((Callable)resolved, qualifiers, context) || resolved instanceof PyBoundFunction;
            PyExpression lastQualifier = qualifiers != null && qualifiers.isEmpty() ? null : qualifiers.get(qualifiers.size() - 1);
            boolean isByClass = lastQualifier == null ? false : PyCallExpressionHelper.isQualifiedByClass((Callable)resolved, lastQualifier, context);
            Callable callable = (Callable)resolved;
            implicitOffset = (implicitOffset += PyCallExpressionHelper.getImplicitArgumentCount(callable, modifier, isConstructorCall, isByInstance, isByClass)) < 0 ? 0 : implicitOffset;
            return new PyCallExpression.PyMarkedCallee(callable, modifier, implicitOffset, resolveResult != null ? resolveResult.isImplicit() : false);
        }
        return null;
    }

    private static boolean isResolvedToMultipleTargets(@Nullable PyExpression callee, @NotNull PyResolveContext resolveContext) {
        List<PsiElement> resolved;
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "isResolvedToMultipleTargets"));
        }
        return callee != null && (resolved = PyUtil.multiResolveTopPriority((PsiElement)callee, resolveContext)).size() > 1;
    }

    public static int getImplicitArgumentCount(@NotNull PyReferenceExpression callReference, @NotNull PyFunction functionBeingCalled) {
        if (callReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callReference", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getImplicitArgumentCount"));
        }
        if (functionBeingCalled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionBeingCalled", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getImplicitArgumentCount"));
        }
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)callReference, PyDecorator.class);
        if (decorator != null && PsiTreeUtil.isAncestor((PsiElement)decorator.getCallee(), (PsiElement)callReference, (boolean)false)) {
            return 1;
        }
        PyResolveContext resolveContext = PyResolveContext.noImplicits();
        QualifiedResolveResult followed = callReference.followAssignmentsChain(resolveContext);
        boolean isByInstance = PyCallExpressionHelper.isQualifiedByInstance((Callable)functionBeingCalled, followed.getQualifiers(), resolveContext.getTypeEvalContext());
        boolean isByClass = PyCallExpressionHelper.isQualifiedByInstance((Callable)functionBeingCalled, followed.getQualifiers(), resolveContext.getTypeEvalContext());
        return PyCallExpressionHelper.getImplicitArgumentCount(functionBeingCalled, functionBeingCalled.getModifier(), false, isByInstance, isByClass);
    }

    private static int getImplicitArgumentCount(Callable callable, PyFunction.Modifier modifier, boolean isConstructorCall, boolean isByInstance, boolean isByClass) {
        PyFunction method;
        PyParameter first;
        PyNamedParameter named;
        int implicit_offset = 0;
        boolean firstIsArgsOrKwargs = false;
        PyParameter[] parameters = callable.getParameterList().getParameters();
        if (parameters.length > 0 && (named = (first = parameters[0]).getAsNamed()) != null && (named.isPositionalContainer() || named.isKeywordContainer())) {
            firstIsArgsOrKwargs = true;
        }
        if (!firstIsArgsOrKwargs && (isByInstance || isConstructorCall)) {
            ++implicit_offset;
        }
        if ((method = callable.asMethod()) == null) {
            return implicit_offset;
        }
        if ("__new__".equals(method.getName())) {
            return isConstructorCall ? 1 : 0;
        }
        if (!isByInstance && !isByClass && "__init__".equals(method.getName())) {
            return 1;
        }
        if (modifier == PyFunction.Modifier.STATICMETHOD) {
            if (isByInstance && implicit_offset > 0) {
                --implicit_offset;
            }
        } else if (modifier == PyFunction.Modifier.CLASSMETHOD && !isByInstance) {
            ++implicit_offset;
        }
        return implicit_offset;
    }

    private static boolean isQualifiedByInstance(Callable resolved, List<PyExpression> qualifiers, TypeEvalContext context) {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolved, PyDocStringOwner.class);
        if (!(owner instanceof PyClass)) {
            return false;
        }
        if (qualifiers.isEmpty()) {
            return true;
        }
        for (PyExpression qualifier : qualifiers) {
            if (!PyCallExpressionHelper.isQualifiedByInstance(resolved, qualifier, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean isQualifiedByInstance(Callable resolved, PyExpression qualifier, TypeEvalContext context) {
        if (PyCallExpressionHelper.isQualifiedByClass(resolved, qualifier, context)) {
            return false;
        }
        PyType qtype = context.getType(qualifier);
        return qtype == null || !(qtype instanceof PyModuleType);
    }

    private static boolean isQualifiedByClass(Callable resolved, PyExpression qualifier, TypeEvalContext context) {
        PyType qtype = context.getType(qualifier);
        if (qtype instanceof PyClassType) {
            PyClass qualifierClass;
            PyClass resolvedParent;
            if (((PyClassType)qtype).isDefinition() && (resolvedParent = (PyClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolved, PyClass.class)) != null && ((qualifierClass = ((PyClassType)qtype).getPyClass()).isSubclass(resolvedParent) || resolvedParent.isSubclass(qualifierClass))) {
                return true;
            }
        } else if (qtype instanceof PyClassLikeType) {
            return ((PyClassLikeType)qtype).isDefinition();
        }
        return false;
    }

    static boolean isCalleeText(PyCallExpression pyCallExpression, String[] nameCandidates) {
        PyExpression callee = pyCallExpression.getCallee();
        if (!(callee instanceof PyReferenceExpression)) {
            return false;
        }
        for (String name : nameCandidates) {
            if (!name.equals(((PyReferenceExpression)callee).getReferencedName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getArgument(@NotNull FunctionParameter parameter, @NotNull Class<T> argClass, @NotNull PyCallExpression expression) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getArgument"));
        }
        if (argClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argClass", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getArgument"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getArgument"));
        }
        PyArgumentList list = expression.getArgumentList();
        if (list == null) {
            return null;
        }
        return (T)((PsiElement)PyUtil.as(list.getValueExpressionForParam(parameter), argClass));
    }

    @Nullable
    public static PyExpression getKeywordArgument(PyCallExpression expr, String keyword) {
        for (PyExpression arg : expr.getArguments()) {
            PyKeywordArgument kwarg;
            if (!(arg instanceof PyKeywordArgument) || !keyword.equals((kwarg = (PyKeywordArgument)arg).getKeyword())) continue;
            return kwarg.getValueExpression();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyType getCallType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getCallType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getCallType"));
        }
        if (!TypeEvalStack.mayEvaluate((PsiElement)call)) {
            return null;
        }
        try {
            PyResolveContext resolveContext;
            PyExpression callee = call.getCallee();
            if (callee instanceof PyReferenceExpression) {
                PyExpression[] args;
                Maybe<PyType> superCallType;
                if ("super".equals(callee.getText()) && (superCallType = PyCallExpressionHelper.getSuperCallType(call, context)).isDefined()) {
                    PyType pyType = superCallType.value();
                    return pyType;
                }
                if ("type".equals(callee.getText()) && (args = call.getArguments()).length == 1) {
                    PyExpression arg = args[0];
                    PyType argType = context.getType(arg);
                    if (argType instanceof PyClassType) {
                        PyClassType classType = (PyClassType)argType;
                        if (!classType.isDefinition()) {
                            PyClass cls = classType.getPyClass();
                            PyType pyType = context.getType(cls);
                            return pyType;
                        }
                    } else {
                        PyType classType = null;
                        return classType;
                    }
                }
                resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                PsiPolyVariantReference reference = ((PyReferenceExpression)callee).getReference(resolveContext);
                ArrayList<PyType> members = new ArrayList<PyType>();
                for (PsiElement target : PyUtil.multiResolveTopPriority(reference)) {
                    Ref<? extends PyType> typeRef;
                    if (target == null || (typeRef = PyCallExpressionHelper.getCallTargetReturnType(call, target, context)) == null) continue;
                    members.add((PyType)typeRef.get());
                }
                if (!members.isEmpty()) {
                    PyType pyType = PyUnionType.union(members);
                    return pyType;
                }
            }
            if (callee == null) {
                resolveContext = null;
                return resolveContext;
            }
            PyType type = context.getType(callee);
            if (type instanceof PyCallableType) {
                PyCallableType callableType = (PyCallableType)type;
                PyType pyType = callableType.getCallType(context, call);
                return pyType;
            }
            PyType pyType = null;
            return pyType;
        }
        finally {
            TypeEvalStack.evaluated((PsiElement)call);
        }
    }

    @Nullable
    private static Ref<? extends PyType> getCallTargetReturnType(@NotNull PyCallExpression call, @NotNull PsiElement target, @NotNull TypeEvalContext context) {
        PyFunction f;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getCallTargetReturnType"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getCallTargetReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getCallTargetReturnType"));
        }
        PyClass cls = null;
        PyFunction init = null;
        if (target instanceof PyClass) {
            cls = (PyClass)target;
            init = cls.findInitOrNew(true);
        } else if (target instanceof PyFunction && "__init__".equals((f = (PyFunction)target).getName())) {
            init = f;
            cls = f.getContainingClass();
        }
        if (init != null) {
            PyFunction newMethod;
            PyType t = init.getCallType(context, call);
            if (cls != null && init.getContainingClass() != cls) {
                if (t instanceof PyCollectionType) {
                    PyType elementType = ((PyCollectionType)t).getElementType(context);
                    return Ref.create((Object)new PyCollectionTypeImpl(cls, false, elementType));
                }
                return Ref.create((Object)new PyClassTypeImpl(cls, false));
            }
            if (t != null && !(t instanceof PyNoneType)) {
                return Ref.create((Object)t);
            }
            if (cls != null && t == null && (newMethod = cls.findMethodByName("__new__", true)) != null && !PyBuiltinCache.getInstance((PsiElement)call).isBuiltin(newMethod)) {
                return Ref.create((Object)PyUnionType.createWeakType(new PyClassTypeImpl(cls, false)));
            }
        }
        if (cls != null) {
            return Ref.create((Object)new PyClassTypeImpl(cls, false));
        }
        PyType providedType = PyReferenceExpressionImpl.getReferenceTypeFromProviders(target, context, (PsiElement)call);
        if (providedType instanceof PyCallableType) {
            return Ref.create((Object)((PyCallableType)providedType).getCallType(context, call));
        }
        if (target instanceof Callable) {
            Callable callable = (Callable)target;
            return Ref.create((Object)callable.getCallType(context, call));
        }
        return null;
    }

    @NotNull
    private static Maybe<PyType> getSuperCallType(@NotNull PyCallExpression call, TypeEvalContext context) {
        PyArgumentList arglist;
        PyClass must_be_super;
        PsiElement must_be_super_init;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getSuperCallType"));
        }
        PyExpression callee = call.getCallee();
        if (callee instanceof PyReferenceExpression && (must_be_super_init = ((PyReferenceExpression)callee).getReference().resolve()) instanceof PyFunction && (must_be_super = ((PyFunction)must_be_super_init).getContainingClass()) == PyBuiltinCache.getInstance((PsiElement)call).getClass("super") && (arglist = call.getArgumentList()) != null) {
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)call, PyClass.class);
            PyExpression[] args = arglist.getArguments();
            if (args.length > 1) {
                PyExpression first_arg = args[0];
                if (first_arg instanceof PyReferenceExpression) {
                    PsiElement possible_class;
                    PyReferenceExpression firstArgRef = (PyReferenceExpression)first_arg;
                    PyExpression qualifier = firstArgRef.getQualifier();
                    if (qualifier != null && "__class__".equals(firstArgRef.getReferencedName())) {
                        PyParameterList parameterList;
                        PsiElement element;
                        PsiReference qRef = qualifier.getReference();
                        PsiElement psiElement = element = qRef == null ? null : qRef.resolve();
                        if (element instanceof PyParameter && (parameterList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class)) != null && element == parameterList.getParameters()[0]) {
                            Maybe<PyType> maybe = new Maybe<PyType>(PyCallExpressionHelper.getSuperCallTypeForArguments(context, containingClass, args[1]));
                            if (maybe == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getSuperCallType"));
                            }
                            return maybe;
                        }
                    }
                    if ((possible_class = firstArgRef.getReference().resolve()) instanceof PyClass && ((PyClass)possible_class).isNewStyleClass()) {
                        PyClass first_class = (PyClass)possible_class;
                        Maybe<PyType> maybe = new Maybe<PyType>(PyCallExpressionHelper.getSuperCallTypeForArguments(context, first_class, args[1]));
                        if (maybe == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getSuperCallType"));
                        }
                        return maybe;
                    }
                }
            } else if (call.getContainingFile() instanceof PyFile && ((PyFile)call.getContainingFile()).getLanguageLevel().isPy3K() && containingClass != null) {
                Maybe<PyType> maybe = new Maybe<PyType>(PyCallExpressionHelper.getSuperClassUnionType(containingClass));
                if (maybe == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getSuperCallType"));
                }
                return maybe;
            }
        }
        Maybe<PyType> maybe = new Maybe<PyType>();
        if (maybe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getSuperCallType"));
        }
        return maybe;
    }

    @Nullable
    private static PyType getSuperCallTypeForArguments(TypeEvalContext context, PyClass firstClass, PyExpression second_arg) {
        PyType second_type;
        if (second_arg != null && (second_type = context.getType(second_arg)) instanceof PyClassType) {
            Iterator<PyClass> iterator;
            PyClass secondClass = ((PyClassType)second_type).getPyClass();
            if (CompletionUtil.getOriginalOrSelf(firstClass) == secondClass) {
                return PyCallExpressionHelper.getSuperClassUnionType(firstClass);
            }
            if (secondClass.isSubclass(firstClass) && (iterator = firstClass.getAncestorClasses(context).iterator()).hasNext()) {
                return new PyClassTypeImpl(iterator.next(), false);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getSuperClassUnionType(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "getSuperClassUnionType"));
        }
        PyClass[] supers = pyClass.getSuperClasses();
        if (supers.length > 0) {
            if (supers.length == 1) {
                return new PyClassTypeImpl(supers[0], false);
            }
            ArrayList<PyType> superTypes = new ArrayList<PyType>();
            for (PyClass aSuper : supers) {
                superTypes.add(new PyClassTypeImpl(aSuper, false));
            }
            return PyUnionType.union(superTypes);
        }
        return null;
    }

    public static boolean isCallee(@NotNull PyCallExpression expression, FQNamesProvider ... namesProviders) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "isCallee"));
        }
        if (namesProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesProviders", "com/jetbrains/python/psi/impl/PyCallExpressionHelper", "isCallee"));
        }
        PyExpression callee = expression.getCallee();
        return callee != null && NameResolverTools.isName(callee, namesProviders);
    }
}

