/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBuiltinCache {
    public static final String BUILTIN_FILE = "__builtin__.py";
    public static final String BUILTIN_FILE_3K = "builtins.py";
    public static final String EXCEPTIONS_FILE = "exceptions.py";
    private static final PyBuiltinCache DUD_INSTANCE = new PyBuiltinCache(null, null);
    @NotNull
    private final Map<String, PyClassTypeImpl> myTypeCache = new HashMap<String, PyClassTypeImpl>();
    @Nullable
    private PyFile myBuiltinsFile;
    @Nullable
    private PyFile myExceptionsFile;
    private long myModStamp = -1L;

    public PyBuiltinCache() {
    }

    public PyBuiltinCache(@Nullable PyFile builtins, @Nullable PyFile exceptions) {
        this.myBuiltinsFile = builtins;
        this.myExceptionsFile = exceptions;
    }

    @NotNull
    public static PyBuiltinCache getInstance(@Nullable PsiElement reference) {
        Sdk sdk;
        if (reference != null && reference.isValid() && (sdk = PyBuiltinCache.findSdkForFile((PsiFileSystemItem)reference.getContainingFile())) != null) {
            PyBuiltinCache pyBuiltinCache = PythonSdkPathCache.getInstance(reference.getProject(), sdk).getBuiltins();
            if (pyBuiltinCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getInstance"));
            }
            return pyBuiltinCache;
        }
        PyBuiltinCache pyBuiltinCache = DUD_INSTANCE;
        if (pyBuiltinCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getInstance"));
        }
        return pyBuiltinCache;
    }

    @Nullable
    public static Sdk findSdkForFile(PsiFileSystemItem psifile) {
        if (psifile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psifile);
        if (module != null) {
            return PythonSdkType.findPythonSdk(module);
        }
        return PyBuiltinCache.findSdkForNonModuleFile(psifile);
    }

    @Nullable
    public static Sdk findSdkForNonModuleFile(PsiFileSystemItem psiFile) {
        ProjectRootManager projectRootManager;
        VirtualFile vfile;
        Project project = psiFile.getProject();
        Sdk sdk = null;
        VirtualFile virtualFile = vfile = psiFile instanceof PsiFile ? ((PsiFile)psiFile).getOriginalFile().getVirtualFile() : psiFile.getVirtualFile();
        if (vfile != null && (sdk = (projectRootManager = ProjectRootManager.getInstance((Project)project)).getProjectSdk()) == null) {
            List orderEntries = projectRootManager.getFileIndex().getOrderEntriesForFile(vfile);
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    sdk = ((JdkOrderEntry)orderEntry).getJdk();
                    continue;
                }
                if (!(orderEntry instanceof ModuleLibraryOrderEntryImpl)) continue;
                sdk = PythonSdkType.findPythonSdk(orderEntry.getOwnerModule());
            }
        }
        return sdk;
    }

    @Nullable
    public static PyFile getBuiltinsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getBuiltinsForSdk"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getBuiltinsForSdk"));
        }
        return PyBuiltinCache.getSkeletonFile(project, sdk, PythonSdkType.getBuiltinsFileName(sdk));
    }

    @Nullable
    public static PyFile getSkeletonFile(final @NotNull Project project, @NotNull Sdk sdk, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getSkeletonFile"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getSkeletonFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getSkeletonFile"));
        }
        SdkTypeId sdkType = sdk.getSdkType();
        if (sdkType instanceof PythonSdkType) {
            String[] urls;
            for (String url : urls = sdk.getRootProvider().getUrls(PythonSdkType.BUILTIN_ROOT_TYPE)) {
                VirtualFile builtins_vfile;
                String builtins_url;
                File builtins;
                if (!url.contains("python_stubs") || !(builtins = new File(VfsUtilCore.urlToPath((String)(builtins_url = url + "/" + name)))).isFile() || !builtins.canRead() || (builtins_vfile = LocalFileSystem.getInstance().findFileByIoFile(builtins)) == null) continue;
                final Ref result = Ref.create();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiFile file = PsiManager.getInstance((Project)project).findFile(builtins_vfile);
                        if (file instanceof PyFile) {
                            result.set((Object)((PyFile)file));
                        }
                    }
                });
                return (PyFile)result.get();
            }
        }
        return null;
    }

    @Nullable
    public PyType createLiteralCollectionType(PySequenceExpression sequence, String name, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyBuiltinCache", "createLiteralCollectionType"));
        }
        PyClass cls = this.getClass(name);
        if (cls != null) {
            return new PyCollectionTypeImpl(cls, false, PyBuiltinCache.getSequenceElementType(sequence, context));
        }
        return null;
    }

    @Nullable
    private static PyType getSequenceElementType(@NotNull PySequenceExpression sequence, @NotNull TypeEvalContext context) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getSequenceElementType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getSequenceElementType"));
        }
        PyExpression[] elements = sequence.getElements();
        if (elements.length == 0 || elements.length > 10) {
            return null;
        }
        PyType result = context.getType(elements[0]);
        if (result == null) {
            return null;
        }
        for (int i = 1; i < elements.length; ++i) {
            PyType elementType = context.getType(elements[i]);
            if (elementType != null && elementType.equals(result)) continue;
            return null;
        }
        return result;
    }

    @Nullable
    public PyFile getBuiltinsFile() {
        return this.myBuiltinsFile;
    }

    public boolean isValid() {
        return this.myBuiltinsFile != null && this.myBuiltinsFile.isValid();
    }

    @Nullable
    public PsiElement getByName(@NonNls String name) {
        PsiElement element;
        if (this.myBuiltinsFile != null && (element = this.myBuiltinsFile.getElementNamed(name)) != null) {
            return element;
        }
        if (this.myExceptionsFile != null) {
            return this.myExceptionsFile.getElementNamed(name);
        }
        return null;
    }

    @Nullable
    public PyClass getClass(@NonNls String name) {
        if (this.myBuiltinsFile != null) {
            return this.myBuiltinsFile.findTopLevelClass(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PyClassTypeImpl getObjectType(@NonNls String name) {
        PyClassTypeImpl val;
        Map<String, PyClassTypeImpl> map = this.myTypeCache;
        synchronized (map) {
            if (this.myBuiltinsFile != null && this.myBuiltinsFile.getModificationStamp() != this.myModStamp) {
                this.myTypeCache.clear();
                this.myModStamp = this.myBuiltinsFile.getModificationStamp();
            }
            val = this.myTypeCache.get(name);
        }
        if (val == null) {
            PyClass cls = this.getClass(name);
            if (cls != null) {
                val = new PyClassTypeImpl(cls, false);
                val.assertValid(name);
                Map<String, PyClassTypeImpl> map2 = this.myTypeCache;
                synchronized (map2) {
                    this.myTypeCache.put(name, val);
                }
            }
        } else {
            val.assertValid(name);
        }
        return val;
    }

    @Nullable
    public PyClassType getObjectType() {
        return this.getObjectType("object");
    }

    @Nullable
    public PyClassType getListType() {
        return this.getObjectType("list");
    }

    @Nullable
    public PyClassType getDictType() {
        return this.getObjectType("dict");
    }

    @Nullable
    public PyClassType getSetType() {
        return this.getObjectType("set");
    }

    @Nullable
    public PyClassType getTupleType() {
        return this.getObjectType("tuple");
    }

    @Nullable
    public PyClassType getIntType() {
        return this.getObjectType("int");
    }

    @Nullable
    public PyClassType getFloatType() {
        return this.getObjectType("float");
    }

    @Nullable
    public PyClassType getComplexType() {
        return this.getObjectType("complex");
    }

    @Nullable
    public PyClassType getStrType() {
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getBytesType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getUnicodeType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getObjectType("unicode");
    }

    @Nullable
    public PyType getStringType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getByteStringType(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/jetbrains/python/psi/impl/PyBuiltinCache", "getByteStringType"));
        }
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getStrOrUnicodeType();
    }

    private PyType getStrOrUnicodeType() {
        return PyUnionType.union(this.getObjectType("str"), this.getObjectType("unicode"));
    }

    @Nullable
    public PyClassType getBoolType() {
        return this.getObjectType("bool");
    }

    @Nullable
    public PyClassType getOldstyleClassobjType() {
        return this.getObjectType("___Classobj");
    }

    @Nullable
    public PyClassType getClassMethodType() {
        return this.getObjectType("classmethod");
    }

    @Nullable
    public PyClassType getStaticMethodType() {
        return this.getObjectType("staticmethod");
    }

    public boolean isBuiltin(@Nullable PsiElement target) {
        if (target == null) {
            return false;
        }
        if (!target.isValid()) {
            return false;
        }
        PsiFile the_file = target.getContainingFile();
        if (!(the_file instanceof PyFile)) {
            return false;
        }
        return the_file == this.myBuiltinsFile || the_file == this.myExceptionsFile;
    }

    public static boolean isInBuiltins(@NotNull PyExpression expression) {
        PsiElement resolved;
        PyBuiltinCache cache;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyBuiltinCache", "isInBuiltins"));
        }
        if (expression instanceof PyQualifiedExpression && ((PyQualifiedExpression)expression).isQualified()) {
            return false;
        }
        String name = expression.getName();
        PsiReference reference = expression.getReference();
        return reference != null && name != null && (cache = PyBuiltinCache.getInstance((PsiElement)expression)).getByName(name) != null && (resolved = reference.resolve()) != null && cache.isBuiltin(resolved);
    }
}

