/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBinaryExpressionImpl
extends PyElementImpl
implements PyBinaryExpression {
    public PyBinaryExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyBinaryExpression(this);
    }

    @Override
    @Nullable
    public PyExpression getLeftExpression() {
        return (PyExpression)PsiTreeUtil.getChildOfType((PsiElement)this, PyExpression.class);
    }

    @Override
    public PyExpression getRightExpression() {
        return (PyExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getLeftExpression(), PyExpression.class);
    }

    @Override
    @Nullable
    public PyElementType getOperator() {
        PsiElement psiOperator = this.getPsiOperator();
        return psiOperator != null ? (PyElementType)psiOperator.getNode().getElementType() : null;
    }

    @Override
    @Nullable
    public PsiElement getPsiOperator() {
        ASTNode node = this.getNode();
        ASTNode child = node.findChildByType(PyElementTypes.BINARY_OPS);
        if (child != null) {
            return child.getPsi();
        }
        return null;
    }

    @Override
    public boolean isOperator(String chars) {
        StringBuilder buf = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType elType = child.getElementType();
            if (!(elType instanceof PyElementType) || !PyElementTypes.BINARY_OPS.contains(elType)) continue;
            buf.append(child.getText());
        }
        return buf.toString().equals(chars);
    }

    @Override
    @Nullable
    public PyExpression getOppositeExpression(PyExpression expression) throws IllegalArgumentException {
        PyExpression right = this.getRightExpression();
        PyExpression left = this.getLeftExpression();
        if (expression.equals(left)) {
            return right;
        }
        if (expression.equals(right)) {
            return left;
        }
        throw new IllegalArgumentException("expression " + expression + " is neither left exp or right exp");
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl", "deleteChildInternal"));
        }
        PyExpression left = this.getLeftExpression();
        PyExpression right = this.getRightExpression();
        if (left == child.getPsi() && right != null) {
            this.replace((PsiElement)right);
        } else if (right == child.getPsi() && left != null) {
            this.replace((PsiElement)left);
        } else {
            throw new IncorrectOperationException("Element " + child.getPsi() + " is neither left expression or right expression");
        }
    }

    @NotNull
    public PsiPolyVariantReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.noImplicits());
        if (psiPolyVariantReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl", "getReference"));
        }
        return psiPolyVariantReference;
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(PyResolveContext context) {
        PyOperatorReference pyOperatorReference = new PyOperatorReference(this, context);
        if (pyOperatorReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl", "getReference"));
        }
        return pyOperatorReference;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyType type;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyBinaryExpressionImpl", "getType"));
        }
        if (this.isOperator("and") || this.isOperator("or")) {
            PyType rightType;
            PyExpression left = this.getLeftExpression();
            PyType leftType = left != null ? context.getType(left) : null;
            PyExpression right = this.getRightExpression();
            PyType pyType = rightType = right != null ? context.getType(right) : null;
            if (leftType == null && rightType == null) {
                return null;
            }
            return PyUnionType.union(leftType, rightType);
        }
        PyTypeChecker.AnalyzeCallResults results = PyTypeChecker.analyzeCall(this, context);
        if (results != null && !PyTypeChecker.isUnknown(type = results.getCallable().getCallType(context, this)) && !(type instanceof PyNoneType)) {
            return type;
        }
        if (PyNames.COMPARISON_OPERATORS.contains((Object)this.getReferencedName())) {
            return PyBuiltinCache.getInstance((PsiElement)this).getBoolType();
        }
        return null;
    }

    @Override
    public PyExpression getQualifier() {
        return this.getLeftExpression();
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        return PyPsiUtils.asQualifiedName(this);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getReferencedName() {
        PyElementType t = this.getOperator();
        return t != null ? t.getSpecialMethodName() : null;
    }

    @Override
    public ASTNode getNameElement() {
        PsiElement op = this.getPsiOperator();
        return op != null ? op.getNode() : null;
    }
}

