/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBaseElementImpl<T extends StubElement>
extends StubBasedPsiElementBase<T>
implements PyElement {
    public PyBaseElementImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PyBaseElementImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PythonLanguage getLanguage() {
        PythonLanguage pythonLanguage = (PythonLanguage)PythonFileType.INSTANCE.getLanguage();
        if (pythonLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBaseElementImpl", "getLanguage"));
        }
        return pythonLanguage;
    }

    public String toString() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos >= 0) {
            className = className.substring(pos + 1);
        }
        if (className.endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        return className;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/psi/impl/PyBaseElementImpl", "accept"));
        }
        if (visitor instanceof PyElementVisitor) {
            this.acceptPyVisitor((PyElementVisitor)visitor);
        } else {
            super.accept(visitor);
        }
    }

    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyElement(this);
    }

    @NotNull
    protected <T extends PyElement> T[] childrenToPsi(TokenSet filterSet, T[] array) {
        ASTNode[] nodes = this.getNode().getChildren(filterSet);
        PyElement[] pyElementArray = PyPsiUtils.nodesToPsi((ASTNode[])nodes, array);
        if (pyElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBaseElementImpl", "childrenToPsi"));
        }
        return pyElementArray;
    }

    @Nullable
    protected <T extends PyElement> T childToPsi(TokenSet filterSet, int index) {
        ASTNode[] nodes = this.getNode().getChildren(filterSet);
        if (nodes.length <= index) {
            return null;
        }
        return (T)((PyElement)nodes[index].getPsi());
    }

    @Nullable
    protected <T extends PyElement> T childToPsi(IElementType elType) {
        ASTNode node = this.getNode().findChildByType(elType);
        if (node == null) {
            return null;
        }
        return (T)((PyElement)node.getPsi());
    }

    @NotNull
    protected <T extends PyElement> T childToPsiNotNull(TokenSet filterSet, int index) {
        T child = this.childToPsi(filterSet, index);
        if (child == null) {
            throw new RuntimeException("child must not be null: expression text " + this.getText());
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBaseElementImpl", "childToPsiNotNull"));
        }
        return t;
    }

    @NotNull
    protected <T extends PyElement> T childToPsiNotNull(IElementType elType) {
        T child = this.childToPsi(elType);
        if (child == null) {
            throw new RuntimeException("child must not be null; expression text " + this.getText());
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyBaseElementImpl", "childToPsiNotNull"));
        }
        return t;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PyResolveContext resolveContext;
        PsiElement element = this.findElementAt(offset);
        if (element == null || element instanceof OuterLanguageElement) {
            return null;
        }
        offset = this.getTextRange().getStartOffset() + offset - element.getTextRange().getStartOffset();
        ArrayList<PsiReference> referencesList = new ArrayList<PsiReference>();
        PsiFile file = element.getContainingFile();
        PyResolveContext pyResolveContext = resolveContext = file != null ? PyResolveContext.defaultContext().withTypeEvalContext(TypeEvalContext.codeAnalysis(file.getProject(), file)) : PyResolveContext.defaultContext();
        while (element != null) {
            PyBaseElementImpl.addReferences(offset, element, referencesList, resolveContext);
            offset = element.getStartOffsetInParent() + offset;
            if (element instanceof PsiFile) break;
            element = element.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(new PsiReference[referencesList.size()]), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    private static void addReferences(int offset, PsiElement element, Collection<PsiReference> outReferences, PyResolveContext resolveContext) {
        PsiReference[] references;
        if (element instanceof PyReferenceOwner) {
            PsiReference[] psiReferenceArray;
            PsiPolyVariantReference reference = ((PyReferenceOwner)element).getReference(resolveContext);
            if (reference == null) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            } else {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = reference;
            }
            references = psiReferenceArray;
        } else {
            references = element.getReferences();
        }
        for (PsiReference reference : references) {
            for (TextRange range : ReferenceRange.getRanges((PsiReference)reference)) {
                assert (range != null) : reference;
                if (!range.containsOffset(offset)) continue;
                outReferences.add(reference);
            }
        }
    }
}

