/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.toolbox.FP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAssignmentStatementImpl
extends PyElementImpl
implements PyAssignmentStatement {
    private PyExpression[] myTargets;

    public PyAssignmentStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyAssignmentStatement(this);
    }

    @Override
    public PyExpression[] getTargets() {
        if (this.myTargets == null) {
            this.myTargets = this.calcTargets(false);
        }
        return this.myTargets;
    }

    @Override
    @NotNull
    public PyExpression[] getRawTargets() {
        PyExpression[] pyExpressionArray = this.calcTargets(true);
        if (pyExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl", "getRawTargets"));
        }
        return pyExpressionArray;
    }

    private PyExpression[] calcTargets(boolean raw) {
        ASTNode[] eqSigns = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.EQ}));
        if (eqSigns.length == 0) {
            return PyExpression.EMPTY_ARRAY;
        }
        ASTNode lastEq = eqSigns[eqSigns.length - 1];
        ArrayList<PyExpression> candidates = new ArrayList<PyExpression>();
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && node != lastEq; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof PyExpression)) continue;
            if (raw) {
                candidates.add((PyExpression)psi);
                continue;
            }
            PyAssignmentStatementImpl.addCandidate(candidates, (PyExpression)psi);
        }
        ArrayList<PyExpression> targets = new ArrayList<PyExpression>();
        for (PyExpression expr : candidates) {
            if (!raw && !(expr instanceof PyTargetExpression) && !(expr instanceof PyReferenceExpression) && !(expr instanceof PySubscriptionExpression) && !(expr instanceof PySliceExpression)) continue;
            targets.add(expr);
        }
        return targets.toArray(new PyExpression[targets.size()]);
    }

    private static void addCandidate(List<PyExpression> candidates, PyExpression psi) {
        if (psi instanceof PyParenthesizedExpression) {
            PyAssignmentStatementImpl.addCandidate(candidates, ((PyParenthesizedExpression)psi).getContainedExpression());
        } else if (psi instanceof PySequenceExpression) {
            PyExpression[] pyExpressions;
            for (PyExpression pyExpression : pyExpressions = ((PySequenceExpression)psi).getElements()) {
                PyAssignmentStatementImpl.addCandidate(candidates, pyExpression);
            }
        } else if (psi instanceof PyStarExpression) {
            PyExpression expression = ((PyStarExpression)psi).getExpression();
            if (expression != null) {
                PyAssignmentStatementImpl.addCandidate(candidates, expression);
            }
        } else {
            candidates.add(psi);
        }
    }

    @Override
    @Nullable
    public PyExpression getAssignedValue() {
        PsiElement child;
        for (child = this.getLastChild(); child != null && !(child instanceof PyExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyExpression)child;
    }

    @Override
    @NotNull
    public List<Pair<PyExpression, PyExpression>> getTargetsToValuesMapping() {
        Object[] constituents;
        SmartList ret = new SmartList();
        if (!PsiTreeUtil.hasErrorElements((PsiElement)this) && (constituents = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyExpression.class)) != null && constituents.length > 1) {
            PyExpression rhs = constituents[constituents.length - 1];
            ArrayList lhses = Lists.newArrayList((Object[])constituents);
            if (lhses.size() > 0) {
                lhses.remove(lhses.size() - 1);
            }
            for (PyExpression lhs : lhses) {
                PyAssignmentStatementImpl.mapToValues(lhs, rhs, (List<Pair<PyExpression, PyExpression>>)ret);
            }
        }
        SmartList smartList = ret;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl", "getTargetsToValuesMapping"));
        }
        return smartList;
    }

    @Override
    @Nullable
    public PyExpression getLeftHandSideExpression() {
        PsiElement child;
        for (child = this.getFirstChild(); child != null && !(child instanceof PyExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyExpression)child;
    }

    @Override
    public boolean isAssignmentTo(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl", "isAssignmentTo"));
        }
        PyExpression lhs = this.getLeftHandSideExpression();
        return lhs instanceof PyTargetExpression && name.equals(lhs.getName());
    }

    private static void mapToValues(PyExpression lhs, PyExpression rhs, List<Pair<PyExpression, PyExpression>> map) {
        PySequenceExpression lhs_tuple = null;
        PyExpression lhs_one = null;
        if (lhs instanceof PySequenceExpression) {
            lhs_tuple = (PySequenceExpression)lhs;
        } else if (lhs != null) {
            lhs_one = lhs;
        }
        PySequenceExpression rhs_tuple = null;
        PyExpression rhs_one = null;
        if (rhs instanceof PyParenthesizedExpression) {
            PyExpression exp = ((PyParenthesizedExpression)rhs).getContainedExpression();
            if (exp instanceof PyTupleExpression) {
                rhs_tuple = (PySequenceExpression)exp;
            } else {
                rhs_one = rhs;
            }
        } else if (rhs instanceof PySequenceExpression) {
            rhs_tuple = (PySequenceExpression)rhs;
        } else if (rhs != null) {
            rhs_one = rhs;
        }
        if (lhs_one != null) {
            map.add((Pair<PyExpression, PyExpression>)Pair.create((Object)lhs_one, (Object)rhs));
        } else if (lhs_tuple != null && rhs_one != null) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(rhs_one.getProject());
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)lhs);
            int counter = 0;
            for (PyExpression tuple_elt : lhs_tuple.getElements()) {
                try {
                    PyExpression expression = elementGenerator.createExpressionFromText(languageLevel, rhs_one.getText() + "[" + counter + "]");
                    map.add((Pair<PyExpression, PyExpression>)Pair.create((Object)tuple_elt, (Object)expression));
                }
                catch (IncorrectOperationException e) {
                    // empty catch block
                }
                ++counter;
            }
        } else if (lhs_tuple != null && rhs_tuple != null) {
            map.addAll(FP.zipList(Arrays.asList(lhs_tuple.getElements()), Arrays.asList(rhs_tuple.getElements()), null, null));
        }
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        List<PyExpression> expressions = PyUtil.flattenedParensAndStars(this.getTargets());
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        for (PyExpression expression : expressions) {
            if (expression instanceof PyQualifiedExpression && ((PyQualifiedExpression)expression).isQualified()) continue;
            result.add(expression);
        }
        ArrayList<PyElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl", "iterateNames"));
        }
        return arrayList;
    }

    public PyElement getElementNamed(String the_name) {
        PyExpression[] targets = this.getTargets();
        if (targets.length == 1 && targets[0] instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)targets[0];
            return !target.isQualified() && the_name.equals(target.getName()) ? target : null;
        }
        return NameDefiner.IterHelper.findName(this.iterateNames(), the_name);
    }

    @Override
    public boolean mustResolveOutside() {
        return true;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myTargets = null;
    }
}

