/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.CallArgumentsMappingImpl;
import com.jetbrains.python.psi.impl.PyElementGeneratorImpl;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListImpl
extends PyElementImpl
implements PyArgumentList {
    private static final NoKeyArguments NO_KEY_ARGUMENTS = new NoKeyArguments();

    public PyArgumentListImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyArgumentList(this);
    }

    @Override
    @NotNull
    public Collection<PyExpression> getArgumentExpressions() {
        PyExpression[] arguments = this.getArguments();
        ArrayList<PyExpression> result = new ArrayList<PyExpression>(arguments.length);
        for (PyExpression expression : arguments) {
            if (expression instanceof PyKeywordArgument) {
                PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
                result.add(valueExpression);
            }
            if (!(expression instanceof PyReferenceExpression)) continue;
            result.add(expression);
        }
        ArrayList<PyExpression> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "getArgumentExpressions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyExpression[] getArguments() {
        PyExpression[] pyExpressionArray = (PyExpression[])this.childrenToPsi(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens(), PyExpression.EMPTY_ARRAY);
        if (pyExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "getArguments"));
        }
        return pyExpressionArray;
    }

    @Override
    @Nullable
    public PyKeywordArgument getKeywordArgument(String name) {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            PyKeywordArgument arg;
            String keyword;
            if (node.getElementType() != PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION || (keyword = (arg = (PyKeywordArgument)node.getPsi()).getKeyword()) == null || !keyword.equals(name)) continue;
            return arg;
        }
        return null;
    }

    @Override
    public void addArgument(@NotNull PyExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "addArgument"));
        }
        PyElementGeneratorImpl generator = new PyElementGeneratorImpl(this.getProject());
        Deque<PyKeywordArgument> keywordArguments = this.getKeyWordArguments();
        Deque<PyExpression> parameters = this.getParameters();
        if (keywordArguments.isEmpty() && parameters.isEmpty()) {
            ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, null, arg);
            return;
        }
        if (arg instanceof PyKeywordArgument) {
            if (parameters.isEmpty()) {
                ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, keywordArguments.getLast(), arg);
            } else if (keywordArguments.isEmpty()) {
                ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, parameters.getLast(), arg);
            } else {
                ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, keywordArguments.getLast(), arg);
            }
        } else if (parameters.isEmpty()) {
            ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, null, arg);
        } else {
            ((PyElementGenerator)generator).insertItemIntoListRemoveRedundantCommas(this, parameters.getLast(), arg);
        }
    }

    @NotNull
    private Deque<PyExpression> getParameters() {
        PyExpression[] childrenOfType = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyExpression.class);
        if (childrenOfType == null) {
            ArrayDeque<PyExpression> arrayDeque = new ArrayDeque<PyExpression>(0);
            if (arrayDeque == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "getParameters"));
            }
            return arrayDeque;
        }
        ArrayDeque arrayDeque = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(childrenOfType), (Predicate)NO_KEY_ARGUMENTS));
        if (arrayDeque == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "getParameters"));
        }
        return arrayDeque;
    }

    @NotNull
    private Deque<PyKeywordArgument> getKeyWordArguments() {
        ArrayDeque arrayDeque = Queues.newArrayDeque((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)this, PyKeywordArgument.class));
        if (arrayDeque == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "getKeyWordArguments"));
        }
        return arrayDeque;
    }

    @Override
    public void addArgumentFirst(PyExpression arg) {
        ASTNode node = this.getNode();
        ASTNode[] pars = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LPAR}));
        if (pars.length == 0) {
            try {
                this.add((PsiElement)arg);
            }
            catch (IncorrectOperationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            ASTNode anchorBefore;
            ASTNode before = PyUtil.getNextNonWhitespace(pars[0]);
            if (before != null && PyArgumentListImpl.elementPrecedesElementsOfType(before, PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens())) {
                ASTNode comma = this.createComma();
                node.addChild(comma, before);
                node.addChild((ASTNode)ASTFactory.whitespace(" "), before);
                anchorBefore = comma;
            } else {
                anchorBefore = before;
            }
            ASTNode argNode = arg.getNode();
            if (anchorBefore == null) {
                node.addChild(argNode);
            } else {
                node.addChild(argNode, anchorBefore);
            }
        }
    }

    @NotNull
    private ASTNode createComma() {
        ASTNode aSTNode = PyElementGenerator.getInstance(this.getProject()).createComma();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "createComma"));
        }
        return aSTNode;
    }

    private static boolean elementPrecedesElementsOfType(ASTNode before, TokenSet expressions) {
        for (ASTNode node = before; node != null; node = node.getTreeNext()) {
            if (!expressions.contains(node.getElementType())) continue;
            return true;
        }
        return false;
    }

    private void addArgumentLastWithoutComma(PyExpression arg) {
        ASTNode par = this.getClosingParen();
        if (par == null) {
            try {
                this.add((PsiElement)arg);
            }
            catch (IncorrectOperationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            this.getNode().addChild(arg.getNode(), par);
        }
    }

    @Override
    @Nullable
    public ASTNode getClosingParen() {
        ASTNode node = this.getNode();
        ASTNode[] children = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RPAR}));
        return children.length == 0 ? null : children[children.length - 1];
    }

    private void addArgumentNode(PyExpression arg, ASTNode beforeThis, boolean commaFirst) {
        ASTNode comma = PyElementGenerator.getInstance(this.getProject()).createComma();
        ASTNode node = this.getNode();
        ASTNode argNode = arg.getNode();
        if (commaFirst) {
            node.addChild(comma, beforeThis);
            node.addChild((ASTNode)ASTFactory.whitespace(" "), beforeThis);
            node.addChild(argNode, beforeThis);
        } else {
            node.addChild(argNode, beforeThis);
            node.addChild(comma, beforeThis);
            node.addChild((ASTNode)ASTFactory.whitespace(" "), beforeThis);
        }
    }

    @Override
    public void addArgumentAfter(PyExpression argument, @Nullable PyExpression afterThis) {
        if (afterThis == null) {
            this.addArgumentFirst(argument);
            return;
        }
        boolean good = false;
        for (PyExpression expression : this.getArguments()) {
            if (expression != afterThis) continue;
            good = true;
            break;
        }
        if (!good) {
            throw new IllegalArgumentException("Expression " + afterThis + " is not an argument (" + Arrays.toString(this.getArguments()) + ")");
        }
        for (ASTNode node = afterThis.getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            if (type == PyTokenTypes.RPAR) {
                this.addArgumentNode(argument, node, true);
                break;
            }
            if (PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens().contains(type)) {
                this.addArgumentNode(argument, node, true);
                break;
            }
            if (type != PyTokenTypes.COMMA) continue;
            ASTNode next = PyUtil.getNextNonWhitespace(node);
            if (next == null) {
                this.addArgumentLastWithoutComma(argument);
                break;
            }
            if (next.getElementType() == PyTokenTypes.RPAR) {
                this.addArgumentNode(argument, next, false);
                break;
            }
            this.addArgumentNode(argument, next, false);
            break;
        }
    }

    @Override
    @Nullable
    public PyCallExpression getCallExpression() {
        return (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this, PyCallExpression.class);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "deleteChildInternal"));
        }
        if (Arrays.asList(this.getArguments()).contains(node.getPsi())) {
            ASTNode next = PyPsiUtils.getNextComma(node);
            if (next == null) {
                next = PyPsiUtils.getPrevComma(node);
            }
            if (next != null) {
                this.deleteChildInternal(next);
            }
        }
        super.deleteChildInternal(node);
    }

    @Override
    @NotNull
    public CallArgumentsMapping analyzeCall(PyResolveContext resolveContext) {
        CallArgumentsMapping callArgumentsMapping = this.analyzeCall(resolveContext, 0);
        if (callArgumentsMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "analyzeCall"));
        }
        return callArgumentsMapping;
    }

    @Override
    @NotNull
    public CallArgumentsMapping analyzeCall(PyResolveContext resolveContext, int offset) {
        CallArgumentsMappingImpl ret = new CallArgumentsMappingImpl(this);
        PyCallExpression call = this.getCallExpression();
        if (call != null) {
            PyCallExpression.PyMarkedCallee resolvedCallee = call.resolveCallee(resolveContext, offset);
            if (resolvedCallee != null) {
                ret.mapArguments(resolvedCallee, resolveContext.getTypeEvalContext());
            } else {
                ret.verifyArguments();
            }
        }
        CallArgumentsMappingImpl callArgumentsMappingImpl = ret;
        if (callArgumentsMappingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "analyzeCall"));
        }
        return callArgumentsMappingImpl;
    }

    @Override
    @Nullable
    public PyExpression getValueExpressionForParam(@NotNull FunctionParameter parameter) {
        PyKeywordArgument kwarg;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/psi/impl/PyArgumentListImpl", "getValueExpressionForParam"));
        }
        String parameterName = parameter.getName();
        if (parameterName != null && (kwarg = this.getKeywordArgument(parameterName)) != null) {
            return kwarg.getValueExpression();
        }
        PyExpression[] arguments = this.getArguments();
        int position = parameter.getPosition();
        if (position != -1 && arguments.length > position) {
            PyExpression result = arguments[position];
            if (result instanceof PyKeywordArgument) {
                ((PyKeywordArgument)result).getValueExpression();
            } else {
                return result;
            }
        }
        return null;
    }

    private static class NoKeyArguments
    extends NotNullPredicate<PyExpression> {
        private NoKeyArguments() {
        }

        @Override
        protected boolean applyNotNull(@NotNull PyExpression input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyArgumentListImpl$NoKeyArguments", "applyNotNull"));
            }
            return PsiTreeUtil.getParentOfType((PsiElement)input, PyKeywordArgument.class) == null && !(input instanceof PyKeywordArgument);
        }
    }
}

