/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAnyExpressionEvaluator
extends PyEvaluator {
    private final boolean myEvalSequence;

    public PyAnyExpressionEvaluator(boolean evalSequence) {
        this.myEvalSequence = evalSequence;
    }

    @Override
    @NotNull
    public Object evaluate(PyExpression expr) {
        Object evaluate = super.evaluate(expr);
        Object object = evaluate != null ? evaluate : expr;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluate"));
        }
        return object;
    }

    @Override
    public Object concatenate(Object lhs, Object rhs) {
        List<Object> evaluate = super.concatenate(lhs, rhs);
        return evaluate != null ? evaluate : Arrays.asList(lhs, rhs);
    }

    @Override
    protected Object evaluateReferenceExpression(PyReferenceExpression expr) {
        Object evaluate = super.evaluateReferenceExpression(expr);
        return evaluate != null ? evaluate : expr;
    }

    @Override
    protected Object evaluateCall(PyCallExpression call) {
        Object evaluate = super.evaluateCall(call);
        return evaluate != null ? evaluate : call;
    }

    @Override
    protected Object evaluateSequenceExpression(PySequenceExpression expr) {
        return this.myEvalSequence ? super.evaluateSequenceExpression(expr) : expr;
    }

    @Nullable
    public static <T> T evaluateOne(@NotNull PyExpression expression, @NotNull Class<T> aClass) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateOne"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateOne"));
        }
        PyAnyExpressionEvaluator evaluator = new PyAnyExpressionEvaluator(false);
        Object evaluate = evaluator.evaluate(expression);
        T resultSingle = PyUtil.as(evaluate, aClass);
        if (resultSingle != null) {
            return resultSingle;
        }
        List resultMultiple = PyUtil.as(evaluate, List.class);
        if (resultMultiple != null && !resultMultiple.isEmpty()) {
            return PyUtil.as(resultMultiple.get(0), aClass);
        }
        return null;
    }

    @Nullable
    public static String evaluateString(@NotNull PyExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateString"));
        }
        return PyUtil.as(new PyAnyExpressionEvaluator(false).evaluate(expression), String.class);
    }

    @NotNull
    public static <T> List<T> evaluateIterable(@NotNull PyExpression expression, @NotNull Class<T> aClass) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateIterable"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateIterable"));
        }
        PyAnyExpressionEvaluator evaluator = new PyAnyExpressionEvaluator(true);
        Object evaluate = evaluator.evaluate(expression);
        T resultSingle = PyUtil.as(evaluate, aClass);
        if (resultSingle != null) {
            List<T> list = Collections.singletonList(resultSingle);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateIterable"));
            }
            return list;
        }
        List<T> list = PyUtil.asList(PyUtil.as(evaluate, List.class), aClass);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyAnyExpressionEvaluator", "evaluateIterable"));
        }
        return list;
    }
}

