/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import com.jetbrains.python.toolbox.Maybe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyBunch<MType> {
    protected Maybe<MType> myGetter;
    protected Maybe<MType> mySetter;
    protected Maybe<MType> myDeleter;
    protected String myDoc;
    protected PyTargetExpression mySite;

    @NotNull
    public Maybe<MType> getGetter() {
        Maybe<MType> maybe = this.myGetter;
        if (maybe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PropertyBunch", "getGetter"));
        }
        return maybe;
    }

    @NotNull
    public Maybe<MType> getSetter() {
        Maybe<MType> maybe = this.mySetter;
        if (maybe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PropertyBunch", "getSetter"));
        }
        return maybe;
    }

    @NotNull
    public Maybe<MType> getDeleter() {
        Maybe<MType> maybe = this.myDeleter;
        if (maybe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PropertyBunch", "getDeleter"));
        }
        return maybe;
    }

    @Nullable
    public String getDoc() {
        return this.myDoc;
    }

    @NotNull
    protected abstract Maybe<MType> translate(@Nullable PyExpression var1);

    @Nullable
    public static PyCallExpression findPropertyCallSite(@Nullable PyExpression source) {
        PyCallExpression call;
        PyExpression callee;
        if (source instanceof PyCallExpression && (callee = (call = (PyCallExpression)source).getCallee()) instanceof PyReferenceExpression) {
            PsiFile file;
            PyReferenceExpression ref = (PyReferenceExpression)callee;
            if (ref.isQualified()) {
                return null;
            }
            if ("property".equals(callee.getName()) && (PropertyBunch.isBuiltinFile(file = source.getContainingFile()) || !PropertyBunch.resolvesLocally(ref))) {
                return call;
            }
        }
        return null;
    }

    private static boolean isBuiltinFile(PsiFile file) {
        String name = file.getName();
        return "__builtin__.py".equals(name) || "builtins.py".equals(name);
    }

    protected static boolean resolvesLocally(@NotNull PyReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/python/psi/impl/PropertyBunch", "resolvesLocally"));
        }
        String name = ref.getName();
        if (name != null) {
            ResolveProcessor processor = new ResolveProcessor(name);
            processor.setLocalResolve();
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, (PsiElement)ref, name, null);
            return processor.getResult() != null;
        }
        return false;
    }

    protected static <MType> boolean fillFromCall(PyExpression source, PropertyBunch<MType> target) {
        PyArgumentList arglist;
        PyCallExpression call = PropertyBunch.findPropertyCallSite(source);
        if (call != null && (arglist = call.getArgumentList()) != null) {
            PyExpression[] accessors = new PyExpression[3];
            String doc = null;
            int position = 0;
            Object[] keywords = new String[]{"fget", "fset", "fdel", "doc"};
            for (PyExpression arg : arglist.getArguments()) {
                int index = -1;
                if (arg instanceof PyKeywordArgument) {
                    String keyword = ((PyKeywordArgument)arg).getKeyword();
                    index = ArrayUtil.indexOf((Object[])keywords, (Object)keyword);
                    if (index < 0) continue;
                    position = -1;
                } else if (position >= 0) {
                    index = position++;
                }
                if (index < 0) continue;
                arg = PyUtil.peelArgument(arg);
                if (index < 3) {
                    accessors[index] = arg;
                    continue;
                }
                if (index != 3 || !(arg instanceof PyStringLiteralExpression)) continue;
                doc = ((PyStringLiteralExpression)arg).getStringValue();
            }
            target.myGetter = target.translate(accessors[0]);
            target.mySetter = target.translate(accessors[1]);
            target.myDeleter = target.translate(accessors[2]);
            target.myDoc = doc;
            return true;
        }
        return false;
    }
}

