/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import java.util.ArrayList;
import java.util.List;

public class ParamHelper {
    private ParamHelper() {
    }

    public static void walkDownParamArray(PyParameter[] params, ParamWalker walker) {
        int last = params.length - 1;
        int i = 0;
        for (PyParameter param : params) {
            PyTupleParameter t_param = param.getAsTuple();
            if (t_param != null) {
                PyParameter[] nested_params = t_param.getContents();
                PyTupleParameter tpar = (PyTupleParameter)param;
                walker.enterTupleParameter(tpar, i == 0, i == last);
                ParamHelper.walkDownParamArray(nested_params, walker);
                walker.leaveTupleParameter(tpar, i == 0, i == last);
            } else {
                PyNamedParameter namedParameter = param.getAsNamed();
                if (namedParameter != null) {
                    walker.visitNamedParameter(namedParameter, i == 0, i == last);
                } else {
                    walker.visitSingleStarParameter((PySingleStarParameter)param, i == 0, i == last);
                }
            }
            ++i;
        }
    }

    public static List<PyNamedParameter> collectNamedParameters(PyParameterList plist) {
        final ArrayList<PyNamedParameter> result = new ArrayList<PyNamedParameter>(10);
        ParamHelper.walkDownParamArray(plist.getParameters(), new ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                result.add(param);
            }
        });
        return result;
    }

    public static abstract class ParamVisitor
    implements ParamWalker {
        @Override
        public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
        }

        @Override
        public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
        }
    }

    public static interface ParamWalker {
        public void enterTupleParameter(PyTupleParameter var1, boolean var2, boolean var3);

        public void leaveTupleParameter(PyTupleParameter var1, boolean var2, boolean var3);

        public void visitNamedParameter(PyNamedParameter var1, boolean var2, boolean var3);

        public void visitSingleStarParameter(PySingleStarParameter var1, boolean var2, boolean var3);
    }
}

