/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallArgumentsMappingImpl
implements CallArgumentsMapping {
    private final Map<PyExpression, PyNamedParameter> myPlainMappedParams = new LinkedHashMap<PyExpression, PyNamedParameter>();
    private final Map<PyExpression, List<PyNamedParameter>> myNestedMappedParams = new LinkedHashMap<PyExpression, List<PyNamedParameter>>();
    private PyStarArgument myTupleArg;
    private PyStarArgument myKwdArg;
    private final List<PyNamedParameter> myTupleMappedParams = new ArrayList<PyNamedParameter>();
    private final List<PyNamedParameter> myKwdMappedParams = new ArrayList<PyNamedParameter>();
    private final List<PyNamedParameter> myUnmappedParams = new ArrayList<PyNamedParameter>();
    private final Map<PyExpression, EnumSet<CallArgumentsMapping.ArgFlag>> myArgFlags = new HashMap<PyExpression, EnumSet<CallArgumentsMapping.ArgFlag>>();
    private PyCallExpression.PyMarkedCallee myMarkedCallee = null;
    private PyArgumentList myArgumentList;

    public CallArgumentsMappingImpl(PyArgumentList arglist) {
        this.myArgumentList = arglist;
    }

    public void mapArguments(PyCallExpression.PyMarkedCallee resolved_callee, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/CallArgumentsMappingImpl", "mapArguments"));
        }
        PyExpression[] arguments = this.myArgumentList.getArguments();
        this.myMarkedCallee = resolved_callee;
        LinkedList unmatched_subargs = new LinkedList();
        List<PyExpression> unmatched_args = this.verifyArguments();
        List<PyParameter> parameters = PyUtil.getParameters(this.myMarkedCallee.getCallable(), context);
        LinkedHashMap<PyNamedParameter, PyExpression> slots = new LinkedHashMap<PyNamedParameter, PyExpression>();
        PyNamedParameter kwd_par = null;
        PyNamedParameter tuple_par = null;
        HashSet<PyExpression> mapped_args = new HashSet<PyExpression>();
        int implicitOffset = resolved_callee.getImplicitOffset();
        int positional_index = 0;
        int i = 0;
        for (PyParameter par : parameters) {
            if (tuple_par == null && kwd_par == null && positional_index < implicitOffset) {
                ++positional_index;
                continue;
            }
            PyNamedParameter n_par = par.getAsNamed();
            if (n_par != null) {
                if (n_par.isPositionalContainer()) {
                    tuple_par = n_par;
                } else if (n_par.isKeywordContainer()) {
                    kwd_par = n_par;
                } else {
                    slots.put(n_par, null);
                    if (tuple_par == null && kwd_par == null) {
                        ++positional_index;
                    }
                }
            } else {
                PyTupleParameter t_par = par.getAsTuple();
                if (t_par != null) {
                    ++positional_index;
                }
            }
            ++i;
        }
        for (i = 0; i < implicitOffset && i < parameters.size(); ++i) {
            slots.remove(parameters.get(i).getAsNamed());
            ++positional_index;
        }
        int cnt = implicitOffset;
        int positional_bound = arguments.length;
        ListIterator<PyExpression> unmatched_arg_iter = unmatched_args.listIterator();
        while (unmatched_arg_iter.hasNext()) {
            PyExpression arg = unmatched_arg_iter.next();
            if (arg instanceof PyStarArgument || arg instanceof PyKeywordArgument) {
                positional_bound = cnt;
                break;
            }
            if (cnt >= parameters.size() || cnt >= positional_index) break;
            PyParameter par = parameters.get(cnt);
            PyNamedParameter n_par = par.getAsNamed();
            if (n_par != null) {
                ++cnt;
                slots.put(n_par, PyUtil.peelArgument(arg));
                mapped_args.add(arg);
                continue;
            }
            PyTupleParameter t_par = par.getAsTuple();
            if (t_par == null) continue;
            if (arg instanceof PyParenthesizedExpression) {
                mapped_args.add(arg);
            } else {
                PyType arg_type = context.getType(arg);
                if (arg_type != null && arg_type.isBuiltin() && "list".equals(arg_type.getName())) {
                    mapped_args.add(arg);
                }
            }
            unmatched_arg_iter.previous();
            MyParamVisitor visitor = new MyParamVisitor(unmatched_arg_iter, this);
            visitor.enterTuple(t_par.getAsTuple());
            unmatched_subargs.addAll(visitor.getUnmatchedSubargs());
            ++cnt;
        }
        for (Map.Entry<PyExpression, List<PyNamedParameter>> pair : this.myNestedMappedParams.entrySet()) {
            PyExpression arg = pair.getKey();
            List<PyNamedParameter> params = pair.getValue();
            mapped_args.add(arg);
            for (PyNamedParameter n_par : params) {
                slots.remove(n_par);
            }
        }
        for (PyExpression arg : unmatched_subargs) {
            this.markArgument(arg, CallArgumentsMapping.ArgFlag.IS_UNMAPPED);
        }
        boolean seen_named_args = false;
        LinkedHashMap<String, PyNamedParameter> parameter_by_name = new LinkedHashMap<String, PyNamedParameter>();
        for (PyParameter par : parameters) {
            PyNamedParameter n_par = par.getAsNamed();
            if (n_par == null) continue;
            parameter_by_name.put(n_par.getName(), n_par);
        }
        for (PyExpression arg : arguments) {
            if (!(arg instanceof PyKeywordArgument)) continue;
            String arg_name = ((PyKeywordArgument)arg).getKeyword();
            PyNamedParameter respective_par = (PyNamedParameter)parameter_by_name.get(arg_name);
            if (respective_par != null && !respective_par.isKeywordContainer() && !respective_par.isPositionalContainer()) {
                if (slots.get(respective_par) != null) {
                    this.markArgument(arg, CallArgumentsMapping.ArgFlag.IS_DUP);
                } else {
                    slots.put(respective_par, arg);
                }
            } else if (kwd_par != null) {
                this.myPlainMappedParams.put(arg, kwd_par);
                mapped_args.add(arg);
            }
            seen_named_args = true;
        }
        boolean tuple_arg_not_exhausted = false;
        boolean tuple_dup_found = false;
        if (cnt < parameters.size() && cnt < positional_index && this.myTupleArg != null) {
            PyParameter par;
            int mapped_params_count;
            boolean tuple_length_known;
            int tuple_length;
            PyType tuple_arg_type = null;
            PyExpression expression = (PyExpression)PsiTreeUtil.getChildOfType((PsiElement)this.myTupleArg, PyExpression.class);
            if (expression != null) {
                tuple_arg_type = context.getType(expression);
            }
            if (tuple_arg_type instanceof PyTupleType) {
                tuple_length = ((PyTupleType)tuple_arg_type).getElementCount();
                tuple_length_known = true;
            } else {
                tuple_length = 2000000;
                tuple_length_known = false;
            }
            for (mapped_params_count = 0; cnt < parameters.size() && cnt < positional_index && mapped_params_count < tuple_length && !((par = parameters.get(cnt)) instanceof PySingleStarParameter); ++cnt, ++mapped_params_count) {
                PyNamedParameter n_par = par.getAsNamed();
                if (slots.containsKey(n_par)) {
                    PyExpression arg_here = (PyExpression)slots.get(n_par);
                    if (arg_here != null) {
                        EnumSet<CallArgumentsMapping.ArgFlag> flags;
                        if (!tuple_length_known || (flags = this.myArgFlags.get(arg_here)) != null && !flags.isEmpty()) break;
                        this.markArgument(arg_here, CallArgumentsMapping.ArgFlag.IS_DUP);
                        tuple_dup_found = true;
                        break;
                    }
                    if (n_par == null) continue;
                    this.myTupleMappedParams.add(n_par);
                    mapped_args.add(this.myTupleArg);
                    slots.remove(n_par);
                    continue;
                }
                if (n_par != tuple_par) continue;
                mapped_params_count = tuple_length;
                break;
            }
            if (tuple_length_known && mapped_params_count < tuple_length || mapped_params_count == 0) {
                tuple_arg_not_exhausted = true;
            }
        }
        if (tuple_par != null) {
            for (i = 0; i < arguments.length && mapped_args.contains(arguments[i]) && CallArgumentsMappingImpl.isPositionalArg(arguments[i]); ++i) {
            }
            if (i < arguments.length && CallArgumentsMappingImpl.isPositionalArg(arguments[i])) {
                while (i < arguments.length && !mapped_args.contains(arguments[i]) && CallArgumentsMappingImpl.isPositionalArg(arguments[i])) {
                    this.myPlainMappedParams.put(arguments[i], tuple_par);
                    mapped_args.add(arguments[i]);
                    ++i;
                }
            }
        }
        if (this.myTupleArg != null && tuple_par != null) {
            if (!mapped_args.contains(this.myTupleArg)) {
                this.myTupleMappedParams.add(tuple_par);
                mapped_args.add(this.myTupleArg);
            } else if (!seen_named_args && tuple_arg_not_exhausted) {
                this.myTupleMappedParams.add(tuple_par);
                mapped_args.add(this.myTupleArg);
                tuple_arg_not_exhausted = false;
            }
        }
        if (tuple_arg_not_exhausted && !tuple_dup_found) {
            this.markArgument(this.myTupleArg, CallArgumentsMapping.ArgFlag.IS_TOO_LONG);
        }
        if (this.myKwdArg != null) {
            for (int j = implicitOffset; j < parameters.size(); ++j) {
                PyParameter par = parameters.get(j);
                PyNamedParameter namedParameter = par.getAsNamed();
                if (namedParameter == null || namedParameter.isKeywordContainer() || namedParameter.isPositionalContainer() || slots.get(namedParameter) != null) continue;
                slots.put(namedParameter, this.myKwdArg);
            }
        }
        if (this.myKwdArg != null && kwd_par != null && !mapped_args.contains(this.myKwdArg)) {
            this.myKwdMappedParams.add(kwd_par);
            mapped_args.add(this.myKwdArg);
        }
        for (Map.Entry pair : slots.entrySet()) {
            PyNamedParameter n_par = (PyNamedParameter)pair.getKey();
            PyExpression arg = (PyExpression)pair.getValue();
            if (arg == null) {
                if (n_par.hasDefaultValue()) continue;
                this.myUnmappedParams.add(n_par);
                continue;
            }
            if (arg == this.myTupleArg) {
                this.myTupleMappedParams.add(n_par);
                continue;
            }
            if (arg == this.myKwdArg) {
                this.myKwdMappedParams.add(n_par);
                continue;
            }
            this.myPlainMappedParams.put(arg, n_par);
        }
        for (PyExpression arg : slots.values()) {
            if (arg == null) continue;
            mapped_args.add(arg);
        }
        for (PyExpression arg : arguments) {
            EnumSet<CallArgumentsMapping.ArgFlag> flags;
            if (mapped_args.contains(arg) || (flags = this.myArgFlags.get(arg)) != null && !flags.isEmpty()) continue;
            this.markArgument(arg, CallArgumentsMapping.ArgFlag.IS_UNMAPPED);
        }
    }

    public List<PyExpression> verifyArguments() {
        LinkedList<PyExpression> unmatched_args = new LinkedList<PyExpression>();
        Collections.addAll(unmatched_args, this.myArgumentList.getArguments());
        for (PyExpression arg : this.myArgumentList.getArguments()) {
            if (!(arg instanceof PyStarArgument)) continue;
            PyStarArgument star_arg = (PyStarArgument)arg;
            if (star_arg.isKeyword()) {
                if (this.myKwdArg == null) {
                    this.myKwdArg = star_arg;
                    continue;
                }
                this.markArgument(arg, CallArgumentsMapping.ArgFlag.IS_DUP_KWD);
                unmatched_args.remove(arg);
                continue;
            }
            if (this.myTupleArg == null) {
                this.myTupleArg = star_arg;
                continue;
            }
            this.markArgument(arg, CallArgumentsMapping.ArgFlag.IS_DUP_TUPLE);
            unmatched_args.remove(arg);
        }
        this.markPastBoundPositionalArguments(this.myArgumentList.getArguments());
        return unmatched_args;
    }

    private void markPastBoundPositionalArguments(PyExpression[] arguments) {
        boolean seenKwArg = false;
        boolean seenKeyword = false;
        boolean seenStar = false;
        for (PyExpression arg : arguments) {
            if (arg == this.myKwdArg) {
                seenKwArg = true;
            } else if (arg instanceof PyKeywordArgument) {
                seenKeyword = true;
            } else if (arg instanceof PyStarArgument) {
                seenStar = true;
            }
            if (!seenKeyword && !seenKwArg && !seenStar || arg instanceof PyStarArgument || !seenKwArg && arg instanceof PyKeywordArgument) continue;
            this.markArgument(arg, CallArgumentsMapping.ArgFlag.IS_POS_PAST_KWD);
        }
    }

    private static boolean isPositionalArg(PyExpression arg) {
        return !(arg instanceof PyKeywordArgument) && !(arg instanceof PyStarArgument);
    }

    @Override
    @NotNull
    public Map<PyExpression, PyNamedParameter> getPlainMappedParams() {
        Map<PyExpression, PyNamedParameter> map = this.myPlainMappedParams;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/CallArgumentsMappingImpl", "getPlainMappedParams"));
        }
        return map;
    }

    @Override
    @NotNull
    public Map<PyExpression, List<PyNamedParameter>> getNestedMappedParams() {
        Map<PyExpression, List<PyNamedParameter>> map = this.myNestedMappedParams;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/CallArgumentsMappingImpl", "getNestedMappedParams"));
        }
        return map;
    }

    @Override
    public PyStarArgument getTupleArg() {
        return this.myTupleArg;
    }

    @Override
    @NotNull
    public List<PyNamedParameter> getTupleMappedParams() {
        List<PyNamedParameter> list = this.myTupleMappedParams;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/CallArgumentsMappingImpl", "getTupleMappedParams"));
        }
        return list;
    }

    @Override
    public PyStarArgument getKwdArg() {
        return this.myKwdArg;
    }

    @Override
    @NotNull
    public List<PyNamedParameter> getKwdMappedParams() {
        List<PyNamedParameter> list = this.myKwdMappedParams;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/CallArgumentsMappingImpl", "getKwdMappedParams"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyNamedParameter> getUnmappedParams() {
        List<PyNamedParameter> list = this.myUnmappedParams;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/CallArgumentsMappingImpl", "getUnmappedParams"));
        }
        return list;
    }

    @Override
    @Nullable
    public PyCallExpression.PyMarkedCallee getMarkedCallee() {
        return this.myMarkedCallee;
    }

    @Override
    public Map<PyExpression, EnumSet<CallArgumentsMapping.ArgFlag>> getArgumentFlags() {
        return this.myArgFlags;
    }

    @Override
    public boolean hasProblems() {
        for (Map.Entry<PyExpression, EnumSet<CallArgumentsMapping.ArgFlag>> arg_entry : this.myArgFlags.entrySet()) {
            EnumSet<CallArgumentsMapping.ArgFlag> flags = arg_entry.getValue();
            if (flags.isEmpty()) continue;
            return true;
        }
        return this.myUnmappedParams.size() > 0;
    }

    @Override
    public PyArgumentList getArgumentList() {
        return this.myArgumentList;
    }

    protected PyExpression markArgument(PyExpression arg, CallArgumentsMapping.ArgFlag ... flags) {
        EnumSet<CallArgumentsMapping.ArgFlag> argflags = this.myArgFlags.get(arg);
        if (argflags == null) {
            argflags = EnumSet.noneOf(CallArgumentsMapping.ArgFlag.class);
        }
        ContainerUtil.addAll(argflags, (Object[])flags);
        this.myArgFlags.put(arg, argflags);
        return arg;
    }

    static class MyParamVisitor
    extends PyElementVisitor {
        private final Iterator<PyExpression> myArgIterator;
        private final CallArgumentsMappingImpl myResult;
        private final List<PyExpression> myUnmatchedSubargs;

        private MyParamVisitor(Iterator<PyExpression> arg_iterator, CallArgumentsMappingImpl ret) {
            this.myArgIterator = arg_iterator;
            this.myResult = ret;
            this.myUnmatchedSubargs = new ArrayList<PyExpression>(5);
        }

        private Collection<PyExpression> getUnmatchedSubargs() {
            return this.myUnmatchedSubargs;
        }

        @Override
        public void visitPyParameter(PyParameter node) {
            PyNamedParameter named = node.getAsNamed();
            if (named != null) {
                this.enterNamed(named);
            } else {
                this.enterTuple(node.getAsTuple());
            }
        }

        public void enterTuple(PyTupleParameter param) {
            PyExpression arg = null;
            if (this.myArgIterator.hasNext()) {
                arg = this.myArgIterator.next();
            }
            PyExpression[] elements = null;
            if (arg instanceof PyParenthesizedExpression) {
                PyExpression inner_expr = ((PyParenthesizedExpression)arg).getContainedExpression();
                if (inner_expr instanceof PyTupleExpression) {
                    elements = ((PyTupleExpression)inner_expr).getElements();
                }
            } else if (arg instanceof PyListLiteralExpression) {
                elements = ((PyListLiteralExpression)arg).getElements();
            }
            PyParameter[] nested_params = param.getContents();
            if (elements != null) {
                Iterator<PyExpression> subargs_iterator = Arrays.asList(elements).iterator();
                MyParamVisitor visitor = new MyParamVisitor(subargs_iterator, this.myResult);
                for (PyParameter nested : nested_params) {
                    nested.accept(visitor);
                }
                this.myUnmatchedSubargs.addAll(visitor.getUnmatchedSubargs());
                while (subargs_iterator.hasNext()) {
                    PyExpression overflown_arg = subargs_iterator.next();
                    this.myResult.markArgument(overflown_arg, CallArgumentsMapping.ArgFlag.IS_UNMAPPED);
                }
            } else {
                final ArrayList nested_mapped = new ArrayList(nested_params.length);
                ParamHelper.walkDownParamArray(nested_params, new ParamHelper.ParamVisitor(){

                    @Override
                    public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                        nested_mapped.add(param);
                    }
                });
                this.myResult.myNestedMappedParams.put(arg, nested_mapped);
            }
        }

        public void enterNamed(PyNamedParameter param) {
            if (this.myArgIterator.hasNext()) {
                PyExpression subarg = this.myArgIterator.next();
                this.myResult.myPlainMappedParams.put(subarg, param);
            } else {
                this.myResult.myUnmappedParams.add(param);
            }
        }
    }
}

