/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.completion.OverwriteEqualsInsertHandler;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.magicLiteral.PyMagicLiteralTools;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PySetuptoolsNamespaceIndex;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHelper;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUtil {
    private PyUtil() {
    }

    public static ASTNode getNextNonWhitespace(ASTNode after) {
        ASTNode node = after;
        while (PyUtil.isWhitespace(node = node.getTreeNext())) {
        }
        return node;
    }

    public static ASTNode getPreviousNonWhitespace(ASTNode after) {
        ASTNode node = after;
        while (PyUtil.isWhitespace(node = node.getTreePrev())) {
        }
        return node;
    }

    private static boolean isWhitespace(ASTNode node) {
        return node != null && node.getElementType().equals(TokenType.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getFirstNonCommentAfter(PsiElement start) {
        PsiElement seeker = start;
        while (seeker instanceof PsiWhiteSpace || seeker instanceof PsiComment) {
            seeker = seeker.getNextSibling();
        }
        return seeker;
    }

    @Nullable
    public static PsiElement getFirstNonCommentBefore(PsiElement start) {
        PsiElement seeker = start;
        while (seeker instanceof PsiWhiteSpace || seeker instanceof PsiComment) {
            seeker = seeker.getPrevSibling();
        }
        return seeker;
    }

    @NotNull
    public static <T extends PyElement> T[] getAllChildrenOfType(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "getAllChildrenOfType"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/psi/PyUtil", "getAllChildrenOfType"));
        }
        SmartList result = new SmartList();
        for (PsiElement child : element.getChildren()) {
            if (PyUtil.instanceOf(child, aClass)) {
                result.add((PyElement)child);
                continue;
            }
            ContainerUtil.addAll((Collection)result, (Object[])PyUtil.getAllChildrenOfType((PsiElement)child, aClass));
        }
        PyElement[] pyElementArray = (PyElement[])ArrayUtil.toObjectArray((Collection)result, aClass);
        if (pyElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getAllChildrenOfType"));
        }
        return pyElementArray;
    }

    protected static List<PyExpression> _unfoldParenExprs(PyExpression[] targets, List<PyExpression> receiver, boolean unfoldListLiterals, boolean unfoldStarExpressions) {
        for (PyExpression exp : targets) {
            if (exp instanceof PyParenthesizedExpression) {
                PyParenthesizedExpression parex = (PyParenthesizedExpression)exp;
                PyUtil._unfoldParenExprs(new PyExpression[]{parex.getContainedExpression()}, receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyTupleExpression) {
                PyTupleExpression tupex = (PyTupleExpression)exp;
                PyUtil._unfoldParenExprs(tupex.getElements(), receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyListLiteralExpression && unfoldListLiterals) {
                PyListLiteralExpression listLiteral = (PyListLiteralExpression)exp;
                PyUtil._unfoldParenExprs(listLiteral.getElements(), receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyStarExpression && unfoldStarExpressions) {
                PyUtil._unfoldParenExprs(new PyExpression[]{((PyStarExpression)exp).getExpression()}, receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp == null) continue;
            receiver.add(exp);
        }
        return receiver;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndTuples(PyExpression ... targets) {
        List<PyExpression> list = PyUtil._unfoldParenExprs(targets, new ArrayList<PyExpression>(targets.length), false, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "flattenedParensAndTuples"));
        }
        return list;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndLists(PyExpression ... targets) {
        List<PyExpression> list = PyUtil._unfoldParenExprs(targets, new ArrayList<PyExpression>(targets.length), true, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "flattenedParensAndLists"));
        }
        return list;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndStars(PyExpression ... targets) {
        List<PyExpression> list = PyUtil._unfoldParenExprs(targets, new ArrayList<PyExpression>(targets.length), false, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "flattenedParensAndStars"));
        }
        return list;
    }

    public static boolean instanceOf(Object obj, Class ... possibleClasses) {
        if (obj == null || possibleClasses == null) {
            return false;
        }
        for (Class cls : possibleClasses) {
            if (!cls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NonNls
    public static String getReadableRepr(PsiElement elt, boolean cutAtEOL) {
        if (elt == null) {
            if ("null!" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getReadableRepr"));
            }
            return "null!";
        }
        ASTNode node = elt.getNode();
        if (node == null) {
            if ("null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getReadableRepr"));
            }
            return "null";
        }
        String s = node.getText();
        int cut_pos = cutAtEOL ? s.indexOf(10) : -1;
        if (cut_pos < 0) {
            cut_pos = s.length();
        }
        String string = s.substring(0, Math.min(cut_pos, s.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getReadableRepr"));
        }
        return string;
    }

    @Nullable
    public static PyClass getContainingClassOrSelf(PsiElement element) {
        PsiElement current;
        for (current = element; current != null && !(current instanceof PyClass); current = current.getParent()) {
        }
        return (PyClass)current;
    }

    @Nullable
    public static PyFile getContainingPyFile(PyElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof PyFile ? (PyFile)containingFile : null;
    }

    public static void showBalloon(Project project, String message, MessageType messageType) {
        JFrame frame = WindowManager.getInstance().getFrame(project.isDefault() ? null : project);
        if (frame == null) {
            return;
        }
        JRootPane component = frame.getRootPane();
        if (component == null) {
            return;
        }
        Rectangle rect = component.getVisibleRect();
        Point p = new Point(rect.x + rect.width - 10, rect.y + 10);
        RelativePoint point = new RelativePoint((Component)component, p);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).setShowCallout(false).setCloseButtonEnabled(true).createBalloon().show(point, Balloon.Position.atLeft);
    }

    @NonNls
    public static String nvl(Object s) {
        if (s != null) {
            return "'" + s.toString() + "'";
        }
        return "null";
    }

    public static void addListNode(PsiElement parent, PsiElement newItem, ASTNode beforeThis, boolean isFirst, boolean isLast, boolean addWhitespace) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(parent)) {
            return;
        }
        ASTNode node = parent.getNode();
        assert (node != null);
        ASTNode itemNode = newItem.getNode();
        assert (itemNode != null);
        Project project = parent.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance(project);
        if (!isFirst) {
            node.addChild(gen.createComma(), beforeThis);
        }
        node.addChild(itemNode, beforeThis);
        if (!isLast) {
            node.addChild(gen.createComma(), beforeThis);
        }
        if (addWhitespace) {
            node.addChild((ASTNode)ASTFactory.whitespace(" "), beforeThis);
        }
    }

    public static void removeListNode(PsiElement item) {
        PsiElement parent = item.getParent();
        if (!FileModificationService.getInstance().preparePsiElementForWrite(parent)) {
            return;
        }
        ASTNode binder = parent.getNode();
        assert (binder != null) : "parent node is null, ensureWritable() lied";
        boolean got_comma_after = PyUtil.eraseWhitespaceAndComma(binder, item, false);
        if (!got_comma_after) {
            PyUtil.eraseWhitespaceAndComma(binder, item, true);
        }
        item.delete();
    }

    public static boolean eraseWhitespaceAndComma(ASTNode parent_node, PsiElement item, boolean backwards) {
        boolean got_comma = false;
        ASTNode current = item.getNode();
        boolean have_skipped_the_item = false;
        while (current != null) {
            ASTNode candidate = current;
            ASTNode aSTNode = current = backwards ? current.getTreePrev() : current.getTreeNext();
            if (have_skipped_the_item) {
                boolean is_comma = ",".equals(candidate.getText());
                got_comma |= is_comma;
                if (!is_comma && candidate.getElementType() != TokenType.WHITE_SPACE) break;
                parent_node.removeChild(candidate);
                continue;
            }
            have_skipped_the_item = true;
        }
        return got_comma;
    }

    @NotNull
    public static List<PyClass> getAllSuperClasses(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/psi/PyUtil", "getAllSuperClasses"));
        }
        ArrayList<PyClass> superClasses = new ArrayList<PyClass>();
        for (PyClass ancestor : pyClass.getAncestorClasses()) {
            if ("___Classobj".equals(ancestor.getName())) continue;
            superClasses.add(ancestor);
        }
        ArrayList<PyClass> arrayList = superClasses;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getAllSuperClasses"));
        }
        return arrayList;
    }

    @Nullable
    public static PyType getSpecialAttributeType(@Nullable PyReferenceExpression ref, TypeEvalContext context) {
        PyExpression qualifier;
        if (ref != null && (qualifier = ref.getQualifier()) != null) {
            PyType qualifierType;
            String attr_name = ref.getReferencedName();
            if ("__class__".equals(attr_name)) {
                PyType qualifierType2 = context.getType(qualifier);
                if (qualifierType2 instanceof PyClassType) {
                    return new PyClassTypeImpl(((PyClassType)qualifierType2).getPyClass(), true);
                }
            } else if ("__dict__".equals(attr_name) && (qualifierType = context.getType(qualifier)) instanceof PyClassType && ((PyClassType)qualifierType).isDefinition()) {
                return PyBuiltinCache.getInstance((PsiElement)ref).getDictType();
            }
        }
        return null;
    }

    @NotNull
    public static <T> T sure(T thing) {
        if (thing == null) {
            throw new IncorrectOperationException();
        }
        T t = thing;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "sure"));
        }
        return t;
    }

    public static void sure(boolean thing) {
        if (!thing) {
            throw new IncorrectOperationException();
        }
    }

    public static boolean isAttribute(PyTargetExpression ex) {
        return PyUtil.isInstanceAttribute(ex) || PyUtil.isClassAttribute((PsiElement)ex);
    }

    public static boolean isInstanceAttribute(PyExpression target) {
        PyFunction method;
        if (!(target instanceof PyTargetExpression)) {
            return false;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)target);
        if (owner instanceof PyFunction && (method = (PyFunction)owner).getContainingClass() != null) {
            if (method.getStub() != null) {
                return true;
            }
            PyParameter[] params = method.getParameterList().getParameters();
            if (params.length > 0) {
                PyTargetExpression targetExpr = (PyTargetExpression)target;
                PyExpression qualifier = targetExpr.getQualifier();
                return qualifier != null && qualifier.getText().equals(params[0].getName());
            }
        }
        return false;
    }

    public static boolean isClassAttribute(PsiElement element) {
        return element instanceof PyTargetExpression && ScopeUtil.getScopeOwner(element) instanceof PyClass;
    }

    public static boolean isIfNameEqualsMain(PyIfStatement ifStatement) {
        PyExpression condition = ifStatement.getIfPart().getCondition();
        return PyUtil.isNameEqualsMain(condition);
    }

    private static boolean isNameEqualsMain(PyExpression condition) {
        if (condition instanceof PyParenthesizedExpression) {
            return PyUtil.isNameEqualsMain(((PyParenthesizedExpression)condition).getContainedExpression());
        }
        if (condition instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)condition;
            if (binaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                return PyUtil.isNameEqualsMain(binaryExpression.getLeftExpression()) || PyUtil.isNameEqualsMain(binaryExpression.getRightExpression());
            }
            PyExpression rhs = binaryExpression.getRightExpression();
            return binaryExpression.getOperator() == PyTokenTypes.EQEQ && binaryExpression.getLeftExpression().getText().equals("__name__") && rhs != null && rhs.getText().contains("__main__");
        }
        return false;
    }

    @Nullable
    public static List<PsiElement> searchForWrappingMethod(PsiElement start, boolean deep) {
        PsiElement seeker = start;
        ArrayList<PsiElement> ret = new ArrayList<PsiElement>(2);
        while (seeker != null) {
            PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)seeker, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (func != null) {
                PyClass cls = func.getContainingClass();
                if (cls != null) {
                    ret.add(func);
                    ret.add(cls);
                    return ret;
                }
                if (deep) {
                    ret.add(func);
                    seeker = func;
                    continue;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean inSameFile(@NotNull PsiElement e1, @NotNull PsiElement e2) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/jetbrains/python/psi/PyUtil", "inSameFile"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e2", "com/jetbrains/python/psi/PyUtil", "inSameFile"));
        }
        PsiFile f1 = e1.getContainingFile();
        PsiFile f2 = e2.getContainingFile();
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1 == f2;
    }

    public static boolean isTopLevel(@NotNull PsiElement element) {
        StubElement parentStub;
        StubElement stub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "isTopLevel"));
        }
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null && (parentStub = stub.getParentStub()) != null) {
            return parentStub.getPsi() instanceof PsiFile;
        }
        return ScopeUtil.getScopeOwner(element) instanceof PsiFile;
    }

    public static void deletePycFiles(String pyFilePath) {
        if (pyFilePath.endsWith(".py")) {
            File file;
            File pycache;
            File pyo;
            ArrayList<File> filesToDelete = new ArrayList<File>();
            File pyc = new File(pyFilePath + "c");
            if (pyc.exists()) {
                filesToDelete.add(pyc);
            }
            if ((pyo = new File(pyFilePath + "o")).exists()) {
                filesToDelete.add(pyo);
            }
            if ((pycache = new File((file = new File(pyFilePath)).getParentFile(), "__pycache__")).isDirectory()) {
                final String shortName = FileUtil.getNameWithoutExtension((File)file);
                Collections.addAll(filesToDelete, pycache.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (!FileUtilRt.extensionEquals((String)pathname.getName(), (String)"pyc")) {
                            return false;
                        }
                        String nameWithMagic = FileUtil.getNameWithoutExtension((File)pathname);
                        return FileUtil.getNameWithoutExtension((String)nameWithMagic).equals(shortName);
                    }
                }));
            }
            FileUtil.asyncDelete(filesToDelete);
        }
    }

    public static String getElementNameWithoutExtension(PsiNamedElement psiNamedElement) {
        return psiNamedElement instanceof PyFile ? FileUtil.getNameWithoutExtension((String)((PyFile)psiNamedElement).getName()) : psiNamedElement.getName();
    }

    public static boolean hasUnresolvedAncestors(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/psi/PyUtil", "hasUnresolvedAncestors"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyUtil", "hasUnresolvedAncestors"));
        }
        for (PyClassLikeType type : cls.getAncestorTypes(context)) {
            if (type != null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static AccessDirection getPropertyAccessDirection(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/psi/PyUtil", "getPropertyAccessDirection"));
        }
        Property property = function.getProperty();
        if (property != null) {
            if (property.getGetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.READ;
                if (accessDirection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getPropertyAccessDirection"));
                }
                return accessDirection;
            }
            if (property.getSetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.WRITE;
                if (accessDirection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getPropertyAccessDirection"));
                }
                return accessDirection;
            }
            if (property.getDeleter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.DELETE;
                if (accessDirection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getPropertyAccessDirection"));
                }
                return accessDirection;
            }
        }
        AccessDirection accessDirection = AccessDirection.READ;
        if (accessDirection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getPropertyAccessDirection"));
        }
        return accessDirection;
    }

    public static boolean deleteParameter(@NotNull PyFunction problemFunction, int index) {
        if (problemFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemFunction", "com/jetbrains/python/psi/PyUtil", "deleteParameter"));
        }
        PyParameterList parameterList = problemFunction.getParameterList();
        PyParameter[] parameters = parameterList.getParameters();
        if (parameters.length <= 0) {
            return false;
        }
        PyParameter first = parameters[index];
        PsiElement last = parameters.length > index + 1 ? parameters[index + 1] : parameterList.getLastChild();
        Object prevSibling = last.getPrevSibling() != null ? last.getPrevSibling() : parameters[index];
        parameterList.deleteChildRange((PsiElement)first, (PsiElement)prevSibling);
        return true;
    }

    public static void removeQualifier(@NotNull PyReferenceExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "removeQualifier"));
        }
        PyExpression qualifier = element.getQualifier();
        if (qualifier == null) {
            return;
        }
        if (qualifier instanceof PyCallExpression) {
            PyExpression calleeQualifier;
            StringBuilder newElement = new StringBuilder(element.getLastChild().getText());
            PyExpression callee = ((PyCallExpression)qualifier).getCallee();
            if (callee instanceof PyReferenceExpression && (calleeQualifier = ((PyReferenceExpression)callee).getQualifier()) != null) {
                newElement.insert(0, calleeQualifier.getText() + ".");
            }
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(element.getProject());
            PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)element), newElement.toString());
            element.replace((PsiElement)expression);
        } else {
            PsiElement dot = qualifier.getNextSibling();
            if (dot != null) {
                dot.delete();
            }
            qualifier.delete();
        }
    }

    @NotNull
    public static String computeElementNameForStringSearch(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "computeElementNameForStringSearch"));
        }
        if (element instanceof PyFile) {
            String string = FileUtil.getNameWithoutExtension((String)((PyFile)element).getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "computeElementNameForStringSearch"));
            }
            return string;
        }
        if (element instanceof PsiDirectory) {
            String string = ((PsiDirectory)element).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "computeElementNameForStringSearch"));
            }
            return string;
        }
        if (element instanceof PyStringLiteralExpression && PyMagicLiteralTools.isMagicLiteral(element) && (name = ((StringLiteralExpression)element).getStringValue()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "computeElementNameForStringSearch"));
            }
            return string;
        }
        if (element instanceof PyElement && (name = ((PyElement)element).getName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "computeElementNameForStringSearch"));
            }
            return string;
        }
        String string = element.getNode().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "computeElementNameForStringSearch"));
        }
        return string;
    }

    public static boolean isOwnScopeComprehension(@NotNull PyComprehensionElement comprehension) {
        if (comprehension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comprehension", "com/jetbrains/python/psi/PyUtil", "isOwnScopeComprehension"));
        }
        boolean isAtLeast30 = LanguageLevel.forElement(comprehension).isAtLeast(LanguageLevel.PYTHON30);
        boolean isListComprehension = comprehension instanceof PyListCompExpression;
        return !isListComprehension || isAtLeast30;
    }

    public static boolean hasCustomDecorators(@NotNull PyDecoratable decoratable) {
        if (decoratable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratable", "com/jetbrains/python/psi/PyUtil", "hasCustomDecorators"));
        }
        return PyKnownDecoratorUtil.hasNonBuiltinDecorator(decoratable, TypeEvalContext.codeInsightFallback(null));
    }

    public static boolean isDecoratedAsAbstract(@NotNull PyDecoratable decoratable) {
        if (decoratable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratable", "com/jetbrains/python/psi/PyUtil", "isDecoratedAsAbstract"));
        }
        return PyKnownDecoratorUtil.hasAbstractDecorator(decoratable, TypeEvalContext.codeInsightFallback(null));
    }

    public static ASTNode createNewName(PyElement element, String name) {
        return PyElementGenerator.getInstance(element.getProject()).createNameIdentifier(name, LanguageLevel.forElement((PsiElement)element));
    }

    @NotNull
    public static PsiElement resolveToTheTop(@NotNull PsiElement elementToResolve) {
        PsiElement resolve;
        PsiReference reference;
        if (elementToResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToResolve", "com/jetbrains/python/psi/PyUtil", "resolveToTheTop"));
        }
        PsiElement currentElement = elementToResolve;
        while ((reference = currentElement.getReference()) != null && (resolve = reference.resolve()) != null && !resolve.equals(currentElement) && PyUtil.inSameFile(resolve, currentElement)) {
            currentElement = resolve;
        }
        PsiElement psiElement = currentElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "resolveToTheTop"));
        }
        return psiElement;
    }

    @NotNull
    public static List<PsiElement> multiResolveTopPriority(@NotNull PsiElement element, @NotNull PyResolveContext resolveContext) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "multiResolveTopPriority"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/PyUtil", "multiResolveTopPriority"));
        }
        if (element instanceof PyReferenceOwner) {
            PsiPolyVariantReference ref = ((PyReferenceOwner)element).getReference(resolveContext);
            List<PsiElement> list = PyUtil.filterTopPriorityResults(ref.multiResolve(false));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "multiResolveTopPriority"));
            }
            return list;
        }
        PsiReference reference = element.getReference();
        List<PsiElement> list = reference != null ? Collections.singletonList(reference.resolve()) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "multiResolveTopPriority"));
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> multiResolveTopPriority(@NotNull PsiPolyVariantReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/python/psi/PyUtil", "multiResolveTopPriority"));
        }
        List<PsiElement> list = PyUtil.filterTopPriorityResults(reference.multiResolve(false));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "multiResolveTopPriority"));
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> filterTopPriorityResults(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/jetbrains/python/psi/PyUtil", "filterTopPriorityResults"));
        }
        if (resolveResults.length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "filterTopPriorityResults"));
            }
            return list;
        }
        ArrayList<PsiElement> filtered = new ArrayList<PsiElement>();
        int maxRate = PyUtil.getMaxRate(resolveResults);
        for (ResolveResult resolveResult : resolveResults) {
            int rate;
            int n = rate = resolveResult instanceof RatedResolveResult ? ((RatedResolveResult)resolveResult).getRate() : 0;
            if (rate < maxRate) continue;
            filtered.add(resolveResult.getElement());
        }
        ArrayList<PsiElement> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "filterTopPriorityResults"));
        }
        return arrayList;
    }

    private static int getMaxRate(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/jetbrains/python/psi/PyUtil", "getMaxRate"));
        }
        int maxRate = Integer.MIN_VALUE;
        for (ResolveResult resolveResult : resolveResults) {
            int rate;
            if (!(resolveResult instanceof RatedResolveResult) || (rate = ((RatedResolveResult)resolveResult).getRate()) <= maxRate) continue;
            maxRate = rate;
        }
        return maxRate;
    }

    @Nullable
    public static PyFunction getInitMethod(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/psi/PyUtil", "getInitMethod"));
        }
        return pyClass.findMethodByName("__init__", false);
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        VirtualFile folder;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/PyUtil", "getLanguageLevelForVirtualFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/python/psi/PyUtil", "getLanguageLevelForVirtualFile"));
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((folder = virtualFile.getParent()) != null) {
            LanguageLevel level = (LanguageLevel)((Object)folder.getUserData(LanguageLevel.KEY));
            if (level == null) {
                level = PythonLanguageLevelPusher.getFileLanguageLevel(project, virtualFile);
            }
            if (level != null) {
                LanguageLevel languageLevel = level;
                if (languageLevel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getLanguageLevelForVirtualFile"));
                }
                return languageLevel;
            }
        } else {
            LanguageLevel languageLevel;
            LanguageLevel level = (LanguageLevel)((Object)virtualFile.getUserData(LanguageLevel.KEY));
            if (level != null) {
                LanguageLevel languageLevel2 = level;
                if (languageLevel2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getLanguageLevelForVirtualFile"));
                }
                return languageLevel2;
            }
            if (ApplicationManager.getApplication().isUnitTestMode() && (languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL) != null) {
                LanguageLevel languageLevel3 = languageLevel;
                if (languageLevel3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getLanguageLevelForVirtualFile"));
                }
                return languageLevel3;
            }
        }
        LanguageLevel languageLevel = PyUtil.guessLanguageLevel(project);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getLanguageLevelForVirtualFile"));
        }
        return languageLevel;
    }

    private static LanguageLevel guessLanguageLevel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/PyUtil", "guessLanguageLevel"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        if (moduleManager != null) {
            for (Module projectModule : moduleManager.getModules()) {
                Sdk sdk = PythonSdkType.findPythonSdk(projectModule);
                if (sdk == null) continue;
                return PythonSdkType.getLanguageLevelForSdk(sdk);
            }
        }
        return LanguageLevel.getDefault();
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PyUtil", "as"));
        }
        if (expression == null) {
            return null;
        }
        if (clazz.isAssignableFrom(expression.getClass())) {
            return (T)expression;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findReference(@NotNull PsiElement element, @NotNull Class<T> expectedClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "findReference"));
        }
        if (expectedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedClass", "com/jetbrains/python/psi/PyUtil", "findReference"));
        }
        for (PsiReference reference : element.getReferences()) {
            PsiElement result = (PsiElement)PyUtil.as(reference.resolve(), expectedClass);
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> asList(@Nullable Collection<?> expression, @NotNull Class<T> elementClass) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/jetbrains/python/psi/PyUtil", "asList"));
        }
        if (expression == null || expression.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "asList"));
            }
            return list;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object element : expression) {
            T toAdd = PyUtil.as(element, elementClass);
            if (toAdd == null) continue;
            result.add(toAdd);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "asList"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "getChildByFilter"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/python/psi/PyUtil", "getChildByFilter"));
        }
        ASTNode node = element.getNode();
        if (node != null) {
            ASTNode[] children = node.getChildren(filter);
            return 0 <= number && number < children.length ? children[number].getPsi() : null;
        }
        return null;
    }

    @Nullable
    public static PsiElement getFirstChildOfType(@NotNull PsiElement element, @NotNull PyElementType type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "getFirstChildOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/PyUtil", "getFirstChildOfType"));
        }
        ASTNode child = element.getNode().findChildByType((IElementType)type);
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    public static PsiElement turnDirIntoInit(PsiElement target) {
        if (target instanceof PsiDirectory) {
            PsiDirectory dir = (PsiDirectory)target;
            PsiFile file = dir.findFile("__init__.py");
            if (file != null) {
                return file;
            }
            return null;
        }
        return target;
    }

    @Nullable
    public static PsiElement turnDirIntoPackageElement(@NotNull PsiDirectory target, @Nullable PsiElement anchor) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/psi/PyUtil", "turnDirIntoPackageElement"));
        }
        if (PyUtil.isPackage(target, anchor)) {
            PsiFile file = target.findFile("__init__.py");
            return file != null ? file : target;
        }
        return null;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static PsiElement turnInitIntoDir(@Nullable PsiElement target) {
        if (target instanceof PyFile && PyUtil.isPackage((PsiFile)target)) {
            return ((PsiFile)target).getContainingDirectory();
        }
        return target;
    }

    public static boolean isPackage(@NotNull PsiDirectory directory, @Nullable PsiElement anchor) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/psi/PyUtil", "isPackage"));
        }
        return PyUtil.isPackage(directory, true, anchor);
    }

    public static boolean isPackage(@NotNull PsiDirectory directory, boolean checkSetupToolsPackages, @Nullable PsiElement anchor) {
        LanguageLevel level;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/psi/PyUtil", "isPackage"));
        }
        if (directory.findFile("__init__.py") != null) {
            return true;
        }
        LanguageLevel languageLevel = level = anchor != null ? LanguageLevel.forElement(anchor) : PyUtil.getLanguageLevelForVirtualFile(directory.getProject(), directory.getVirtualFile());
        if (level.isAtLeast(LanguageLevel.PYTHON33)) {
            return true;
        }
        return checkSetupToolsPackages && PyUtil.isSetuptoolsNamespacePackage(directory);
    }

    public static boolean isPackage(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/PyUtil", "isPackage"));
        }
        return "__init__.py".equals(file.getName());
    }

    @Nullable
    public static PsiElement getPackageElement(@NotNull PsiDirectory directory, @Nullable PsiElement anchor) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/psi/PyUtil", "getPackageElement"));
        }
        if (PyUtil.isPackage(directory, anchor)) {
            PsiElement init = PyUtil.turnDirIntoInit((PsiElement)directory);
            if (init != null) {
                return init;
            }
            return directory;
        }
        return null;
    }

    private static boolean isSetuptoolsNamespacePackage(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/psi/PyUtil", "isSetuptoolsNamespacePackage"));
        }
        String packagePath = PyUtil.getPackagePath(directory);
        return packagePath != null && !PySetuptoolsNamespaceIndex.find(packagePath, directory.getProject()).isEmpty();
    }

    @Nullable
    private static String getPackagePath(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/psi/PyUtil", "getPackagePath"));
        }
        QualifiedName name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)directory);
        return name != null ? name.toString() : null;
    }

    public static int getInitialUnderscores(String name) {
        if (name == null) {
            return 0;
        }
        int underscores = 0;
        if (name.startsWith("__")) {
            underscores = 2;
        } else if (name.startsWith("_")) {
            underscores = 1;
        }
        return underscores;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    @Nullable
    public static PsiElement getConcealingParent(PsiElement elt) {
        if (elt == null || elt instanceof PsiFile) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)elt);
        boolean jump_over = false;
        while (parent != null) {
            if (parent instanceof PyClass || parent instanceof Callable) {
                if (!jump_over) return parent;
                jump_over = false;
            } else if (parent instanceof PyDecoratorList) {
                jump_over = true;
            } else if (parent instanceof PsiFileSystemItem) return null;
            parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent);
        }
        return null;
    }

    public static boolean isClassPrivateName(String name) {
        return name.startsWith("__") && !name.endsWith("__");
    }

    public static boolean isSpecialName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PyUtil", "isSpecialName"));
        }
        return name.length() > 4 && name.startsWith("__") && name.endsWith("__");
    }

    public static boolean isPythonIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PyUtil", "isPythonIdentifier"));
        }
        return PyNames.isIdentifier(name);
    }

    public static LookupElement createNamedParameterLookup(String name) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(name + "=")).withIcon(PlatformIcons.PARAMETER_ICON);
        lookupElementBuilder = lookupElementBuilder.withInsertHandler((InsertHandler)OverwriteEqualsInsertHandler.INSTANCE);
        return PrioritizedLookupElement.withGrouping((LookupElement)lookupElementBuilder, (int)1);
    }

    @Nullable
    public static PyExpression peelArgument(PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        if (expr instanceof PyKeywordArgument) {
            expr = ((PyKeywordArgument)expr).getValueExpression();
        }
        return expr;
    }

    public static String getFirstParameterName(PyFunction container) {
        PyNamedParameter named;
        PyParameter[] params;
        String selfName = "self";
        if (container != null && (params = container.getParameterList().getParameters()).length > 0 && (named = params[0].getAsNamed()) != null) {
            selfName = named.getName();
        }
        return selfName;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull PsiElement foothold) {
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/PyUtil", "getSourceRoots"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
        if (module != null) {
            Collection<VirtualFile> collection = PyUtil.getSourceRoots(module);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getSourceRoots"));
            }
            return collection;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getSourceRoots"));
        }
        return list;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/psi/PyUtil", "getSourceRoots"));
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        result.addAll(Arrays.asList(manager.getSourceRoots()));
        result.addAll(Arrays.asList(manager.getContentRoots()));
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getSourceRoots"));
        }
        return linkedHashSet;
    }

    @Nullable
    public static VirtualFile findInRoots(Module module, String path) {
        if (module != null) {
            for (VirtualFile root : PyUtil.getSourceRoots(module)) {
                VirtualFile file = root.findFileByRelativePath(path);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public static List<String> getStringListFromTargetExpression(PyTargetExpression attr) {
        return PyUtil.strListValue(attr.findAssignedValue());
    }

    @Nullable
    public static List<String> strListValue(PyExpression value) {
        while (value instanceof PyParenthesizedExpression) {
            value = ((PyParenthesizedExpression)value).getContainedExpression();
        }
        if (value instanceof PySequenceExpression) {
            PyExpression[] elements = ((PySequenceExpression)value).getElements();
            ArrayList<String> result = new ArrayList<String>(elements.length);
            for (PyExpression element : elements) {
                if (!(element instanceof PyStringLiteralExpression)) {
                    return null;
                }
                result.add(((PyStringLiteralExpression)element).getStringValue());
            }
            return result;
        }
        return null;
    }

    @NotNull
    public static Map<String, PyExpression> dictValue(@NotNull PyDictLiteralExpression dict) {
        if (dict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dict", "com/jetbrains/python/psi/PyUtil", "dictValue"));
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (PyKeyValueExpression keyValue : dict.getElements()) {
            PyExpression key = keyValue.getKey();
            PyExpression value = keyValue.getValue();
            if (!(key instanceof PyStringLiteralExpression)) continue;
            result.put(((PyStringLiteralExpression)key).getStringValue(), value);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "dictValue"));
        }
        return linkedHashMap;
    }

    public static <T> boolean among(@NotNull T what, T ... variants) {
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/jetbrains/python/psi/PyUtil", "among"));
        }
        for (T s : variants) {
            if (!what.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getKeywordArgumentString(PyCallExpression expr, String keyword) {
        return PyPsiUtils.strValue(expr.getKeywordArgument(keyword));
    }

    public static boolean isExceptionClass(PyClass pyClass) {
        if (PyUtil.isBaseException(pyClass.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : pyClass.getAncestorTypes(TypeEvalContext.codeInsightFallback(pyClass.getProject()))) {
            if (type == null || !PyUtil.isBaseException(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isBaseException(String name) {
        return name != null && (name.contains("BaseException") || name.startsWith("exceptions."));
    }

    public static boolean isSuperCall(@NotNull PyCallExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/PyUtil", "isSuperCall"));
        }
        PyClass klass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
        if (klass == null) {
            return false;
        }
        PyExpression callee = node.getCallee();
        if (callee == null) {
            return false;
        }
        String name = callee.getName();
        if ("super".equals(name)) {
            PsiReference reference = callee.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement resolved = reference.resolve();
            PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)node);
            if (resolved != null && cache.isBuiltin(resolved)) {
                PyExpression[] args = node.getArguments();
                if (args.length > 0) {
                    String firstArg = args[0].getText();
                    if (firstArg.equals(klass.getName()) || firstArg.equals("self.__class__")) {
                        return true;
                    }
                    for (PyClass s : klass.getAncestorClasses()) {
                        if (!firstArg.equals(s.getName())) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static PyFile getOrCreateFile(String path, Project project) {
        PsiFile psi;
        VirtualFile vfile = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (vfile == null) {
            File file = new File(path);
            try {
                VirtualFile baseDir = project.getBaseDir();
                FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance();
                FileTemplate template = fileTemplateManager.getInternalTemplate("Python Script");
                String content = template != null ? template.getText(fileTemplateManager.getDefaultProperties(project)) : null;
                psi = PyExtractSuperclassHelper.placeFile(project, StringUtil.notNullize((String)file.getParent(), (String)(baseDir != null ? baseDir.getPath() : ".")), file.getName(), content);
            }
            catch (IOException e) {
                throw new IncorrectOperationException(String.format("Cannot create file '%s'", path));
            }
        } else {
            psi = PsiManager.getInstance((Project)project).findFile(vfile);
        }
        if (!(psi instanceof PyFile)) {
            throw new IncorrectOperationException(PyBundle.message("refactoring.move.class.or.function.error.cannot.place.elements.into.nonpython.file", new Object[0]));
        }
        PyFile pyFile = (PyFile)psi;
        if (pyFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getOrCreateFile"));
        }
        return pyFile;
    }

    public static int getElementsCount(PyExpression expression, TypeEvalContext evalContext) {
        int valuesLength = -1;
        PyType type = evalContext.getType(expression);
        if (type instanceof PyTupleType) {
            valuesLength = ((PyTupleType)type).getElementCount();
        } else if (type instanceof PyNamedTupleType) {
            valuesLength = ((PyNamedTupleType)type).getElementCount();
        } else if (expression instanceof PySequenceExpression) {
            valuesLength = ((PySequenceExpression)expression).getElements().length;
        } else if (expression instanceof PyStringLiteralExpression) {
            valuesLength = ((PyStringLiteralExpression)expression).getStringValue().length();
        } else if (expression instanceof PyNumericLiteralExpression) {
            valuesLength = 1;
        } else if (expression instanceof PyCallExpression) {
            PyExpression[] arguments;
            PyCallExpression call = (PyCallExpression)expression;
            if (call.isCalleeText("dict")) {
                valuesLength = call.getArguments().length;
            } else if (call.isCalleeText("tuple") && (arguments = call.getArguments()).length > 0 && arguments[0] instanceof PySequenceExpression) {
                valuesLength = ((PySequenceExpression)arguments[0]).getElements().length;
            }
        }
        return valuesLength;
    }

    @Nullable
    public static PsiElement findPrevAtOffset(PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement element;
        if (caretOffset < 0) {
            return null;
        }
        int lineStartOffset = 0;
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document != null) {
            int lineNumber = document.getLineNumber(caretOffset);
            lineStartOffset = document.getLineStartOffset(lineNumber);
        }
        do {
            element = psiFile.findElementAt(--caretOffset);
        } while (caretOffset >= lineStartOffset && PyUtil.instanceOf(element, toSkip));
        return PyUtil.instanceOf(element, toSkip) ? null : element;
    }

    @Nullable
    public static PsiElement findNonWhitespaceAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PyUtil.findNextAtOffset(psiFile, caretOffset, PsiWhiteSpace.class);
        if (element == null) {
            element = PyUtil.findPrevAtOffset(psiFile, caretOffset - 1, PsiWhiteSpace.class);
        }
        return element;
    }

    @Nullable
    public static PsiElement findElementAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PyUtil.findPrevAtOffset(psiFile, caretOffset, new Class[0]);
        if (element == null) {
            element = PyUtil.findNextAtOffset(psiFile, caretOffset, new Class[0]);
        }
        return element;
    }

    @Nullable
    public static PsiElement findNextAtOffset(@NotNull PsiFile psiFile, int caretOffset, Class ... toSkip) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/python/psi/PyUtil", "findNextAtOffset"));
        }
        PsiElement element = psiFile.findElementAt(caretOffset);
        if (element == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        int lineEndOffset = 0;
        if (document != null) {
            int lineNumber = document.getLineNumber(caretOffset);
            lineEndOffset = document.getLineEndOffset(lineNumber);
        }
        while (caretOffset < lineEndOffset && PyUtil.instanceOf(element, toSkip)) {
            element = psiFile.findElementAt(++caretOffset);
        }
        return PyUtil.instanceOf(element, toSkip) ? null : element;
    }

    public static <T extends PyElement> T addElementToStatementList(@NotNull T element, @NotNull PyStatementList statementList) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "addElementToStatementList"));
        }
        if (statementList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementList", "com/jetbrains/python/psi/PyUtil", "addElementToStatementList"));
        }
        PyStatement before = null;
        PyStatement after = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (PyDependenciesComparator.depends(element, statement)) {
                after = statement;
                continue;
            }
            if (!PyDependenciesComparator.depends(statement, element)) continue;
            before = statement;
        }
        PsiElement result = after != null ? statementList.addAfter((PsiElement)element, (PsiElement)after) : (before != null ? statementList.addBefore((PsiElement)element, (PsiElement)before) : PyUtil.addElementToStatementList(element, statementList, true));
        PyElement resultCasted = (PyElement)result;
        return (T)resultCasted;
    }

    public static PsiElement addElementToStatementList(@NotNull PsiElement element, @NotNull PyStatementList statementList, boolean toTheBeginning) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyUtil", "addElementToStatementList"));
        }
        if (statementList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementList", "com/jetbrains/python/psi/PyUtil", "addElementToStatementList"));
        }
        PsiElement firstChild = statementList.getFirstChild();
        if (firstChild == statementList.getLastChild() && firstChild instanceof PyPassStatement) {
            element = firstChild.replace(element);
        } else {
            PyStatement[] statements = statementList.getStatements();
            if (toTheBeginning && statements.length > 0) {
                PyExpression expression;
                PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyDocStringOwner.class);
                PyStatement anchor = statements[0];
                if (docStringOwner != null && anchor instanceof PyExpressionStatement && ((PyExpressionStatement)anchor).getExpression() == docStringOwner.getDocStringExpression()) {
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        return statementList.addAfter(element, (PsiElement)anchor);
                    }
                    anchor = next;
                }
                while (anchor instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)anchor).getExpression()) instanceof PyCallExpression) {
                    PyExpression callee = ((PyCallExpression)expression).getCallee();
                    if (!PyUtil.isSuperCall((PyCallExpression)expression) && (callee == null || !"__init__".equals(callee.getName()))) break;
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        return statementList.addAfter(element, (PsiElement)anchor);
                    }
                    anchor = next;
                }
                element = statementList.addBefore(element, (PsiElement)anchor);
            } else {
                element = statementList.add(element);
            }
        }
        return element;
    }

    @NotNull
    public static List<PyParameter> getParameters(@NotNull Callable callable, @NotNull TypeEvalContext context) {
        PyCallableType callableType;
        List<PyCallableParameter> callableTypeParameters;
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/PyUtil", "getParameters"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyUtil", "getParameters"));
        }
        PyType type = context.getType(callable);
        if (type instanceof PyUnionType) {
            type = ((PyUnionType)type).excludeNull(context);
        }
        if (type instanceof PyCallableType && (callableTypeParameters = (callableType = (PyCallableType)type).getParameters(context)) != null) {
            boolean allParametersDefined = true;
            ArrayList<PyParameter> parameters = new ArrayList<PyParameter>();
            for (PyCallableParameter callableParameter : callableTypeParameters) {
                PyParameter parameter = callableParameter.getParameter();
                if (parameter == null) {
                    allParametersDefined = false;
                    break;
                }
                parameters.add(parameter);
            }
            if (allParametersDefined) {
                ArrayList<PyParameter> arrayList = parameters;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getParameters"));
                }
                return arrayList;
            }
        }
        List<PyParameter> list = Arrays.asList(callable.getParameterList().getParameters());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "getParameters"));
        }
        return list;
    }

    public static boolean isSignatureCompatibleTo(@NotNull Callable callable, @NotNull Callable otherCallable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/PyUtil", "isSignatureCompatibleTo"));
        }
        if (otherCallable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherCallable", "com/jetbrains/python/psi/PyUtil", "isSignatureCompatibleTo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyUtil", "isSignatureCompatibleTo"));
        }
        List<PyParameter> parameters = PyUtil.getParameters(callable, context);
        List<PyParameter> otherParameters = PyUtil.getParameters(otherCallable, context);
        int optionalCount = PyUtil.optionalParametersCount(parameters);
        int otherOptionalCount = PyUtil.optionalParametersCount(otherParameters);
        int requiredCount = PyUtil.requiredParametersCount(callable, parameters);
        int otherRequiredCount = PyUtil.requiredParametersCount(otherCallable, otherParameters);
        if ((PyUtil.hasPositionalContainer(otherParameters) || PyUtil.hasKeywordContainer(otherParameters)) && otherParameters.size() == PyUtil.specialParametersCount(otherCallable, otherParameters)) {
            return true;
        }
        if (PyUtil.hasPositionalContainer(parameters) || PyUtil.hasKeywordContainer(parameters)) {
            return requiredCount <= otherRequiredCount;
        }
        return requiredCount <= otherRequiredCount && parameters.size() >= otherParameters.size() && optionalCount >= otherOptionalCount;
    }

    private static int optionalParametersCount(@NotNull List<PyParameter> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/PyUtil", "optionalParametersCount"));
        }
        int n = 0;
        for (PyParameter parameter : parameters) {
            if (!parameter.hasDefaultValue()) continue;
            ++n;
        }
        return n;
    }

    private static int requiredParametersCount(@NotNull Callable callable, @NotNull List<PyParameter> parameters) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/PyUtil", "requiredParametersCount"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/PyUtil", "requiredParametersCount"));
        }
        return parameters.size() - PyUtil.optionalParametersCount(parameters) - PyUtil.specialParametersCount(callable, parameters);
    }

    private static int specialParametersCount(@NotNull Callable callable, @NotNull List<PyParameter> parameters) {
        PyParameter first;
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/PyUtil", "specialParametersCount"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/PyUtil", "specialParametersCount"));
        }
        int n = 0;
        if (PyUtil.hasPositionalContainer(parameters)) {
            ++n;
        }
        if (PyUtil.hasKeywordContainer(parameters)) {
            ++n;
        }
        if (callable.asMethod() != null) {
            ++n;
        } else if (parameters.size() > 0 && "self".equals((first = parameters.get(0)).getName())) {
            ++n;
        }
        return n;
    }

    private static boolean hasPositionalContainer(@NotNull List<PyParameter> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/PyUtil", "hasPositionalContainer"));
        }
        for (PyParameter parameter : parameters) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasKeywordContainer(@NotNull List<PyParameter> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/psi/PyUtil", "hasKeywordContainer"));
        }
        for (PyParameter parameter : parameters) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInit(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/psi/PyUtil", "isInit"));
        }
        return "__init__".equals(function.getName());
    }

    @NotNull
    public static Collection<PyMemberInfo<PyElement>> filterOutObject(@NotNull Collection<PyMemberInfo<PyElement>> pyMemberInfos) {
        if (pyMemberInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyMemberInfos", "com/jetbrains/python/psi/PyUtil", "filterOutObject"));
        }
        Collection collection = Collections2.filter(pyMemberInfos, (Predicate)new ObjectPredicate(false));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyUtil", "filterOutObject"));
        }
        return collection;
    }

    public static boolean isStarImportableFrom(@NotNull String name, @NotNull PyFile file) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PyUtil", "isStarImportableFrom"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/PyUtil", "isStarImportableFrom"));
        }
        List<String> dunderAll = file.getDunderAll();
        return dunderAll != null ? dunderAll.contains(name) : !name.startsWith("_");
    }

    public static boolean isSymbolInPackage(@NotNull PyQualifiedNameOwner symbol, @NotNull String expectedPackage, @NotNull String expectedName) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/python/psi/PyUtil", "isSymbolInPackage"));
        }
        if (expectedPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedPackage", "com/jetbrains/python/psi/PyUtil", "isSymbolInPackage"));
        }
        if (expectedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/jetbrains/python/psi/PyUtil", "isSymbolInPackage"));
        }
        String qualifiedNameString = symbol.getQualifiedName();
        if (qualifiedNameString == null) {
            return false;
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)qualifiedNameString);
        String aPackage = qualifiedName.getFirstComponent();
        if (!expectedPackage.equals(aPackage)) {
            return false;
        }
        String symboldName = qualifiedName.getLastComponent();
        return expectedName.equals(symboldName);
    }

    public static boolean isObjectClass(@NotNull PyClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/psi/PyUtil", "isObjectClass"));
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(cls);
        return cls == builtinCache.getClass("object") || cls == builtinCache.getClass("___Classobj");
    }

    public static boolean isObjectType(@NotNull PyType type, @NotNull PsiElement anchor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/PyUtil", "isObjectType"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/PyUtil", "isObjectType"));
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(anchor);
        return type == builtinCache.getObjectType() || type == builtinCache.getOldstyleClassobjType();
    }

    public static class ObjectPredicate
    extends NotNullPredicate<PyMemberInfo<PyElement>> {
        private final boolean myAllowObjects;

        public ObjectPredicate(boolean allowObjects) {
            this.myAllowObjects = allowObjects;
        }

        @Override
        public boolean applyNotNull(@NotNull PyMemberInfo<PyElement> input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/PyUtil$ObjectPredicate", "applyNotNull"));
            }
            return this.myAllowObjects == ObjectPredicate.isObject(input);
        }

        private static boolean isObject(@NotNull PyMemberInfo<PyElement> classMemberInfo) {
            if (classMemberInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMemberInfo", "com/jetbrains/python/psi/PyUtil$ObjectPredicate", "isObject"));
            }
            PyElement element = (PyElement)classMemberInfo.getMember();
            return element instanceof PyClass && "object".equals(element.getName());
        }
    }

    public static class MethodFlags {
        private boolean myIsStaticMethod;
        private boolean myIsMetaclassMethod;
        private boolean myIsSpecialMetaclassMethod;
        private boolean myIsClassMethod;

        public boolean isMetaclassMethod() {
            return this.myIsMetaclassMethod;
        }

        public boolean isSpecialMetaclassMethod() {
            return this.myIsSpecialMetaclassMethod;
        }

        public boolean isStaticMethod() {
            return this.myIsStaticMethod;
        }

        public boolean isClassMethod() {
            return this.myIsClassMethod;
        }

        private MethodFlags(boolean isClassMethod, boolean isStaticMethod, boolean isMetaclassMethod, boolean isSpecialMetaclassMethod) {
            this.myIsClassMethod = isClassMethod;
            this.myIsStaticMethod = isStaticMethod;
            this.myIsMetaclassMethod = isMetaclassMethod;
            this.myIsSpecialMetaclassMethod = isSpecialMetaclassMethod;
        }

        @Nullable
        public static MethodFlags of(@NotNull PyFunction node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/PyUtil$MethodFlags", "of"));
            }
            PyClass cls = node.getContainingClass();
            if (cls != null) {
                PyFunction.Modifier modifier = node.getModifier();
                boolean isMetaclassMethod = false;
                PyClass type_cls = PyBuiltinCache.getInstance(node).getClass("type");
                for (PyClass ancestor_cls : cls.getAncestorClasses()) {
                    if (ancestor_cls != type_cls) continue;
                    isMetaclassMethod = true;
                    break;
                }
                String method_name = node.getName();
                boolean isSpecialMetaclassMethod = isMetaclassMethod && method_name != null && PyUtil.among(method_name, "__init__", "__call__");
                return new MethodFlags(modifier == PyFunction.Modifier.CLASSMETHOD, modifier == PyFunction.Modifier.STATICMETHOD, isMetaclassMethod, isSpecialMetaclassMethod);
            }
            return null;
        }

        public boolean isInstanceMethod() {
            return !this.myIsClassMethod && !this.myIsStaticMethod;
        }
    }

    public static class KnownDecoratorProviderHolder {
        public static PyKnownDecoratorProvider[] KNOWN_DECORATOR_PROVIDERS = (PyKnownDecoratorProvider[])Extensions.getExtensions(PyKnownDecoratorProvider.EP_NAME);

        private KnownDecoratorProviderHolder() {
        }
    }
}

