/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.RootFileReferenceSet;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralFileReferenceSet
extends RootFileReferenceSet {
    public static final Pattern DELIMITERS = Pattern.compile("\\\\|/");
    private final PyStringLiteralExpression myStringLiteralExpression;

    public PyStringLiteralFileReferenceSet(@NotNull PyStringLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet", "<init>"));
        }
        this(element, SystemInfo.isFileSystemCaseSensitive);
    }

    public PyStringLiteralFileReferenceSet(@NotNull PyStringLiteralExpression element, boolean caseSensitive) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet", "<init>"));
        }
        this(element.getStringValue(), element, element.getStringValueTextRange().getStartOffset(), (PsiReferenceProvider)null, caseSensitive, true, new FileType[0]);
    }

    public PyStringLiteralFileReferenceSet(@NotNull String str, @NotNull PyStringLiteralExpression element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, @Nullable FileType[] suitableFileTypes) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes);
        this.myStringLiteralExpression = element;
        this.reparse();
    }

    @Override
    protected void reparse() {
        if (this.myStringLiteralExpression != null) {
            List<FileReference> references = this.getFileReferences(this.myStringLiteralExpression);
            this.myReferences = references.toArray(new FileReference[references.size()]);
        }
    }

    @NotNull
    private List<FileReference> getFileReferences(@NotNull PyStringLiteralExpression expression) {
        TextRange range;
        String s;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet", "getFileReferences"));
        }
        String value = expression.getStringValue();
        Matcher matcher = DELIMITERS.matcher(value);
        int start = 0;
        int index = 0;
        ArrayList<FileReference> results = new ArrayList<FileReference>();
        while (matcher.find()) {
            s = value.substring(start, matcher.start());
            if (!s.isEmpty()) {
                range = TextRange.create((int)expression.valueOffsetToTextOffset(start), (int)expression.valueOffsetToTextOffset(matcher.start()));
                results.add(this.createFileReference(range, index++, s));
            }
            start = matcher.end();
        }
        s = value.substring(start);
        if (!s.isEmpty()) {
            range = TextRange.create((int)expression.valueOffsetToTextOffset(start), (int)expression.valueOffsetToTextOffset(value.length()));
            results.add(this.createFileReference(range, index, s));
        }
        ArrayList<FileReference> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet", "getFileReferences"));
        }
        return arrayList;
    }
}

