/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.Iterators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyKnownDecoratorUtil {
    private static final Set<KnownDecorator> BUILTIN_DECORATORS = EnumSet.of(KnownDecorator.PROPERTY, KnownDecorator.CLASSMETHOD, KnownDecorator.STATICMETHOD);
    private static final Set<KnownDecorator> ABSTRACT_DECORATORS = EnumSet.of(KnownDecorator.ABC_ABSTRACTMETHOD, KnownDecorator.ABC_ABSTRACTPROPERTY, KnownDecorator.ABC_ABSTRACTSTATICMETHOD, KnownDecorator.ABC_ABSTRACTCLASSMETHOD);
    private static final Map<String, KnownDecorator> ourByShortName = ContainerUtil.newMapFromValues((Iterator)Iterators.forArray((Object[])KnownDecorator.values()), (Convertor)new Convertor<KnownDecorator, String>(){

        public String convert(KnownDecorator o) {
            return o.getShortName();
        }
    });

    private PyKnownDecoratorUtil() {
    }

    @NotNull
    public static List<KnownDecorator> getKnownDecorators(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "getKnownDecorators"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "getKnownDecorators"));
        }
        PyDecoratorList decoratorList = element.getDecoratorList();
        if (decoratorList == null) {
            List<KnownDecorator> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "getKnownDecorators"));
            }
            return list;
        }
        ArrayList<KnownDecorator> result = new ArrayList<KnownDecorator>();
        boolean allowResolve = context.maySwitchToAST((PsiElement)element);
        for (PyDecorator decorator : decoratorList.getDecorators()) {
            KnownDecorator knownDecorator;
            QualifiedName qualifiedName = decorator.getQualifiedName();
            if (qualifiedName == null || (knownDecorator = ourByShortName.get(qualifiedName.getLastComponent())) == null) continue;
            if (allowResolve) {
                QualifiedName resolvedName;
                PyQualifiedNameOwner resolved = PyUtil.as(PyKnownDecoratorUtil.resolveDecorator(decorator), PyQualifiedNameOwner.class);
                if (resolved instanceof PyFunction && "__init__".equals(resolved.getName())) {
                    resolved = ((PyFunction)resolved).getContainingClass();
                }
                if (resolved == null || resolved.getQualifiedName() == null || !(resolvedName = QualifiedName.fromDottedString((String)resolved.getQualifiedName())).equals((Object)knownDecorator.getQualifiedName())) continue;
                result.add(knownDecorator);
                continue;
            }
            result.add(knownDecorator);
        }
        ArrayList<KnownDecorator> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "getKnownDecorators"));
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement resolveDecorator(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "resolveDecorator"));
        }
        PyExpression callee = decorator.getCallee();
        if (callee == null) {
            return null;
        }
        PsiReference reference = callee.getReference();
        if (reference == null) {
            return null;
        }
        return reference.resolve();
    }

    public static boolean hasUnknownDecorator(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "hasUnknownDecorator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "hasUnknownDecorator"));
        }
        return !PyKnownDecoratorUtil.allDecoratorsAreKnown(element, PyKnownDecoratorUtil.getKnownDecorators(element, context));
    }

    public static boolean hasNonBuiltinDecorator(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "hasNonBuiltinDecorator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "hasNonBuiltinDecorator"));
        }
        List<KnownDecorator> knownDecorators = PyKnownDecoratorUtil.getKnownDecorators(element, context);
        if (!PyKnownDecoratorUtil.allDecoratorsAreKnown(element, knownDecorators)) {
            return true;
        }
        knownDecorators.removeAll(BUILTIN_DECORATORS);
        return !knownDecorators.isEmpty();
    }

    public static boolean hasAbstractDecorator(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "hasAbstractDecorator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "hasAbstractDecorator"));
        }
        List<KnownDecorator> knownDecorators = PyKnownDecoratorUtil.getKnownDecorators(element, context);
        if (knownDecorators.isEmpty()) {
            return false;
        }
        knownDecorators.retainAll(ABSTRACT_DECORATORS);
        return !knownDecorators.isEmpty();
    }

    private static boolean allDecoratorsAreKnown(@NotNull PyDecoratable element, @NotNull List<KnownDecorator> decorators) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "allDecoratorsAreKnown"));
        }
        if (decorators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorators", "com/jetbrains/python/psi/PyKnownDecoratorUtil", "allDecoratorsAreKnown"));
        }
        PyDecoratorList decoratorList = element.getDecoratorList();
        return decoratorList == null ? decorators.isEmpty() : decoratorList.getDecorators().length == decorators.size();
    }

    public static enum KnownDecorator {
        STATICMETHOD("staticmethod"),
        CLASSMETHOD("classmethod"),
        PROPERTY("property"),
        CONTEXTLIB_CONTEXTMANAGER("contextlib.contextmanager"),
        FUNCTOOLS_LRU_CACHE("functools.lru_cache"),
        FUNCTOOLS_WRAPS("functools.wraps"),
        FUNCTOOLS_TOTAL_ORDERING("functools.total_ordering"),
        FUNCTOOLS_SINGLEDISPATCH("functools.singledispatch"),
        ABC_ABSTRACTMETHOD("abc.abstractmethod"),
        ABC_ABSTRACTCLASSMETHOD("abc.abstractclassmethod"),
        ABC_ABSTRACTSTATICMETHOD("abc.abstractstaticmethod"),
        ABC_ABSTRACTPROPERTY("abc.abstractproperty"),
        ASYNCIO_COROUTINE("asyncio.tasks.coroutine"),
        UNITTEST_SKIP("unittest.case.skip"),
        UNITTEST_SKIP_IF("unittest.case.skipIf"),
        UNITTEST_SKIP_UNLESS("unittest.case.skipUnless"),
        UNITTEST_EXPECTED_FAILURE("unittest.case.expectedFailure"),
        UNITTEST_MOCK_PATCH("unittest.mock.patch"),
        REPRLIB_RECURSIVE_REPR("reprlib.recursive_repr");

        private final QualifiedName myQualifiedName;

        private KnownDecorator(String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/psi/PyKnownDecoratorUtil$KnownDecorator", "<init>"));
            }
            this.myQualifiedName = QualifiedName.fromDottedString((String)qualifiedName);
        }

        @NotNull
        public QualifiedName getQualifiedName() {
            QualifiedName qualifiedName = this.myQualifiedName;
            if (qualifiedName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyKnownDecoratorUtil$KnownDecorator", "getQualifiedName"));
            }
            return qualifiedName;
        }

        @NotNull
        public String getShortName() {
            String string = this.myQualifiedName.getLastComponent();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyKnownDecoratorUtil$KnownDecorator", "getShortName"));
            }
            return string;
        }
    }
}

