/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PythonFileType;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyElementType
extends IElementType {
    protected Class<? extends PsiElement> myPsiElementClass;
    private static final Class[] PARAMETER_TYPES = new Class[]{ASTNode.class};
    private Constructor<? extends PsiElement> myConstructor;
    private String mySpecialMethodName;

    public PyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/jetbrains/python/psi/PyElementType", "<init>"));
        }
        super(debugName, PythonFileType.INSTANCE.getLanguage());
    }

    public PyElementType(@NotNull @NonNls String debugName, @NotNull Class<? extends PsiElement> psiElementClass) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/jetbrains/python/psi/PyElementType", "<init>"));
        }
        if (psiElementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementClass", "com/jetbrains/python/psi/PyElementType", "<init>"));
        }
        this(debugName);
        this.myPsiElementClass = psiElementClass;
    }

    public PyElementType(@NotNull @NonNls String debugName, @NotNull @NonNls String specialMethodName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/jetbrains/python/psi/PyElementType", "<init>"));
        }
        if (specialMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specialMethodName", "com/jetbrains/python/psi/PyElementType", "<init>"));
        }
        this(debugName);
        this.mySpecialMethodName = specialMethodName;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        PsiElement psiElement;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/PyElementType", "createElement"));
        }
        if (this.myPsiElementClass == null) {
            throw new IllegalStateException("Cannot create an element for " + node.getElementType() + " without element class");
        }
        try {
            if (this.myConstructor == null) {
                this.myConstructor = this.myPsiElementClass.getConstructor(PARAMETER_TYPES);
            }
            psiElement = this.myConstructor.newInstance(node);
        }
        catch (Exception e) {
            throw new IllegalStateException("No necessary constructor for " + node.getElementType(), e);
        }
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PyElementType", "createElement"));
        }
        return psiElement;
    }

    @Nullable
    public String getSpecialMethodName() {
        return this.mySpecialMethodName;
    }

    public String toString() {
        return "Py:" + super.toString();
    }
}

