/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiQuery {
    private static final PsiQuery EMPTY = new PsiQuery(new PsiElement[0]);
    @NotNull
    private final PsiElement[] myPsiElements;

    public PsiQuery(PsiElement ... psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/psi/PsiQuery", "<init>"));
        }
        this.myPsiElements = (PsiElement[])psiElement.clone();
    }

    public PsiQuery(@NotNull List<? extends PsiElement> psiElements) {
        if (psiElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElements", "com/jetbrains/python/psi/PsiQuery", "<init>"));
        }
        this(psiElements.toArray(new PsiElement[psiElements.size()]));
    }

    @NotNull
    public PsiQuery childrenNamed(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "childrenNamed"));
        }
        PsiQuery psiQuery = this.childrenNamed(PsiNamedElement.class, name);
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "childrenNamed"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery childrenNamed(@NotNull Class<? extends PsiNamedElement> clazz, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "childrenNamed"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "childrenNamed"));
        }
        ArrayList<PsiNamedElement> result = new ArrayList<PsiNamedElement>();
        for (PsiElement element : this.myPsiElements) {
            for (PsiNamedElement child : PsiTreeUtil.findChildrenOfType((PsiElement)element, clazz)) {
                if (!name.equals(child.getName())) continue;
                result.add(child);
            }
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "childrenNamed"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery childrenCall(@NotNull FQNamesProvider name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "childrenCall"));
        }
        ArrayList<PyCallExpression> result = new ArrayList<PyCallExpression>();
        for (PsiElement element : this.myPsiElements) {
            for (PyCallExpression call : PsiTreeUtil.findChildrenOfType((PsiElement)element, PyCallExpression.class)) {
                if (!call.isCallee(name)) continue;
                result.add(call);
            }
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "childrenCall"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery children(@NotNull Class<? extends PsiElement> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "children"));
        }
        ArrayList result = new ArrayList();
        for (PsiElement element : this.myPsiElements) {
            result.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)element, clazz));
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "children"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery parents(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        throw new RuntimeException("Not implemented");
    }

    @NotNull
    public PsiQuery parents(@NotNull Class<? extends PsiElement> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : this.myPsiElements) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, clazz);
            if (parent == null) continue;
            result.add(parent);
        }
        PsiQuery psiQuery = new PsiQuery(result);
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery parents(@NotNull Condition<Class<? extends PsiElement>> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        throw new RuntimeException("Not impl");
    }

    @NotNull
    public PsiQuery parents(@NotNull Class<? extends PsiElement> clazz, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        throw new RuntimeException("Not impl");
    }

    @NotNull
    public PsiQuery parents(@NotNull FQNamesProvider name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "parents"));
        }
        throw new RuntimeException("Not impl");
    }

    @NotNull
    public PsiQuery siblings(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        PsiQuery psiQuery = this.siblings(PsiNamedElement.class, name);
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        return psiQuery;
    }

    @NotNull
    public <T extends PsiElement> PsiTypedQuery<T> siblings(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : this.myPsiElements) {
            PsiElement parent = element.getParent();
            for (PsiElement sibling : PsiTreeUtil.findChildrenOfType((PsiElement)parent, clazz)) {
                if (sibling.equals(element)) continue;
                result.add(sibling);
            }
        }
        PsiTypedQuery psiTypedQuery = new PsiTypedQuery(clazz, result);
        if (psiTypedQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        return psiTypedQuery;
    }

    @NotNull
    public PsiQuery siblings(@NotNull Class<? extends PsiNamedElement> clazz, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        ArrayList<PsiNamedElement> result = new ArrayList<PsiNamedElement>();
        for (PsiElement element : this.myPsiElements) {
            PsiElement parent = element.getParent();
            for (PsiNamedElement namedSibling : PsiTreeUtil.findChildrenOfType((PsiElement)parent, clazz)) {
                if (namedSibling.equals(element) || !name.equals(namedSibling.getName())) continue;
                result.add(namedSibling);
            }
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery siblings(@NotNull FQNamesProvider name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        ArrayList<PyCallExpression> result = new ArrayList<PyCallExpression>();
        for (PsiElement element : this.myPsiElements) {
            PsiElement parent = element.getParent();
            for (PyCallExpression callSibling : PsiTreeUtil.findChildrenOfType((PsiElement)parent, PyCallExpression.class)) {
                if (callSibling.equals(element) || !callSibling.isCallee(name)) continue;
                result.add(callSibling);
            }
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "siblings"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery first() {
        PsiQuery psiQuery = this.myPsiElements.length > 0 ? new PsiQuery(this.myPsiElements[0]) : EMPTY;
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "first"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery last() {
        PsiQuery psiQuery = this.myPsiElements.length > 0 ? new PsiQuery(this.myPsiElements[this.myPsiElements.length - 1]) : EMPTY;
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "last"));
        }
        return psiQuery;
    }

    @Nullable
    public <T extends PsiElement> T getFirstElement(@NotNull Class<T> expectedClass) {
        if (expectedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedClass", "com/jetbrains/python/psi/PsiQuery", "getFirstElement"));
        }
        List<T> elements = this.getChildrenElements(expectedClass);
        if (!elements.isEmpty()) {
            return (T)((PsiElement)elements.get(0));
        }
        return null;
    }

    @Nullable
    public <T extends PsiElement> T getLastElement(@NotNull Class<T> expectedClass) {
        if (expectedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedClass", "com/jetbrains/python/psi/PsiQuery", "getLastElement"));
        }
        List<T> elements = this.getChildrenElements(expectedClass);
        if (!elements.isEmpty()) {
            return (T)((PsiElement)elements.get(elements.size() - 1));
        }
        return null;
    }

    @NotNull
    public <T extends PsiElement> List<T> getChildrenElements(@NotNull Class<T> expectedClass) {
        if (expectedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedClass", "com/jetbrains/python/psi/PsiQuery", "getChildrenElements"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : this.myPsiElements) {
            PsiElement typedElement = (PsiElement)PyUtil.as(element, expectedClass);
            if (typedElement != null) {
                result.add(typedElement);
                continue;
            }
            PsiElement[] children = PsiTreeUtil.getChildrenOfType((PsiElement)element, expectedClass);
            if (children == null) continue;
            Collections.addAll(result, children);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "getChildrenElements"));
        }
        return arrayList;
    }

    @NotNull
    public PsiQuery filter(@NotNull FQNamesProvider name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>(Arrays.asList(this.myPsiElements));
        for (PsiElement element : this.myPsiElements) {
            PyCallExpression callExpression = PyUtil.as(element, PyCallExpression.class);
            if (callExpression != null && callExpression.isCallee(name)) continue;
            result.remove(element);
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery filter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        PsiQuery psiQuery = this.filter(PsiNamedElement.class, name);
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        return psiQuery;
    }

    @NotNull
    public <T extends PsiElement> PsiTypedQuery<T> filter(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>(Arrays.asList(this.myPsiElements));
        for (PsiElement element : this.myPsiElements) {
            if (clazz.isInstance(element)) continue;
            result.remove(element);
        }
        ArrayList<PsiElement> toAdd = new ArrayList<PsiElement>(result);
        PsiTypedQuery psiTypedQuery = new PsiTypedQuery(clazz, toAdd);
        if (psiTypedQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        return psiTypedQuery;
    }

    @NotNull
    public PsiQuery filter(@NotNull Class<? extends PsiNamedElement> clazz, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>(Arrays.asList(this.myPsiElements));
        for (PsiElement element : this.myPsiElements) {
            PsiNamedElement namedElement = PyUtil.as(element, clazz);
            if (namedElement != null && name.equals(namedElement.getName())) continue;
            result.remove(element);
        }
        PsiQuery psiQuery = new PsiQuery(result.toArray(new PsiElement[result.size()]));
        if (psiQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery", "filter"));
        }
        return psiQuery;
    }

    public boolean isEmpty() {
        return this.myPsiElements.length == 0;
    }

    public static class PsiTypedQuery<T extends PsiElement>
    extends PsiQuery {
        @NotNull
        private final Class<T> myClass;
        @NotNull
        private final List<T> myElements;

        private PsiTypedQuery(@NotNull Class<T> clazz, @NotNull List<T> elements) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/psi/PsiQuery$PsiTypedQuery", "<init>"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/psi/PsiQuery$PsiTypedQuery", "<init>"));
            }
            super(elements);
            this.myClass = clazz;
            this.myElements = elements;
        }

        @Nullable
        public T getFirstElement() {
            return this.getFirstElement(this.myClass);
        }

        @Nullable
        public T getLastElement() {
            return this.getLastElement(this.myClass);
        }

        @NotNull
        public List<T> getElements() {
            List<T> list = Collections.unmodifiableList(this.myElements);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/PsiQuery$PsiTypedQuery", "getElements"));
            }
            return list;
        }
    }
}

