/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.PyFile;
import org.jetbrains.annotations.NotNull;

public enum LanguageLevel {
    PYTHON24(24, false, true, false, false),
    PYTHON25(25, false, true, false, false),
    PYTHON26(26, true, true, false, false),
    PYTHON27(27, true, true, true, false),
    PYTHON30(30, true, false, false, true),
    PYTHON31(31, true, false, true, true),
    PYTHON32(32, true, false, true, true),
    PYTHON33(33, true, false, true, true),
    PYTHON34(34, true, false, true, true);

    private static LanguageLevel DEFAULT2;
    private static LanguageLevel DEFAULT3;
    public static LanguageLevel FORCE_LANGUAGE_LEVEL;
    private final int myVersion;
    private final boolean myHasWithStatement;
    private final boolean myHasPrintStatement;
    private final boolean mySupportsSetLiterals;
    private final boolean myIsPy3K;
    public static final Key<LanguageLevel> KEY;

    public static LanguageLevel getDefault() {
        return DEFAULT2;
    }

    private LanguageLevel(int version, boolean hasWithStatement, boolean hasPrintStatement, boolean supportsSetLiterals, boolean isPy3K) {
        this.myVersion = version;
        this.myHasWithStatement = hasWithStatement;
        this.myHasPrintStatement = hasPrintStatement;
        this.mySupportsSetLiterals = supportsSetLiterals;
        this.myIsPy3K = isPy3K;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public boolean hasWithStatement() {
        return this.myHasWithStatement;
    }

    public boolean hasPrintStatement() {
        return this.myHasPrintStatement;
    }

    public boolean supportsSetLiterals() {
        return this.mySupportsSetLiterals;
    }

    public boolean isPy3K() {
        return this.myIsPy3K;
    }

    public boolean isOlderThan(@NotNull LanguageLevel other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/python/psi/LanguageLevel", "isOlderThan"));
        }
        return this.myVersion < other.myVersion;
    }

    public boolean isAtLeast(@NotNull LanguageLevel other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/python/psi/LanguageLevel", "isAtLeast"));
        }
        return this.myVersion >= other.myVersion;
    }

    public static LanguageLevel fromPythonVersion(@NotNull String pythonVersion) {
        if (pythonVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pythonVersion", "com/jetbrains/python/psi/LanguageLevel", "fromPythonVersion"));
        }
        if (pythonVersion.startsWith("2")) {
            if (pythonVersion.startsWith("2.4")) {
                return PYTHON24;
            }
            if (pythonVersion.startsWith("2.5")) {
                return PYTHON25;
            }
            if (pythonVersion.startsWith("2.6")) {
                return PYTHON26;
            }
            if (pythonVersion.startsWith("2.7")) {
                return PYTHON27;
            }
            return DEFAULT2;
        }
        if (pythonVersion.startsWith("3")) {
            if (pythonVersion.startsWith("3.0")) {
                return PYTHON30;
            }
            if (pythonVersion.startsWith("3.1")) {
                return PYTHON31;
            }
            if (pythonVersion.startsWith("3.2")) {
                return PYTHON32;
            }
            if (pythonVersion.startsWith("3.3")) {
                return PYTHON33;
            }
            if (pythonVersion.startsWith("3.4")) {
                return PYTHON34;
            }
            return DEFAULT3;
        }
        return LanguageLevel.getDefault();
    }

    @NotNull
    public static LanguageLevel forElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/LanguageLevel", "forElement"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PyFile) {
            LanguageLevel languageLevel = ((PyFile)containingFile).getLanguageLevel();
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/LanguageLevel", "forElement"));
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/LanguageLevel", "forElement"));
        }
        return languageLevel;
    }

    public String toString() {
        return this.myVersion / 10 + "." + this.myVersion % 10;
    }

    static {
        DEFAULT2 = PYTHON27;
        DEFAULT3 = PYTHON33;
        FORCE_LANGUAGE_LEVEL = null;
        KEY = new Key("python.language.level");
    }
}

