/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.projectView.PyFileNode;
import com.jetbrains.python.projectView.PyRemoteLibrariesNode;
import com.jetbrains.python.projectView.PySkeletonsNode;
import com.jetbrains.python.projectView.PyUserSkeletonsNode;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTreeStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/python/projectView/PyTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/python/projectView/PyTreeStructureProvider", "modify"));
        }
        Project project = parent.getProject();
        Sdk sdk = PyTreeStructureProvider.getPythonSdk(parent);
        if (sdk != null && project != null) {
            PyRemoteLibrariesNode remoteLibrariesNode;
            PyUserSkeletonsNode userSkeletonsNode;
            Collection<AbstractTreeNode> newChildren = PyTreeStructureProvider.hideSkeletons(children);
            PySkeletonsNode skeletonsNode = PySkeletonsNode.create(project, sdk, settings);
            if (skeletonsNode != null) {
                newChildren.add((AbstractTreeNode)skeletonsNode);
            }
            if ((userSkeletonsNode = PyUserSkeletonsNode.create(project, settings)) != null) {
                newChildren.add((AbstractTreeNode)userSkeletonsNode);
            }
            if ((remoteLibrariesNode = PyRemoteLibrariesNode.create(project, sdk, settings)) != null) {
                newChildren.add((AbstractTreeNode)remoteLibrariesNode);
            }
            Collection<AbstractTreeNode> collection = newChildren;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/projectView/PyTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (settings.isShowMembers()) {
            ArrayList<AbstractTreeNode> newChildren = new ArrayList<AbstractTreeNode>();
            for (AbstractTreeNode child : children) {
                if (child instanceof PsiFileNode && ((PsiFileNode)child).getValue() instanceof PyFile) {
                    newChildren.add((AbstractTreeNode)new PyFileNode(project, (PsiFile)((PsiFileNode)child).getValue(), settings));
                    continue;
                }
                newChildren.add(child);
            }
            ArrayList<AbstractTreeNode> arrayList = newChildren;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/projectView/PyTreeStructureProvider", "modify"));
            }
            return arrayList;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/projectView/PyTreeStructureProvider", "modify"));
        }
        return collection;
    }

    @Nullable
    private static Sdk getPythonSdk(@NotNull AbstractTreeNode node) {
        Sdk sdk;
        SdkTypeId type;
        LibraryOrSdkOrderEntry entry;
        NamedLibraryElement value;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/projectView/PyTreeStructureProvider", "getPythonSdk"));
        }
        if (node instanceof NamedLibraryElementNode && (value = (NamedLibraryElement)((NamedLibraryElementNode)node).getValue()) != null && (entry = value.getOrderEntry()) instanceof JdkOrderEntry && (type = (sdk = ((JdkOrderEntry)entry).getJdk()).getSdkType()) instanceof PythonSdkType) {
            return sdk;
        }
        return null;
    }

    @NotNull
    private static Collection<AbstractTreeNode> hideSkeletons(@NotNull Collection<AbstractTreeNode> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/python/projectView/PyTreeStructureProvider", "hideSkeletons"));
        }
        ArrayList<AbstractTreeNode> newChildren = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            if (child instanceof PsiDirectoryNode) {
                VirtualFile grandParent;
                VirtualFile dirParent;
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                if (directory.getVirtualFile().equals(PyUserSkeletonsUtil.getUserSkeletonsDirectory())) continue;
                VirtualFile dir = directory.getVirtualFile();
                if (dir.getFileSystem() instanceof JarFileSystem) {
                    dir = ((JarFileSystem)directory.getVirtualFile().getFileSystem()).getLocalVirtualFileFor(directory.getVirtualFile());
                }
                if (dir == null || (dirParent = dir.getParent()) != null && dirParent.getName().equals("python_stubs") || dirParent != null && dirParent.getName().equals("remote_sources") || dirParent != null && (grandParent = dirParent.getParent()) != null && grandParent.getName().equals("remote_sources")) continue;
            }
            newChildren.add(child);
        }
        ArrayList<AbstractTreeNode> arrayList = newChildren;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/projectView/PyTreeStructureProvider", "hideSkeletons"));
        }
        return arrayList;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    public PsiElement getTopLevelElement(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof PyFile)) {
            return null;
        }
        ArrayList<PyDocStringOwner> parents = new ArrayList<PyDocStringOwner>();
        PyDocStringOwner container = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class);
        while (container != null && !(container instanceof PyFile)) {
            parents.add(0, container);
            container = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PyDocStringOwner.class);
        }
        for (PsiElement psiElement : parents) {
            if (!(psiElement instanceof PyFunction)) continue;
            return psiElement;
        }
        if (parents.size() > 0) {
            return (PsiElement)parents.get(parents.size() - 1);
        }
        return element.getContainingFile();
    }
}

