/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.sdk.PySdkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonsNode
extends PsiDirectoryNode {
    private PySkeletonsNode(Project project, PsiDirectory value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Override
    protected void updateImpl(PresentationData data) {
        data.setPresentableText("Binary Skeletons");
        data.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @Nullable
    public static PySkeletonsNode create(@NotNull Project project, @NotNull Sdk sdk, ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/projectView/PySkeletonsNode", "create"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/projectView/PySkeletonsNode", "create"));
        }
        VirtualFile skeletonsVirtualFile = PySdkUtil.findSkeletonsDir(sdk);
        if (skeletonsVirtualFile != null) {
            PsiDirectory skeletonsDirectory = PsiManager.getInstance((Project)project).findDirectory(skeletonsVirtualFile);
            return new PySkeletonsNode(project, skeletonsDirectory, settings);
        }
        return null;
    }
}

