/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.PySdkUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteLibrariesNode
extends PsiDirectoryNode {
    private final Sdk mySdk;
    private final PyRemoteSdkAdditionalDataBase myRemoteSdkData;

    private PyRemoteLibrariesNode(Sdk sdk, Project project, PsiDirectory value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
        this.mySdk = sdk;
        assert (this.mySdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase);
        this.myRemoteSdkData = (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData();
    }

    @Override
    protected void updateImpl(PresentationData data) {
        data.setPresentableText("Remote Libraries");
        data.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @Nullable
    public static PyRemoteLibrariesNode create(@NotNull Project project, @NotNull Sdk sdk, ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/projectView/PyRemoteLibrariesNode", "create"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/projectView/PyRemoteLibrariesNode", "create"));
        }
        VirtualFile remoteLibrary = PySdkUtil.findAnyRemoteLibrary(sdk);
        if (remoteLibrary != null && remoteLibrary.getFileType() instanceof ArchiveFileType) {
            remoteLibrary = JarFileSystem.getInstance().getLocalVirtualFileFor(remoteLibrary);
        }
        if (remoteLibrary != null) {
            VirtualFile remoteLibraries = remoteLibrary.getParent();
            PsiDirectory remoteLibrariesDirectory = PsiManager.getInstance((Project)project).findDirectory(remoteLibraries);
            return new PyRemoteLibrariesNode(sdk, project, remoteLibrariesDirectory, settings);
        }
        return null;
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])((PsiDirectory)this.getValue()).getChildren())).transform((Function)new Function<PsiElement, AbstractTreeNode>(){

            public AbstractTreeNode apply(PsiElement input) {
                if (input instanceof PsiFileSystemItem) {
                    PsiDirectory dir;
                    String path = ((PsiFileSystemItem)input).getVirtualFile().getPath();
                    PsiDirectory psiDirectory = dir = input instanceof PsiDirectory ? (PsiDirectory)input : PyRemoteLibrariesNode.this.getDirectoryForJar((PsiFile)input);
                    if (PyRemoteLibrariesNode.this.myRemoteSdkData.getPathMappings().canReplaceLocal(path)) {
                        return new PyRemoteRootNode(PyRemoteLibrariesNode.this.myRemoteSdkData.getPathMappings().convertToRemote(path), PyRemoteLibrariesNode.this.getProject(), dir, PyRemoteLibrariesNode.this.getSettings());
                    }
                }
                return null;
            }
        }).filter(Predicates.notNull()).toList();
    }

    @Nullable
    private PsiDirectory getDirectoryForJar(PsiFile input) {
        VirtualFile jarRoot = PyRemoteLibrariesNode.getJarRoot(input);
        if (this.myProject != null && jarRoot != null) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(jarRoot);
        }
        return null;
    }

    @Nullable
    private static VirtualFile getJarRoot(PsiFile input) {
        VirtualFile file = input.getVirtualFile();
        if (file == null || !file.isValid() || !(file.getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        return JarFileSystem.getInstance().getJarRootForLocalFile(file);
    }

    public static class PyRemoteRootNode
    extends PsiDirectoryNode {
        private String myRemotePath;

        public PyRemoteRootNode(String remotePath, Project project, PsiDirectory value, ViewSettings viewSettings) {
            super(project, value, viewSettings);
            this.myRemotePath = remotePath;
        }

        @Override
        protected void updateImpl(PresentationData data) {
            data.setPresentableText(this.myRemotePath);
            data.setIcon(PlatformIcons.FOLDER_ICON);
        }
    }
}

