/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.patterns;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.patterns.PyElementPattern;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class PythonPatterns
extends PlatformPatterns {
    public static PyElementPattern.Capture<PyLiteralExpression> pyLiteralExpression() {
        return new PyElementPattern.Capture<PyLiteralExpression>(new InitialPatternCondition<PyLiteralExpression>(PyLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof PyLiteralExpression;
            }
        });
    }

    public static PyElementPattern.Capture<PyStringLiteralExpression> pyStringLiteralMatches(String regexp) {
        final Pattern pattern = Pattern.compile(regexp, 34);
        return new PyElementPattern.Capture<PyStringLiteralExpression>(new InitialPatternCondition<PyStringLiteralExpression>(PyStringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                PyStringLiteralExpression expr;
                if (o instanceof PyStringLiteralExpression && !DocStringUtil.isDocStringExpression(expr = (PyStringLiteralExpression)o)) {
                    String value = expr.getStringValue();
                    return pattern.matcher(value).matches();
                }
                return false;
            }
        });
    }

    public static PyElementPattern.Capture<PyExpression> pyArgument(final String functionName, final int index) {
        return new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return PythonPatterns.isCallArgument(o, functionName, index);
            }
        });
    }

    public static PyElementPattern.Capture<PyExpression> pyModuleFunctionArgument(final String functionName, final int index, final String moduleName) {
        return new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                Callable function = PythonPatterns.resolveCalledFunction(o, functionName, index);
                if (!(function instanceof PyFunction)) {
                    return false;
                }
                ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)function, ScopeOwner.class);
                if (!(scopeOwner instanceof PyFile)) {
                    return false;
                }
                return moduleName.equals(FileUtil.getNameWithoutExtension((String)scopeOwner.getName()));
            }
        });
    }

    public static PyElementPattern.Capture<PyExpression> pyMethodArgument(final String functionName, final int index, final String classQualifiedName) {
        return new PyElementPattern.Capture<PyExpression>(new InitialPatternCondition<PyExpression>(PyExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                Callable function = PythonPatterns.resolveCalledFunction(o, functionName, index);
                if (!(function instanceof PyFunction)) {
                    return false;
                }
                ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)function, ScopeOwner.class);
                if (!(scopeOwner instanceof PyClass)) {
                    return false;
                }
                return classQualifiedName.equals(((PyClass)scopeOwner).getQualifiedName());
            }
        });
    }

    private static Callable resolveCalledFunction(Object o, String functionName, int index) {
        PyResolveContext context;
        if (!PythonPatterns.isCallArgument(o, functionName, index)) {
            return null;
        }
        PyExpression expression = (PyExpression)o;
        PyCallExpression call = (PyCallExpression)expression.getParent().getParent();
        PyCallExpression.PyMarkedCallee callee = call.resolveCallee(context = PyResolveContext.noImplicits().withTypeEvalContext(TypeEvalContext.codeAnalysis(expression.getProject(), expression.getContainingFile())));
        return callee != null ? callee.getCallable() : null;
    }

    private static boolean isCallArgument(Object o, String functionName, int index) {
        if (!(o instanceof PyExpression)) {
            return false;
        }
        PsiElement parent = ((PyExpression)o).getParent();
        if (!(parent instanceof PyArgumentList)) {
            return false;
        }
        PsiElement parent1 = parent.getParent();
        if (!(parent1 instanceof PyCallExpression)) {
            return false;
        }
        PyExpression methodExpression = ((PyCallExpression)parent1).getCallee();
        if (!(methodExpression instanceof PyReferenceExpression)) {
            return false;
        }
        String referencedName = ((PyReferenceExpression)methodExpression).getReferencedName();
        if (referencedName == null || !referencedName.equals(functionName)) {
            return false;
        }
        int i = 0;
        for (PsiElement child : parent.getChildren()) {
            if (i == index) {
                return child == o;
            }
            ++i;
        }
        return false;
    }
}

