/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class PyParser
implements PsiParser {
    private static final Logger LOGGER = Logger.getInstance((String)PyParser.class.getName());
    private LanguageLevel myLanguageLevel = LanguageLevel.getDefault();
    private StatementParsing.FUTURE myFutureFlag;

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        long start = System.currentTimeMillis();
        PsiBuilder.Marker rootMarker = builder.mark();
        ParsingContext context = this.createParsingContext(builder, this.myLanguageLevel, this.myFutureFlag);
        StatementParsing statementParser = context.getStatementParser();
        builder.setTokenTypeRemapper((ITokenTypeRemapper)statementParser);
        boolean lastAfterSemicolon = false;
        while (!builder.eof()) {
            ParsingScope scope = context.emptyParsingScope();
            if (lastAfterSemicolon) {
                statementParser.parseSimpleStatement(scope);
            } else {
                statementParser.parseStatement(scope);
            }
            lastAfterSemicolon = scope.isAfterSemicolon();
        }
        rootMarker.done(root);
        ASTNode ast = builder.getTreeBuilt();
        long diff = System.currentTimeMillis() - start;
        double kb = (double)builder.getCurrentOffset() / 1000.0;
        LOGGER.debug("Parsed " + String.format("%.1f", kb) + "K file in " + diff + "ms");
        ASTNode aSTNode = ast;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/parsing/PyParser", "parse"));
        }
        return aSTNode;
    }

    protected ParsingContext createParsingContext(PsiBuilder builder, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag) {
        return new ParsingContext(builder, languageLevel, futureFlag);
    }

    public void setFutureFlag(StatementParsing.FUTURE future) {
        this.myFutureFlag = future;
    }
}

