/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    protected ParsingContext myContext;
    protected PsiBuilder myBuilder;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.parsing.Parsing");

    protected Parsing(ParsingContext context) {
        this.myContext = context;
        this.myBuilder = context.getBuilder();
    }

    public ParsingContext getParsingContext() {
        return this.myContext;
    }

    public ExpressionParsing getExpressionParser() {
        return this.getParsingContext().getExpressionParser();
    }

    public StatementParsing getStatementParser() {
        return this.getParsingContext().getStatementParser();
    }

    public FunctionParsing getFunctionParser() {
        return this.getParsingContext().getFunctionParser();
    }

    protected boolean checkMatches(IElementType token, String message) {
        if (this.myBuilder.getTokenType() == token) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    protected boolean parseIdentifierOrSkip() {
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            this.myBuilder.advanceLexer();
            return true;
        }
        PsiBuilder.Marker nameExpected = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK) {
            this.myBuilder.advanceLexer();
        }
        nameExpected.error(PyBundle.message("PARSE.expected.identifier", new Object[0]));
        return false;
    }

    protected void assertCurrentToken(PyElementType tokenType) {
        LOG.assertTrue(this.myBuilder.getTokenType() == tokenType);
    }

    protected boolean atToken(@Nullable IElementType tokenType) {
        return this.myBuilder.getTokenType() == tokenType;
    }

    protected boolean atToken(@NotNull IElementType tokenType, @NotNull String tokenText) {
        if (tokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/jetbrains/python/parsing/Parsing", "atToken"));
        }
        if (tokenText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenText", "com/jetbrains/python/parsing/Parsing", "atToken"));
        }
        return this.myBuilder.getTokenType() == tokenType && tokenText.equals(this.myBuilder.getTokenText());
    }

    protected boolean atAnyOfTokens(IElementType ... tokenTypes) {
        IElementType currentTokenType = this.myBuilder.getTokenType();
        for (IElementType tokenType : tokenTypes) {
            if (currentTokenType != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean matchToken(IElementType tokenType) {
        if (this.myBuilder.getTokenType() == tokenType) {
            this.myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    protected void nextToken() {
        this.myBuilder.advanceLexer();
    }

    protected static void buildTokenElement(IElementType type, PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done(type);
    }

    protected IElementType getReferenceType() {
        return PyElementTypes.REFERENCE_EXPRESSION;
    }
}

