/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.Parsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.ParsingScope;

public class FunctionParsing
extends Parsing {
    private static final IElementType FUNCTION_TYPE = PyElementTypes.FUNCTION_DECLARATION;

    public FunctionParsing(ParsingContext context) {
        super(context);
    }

    public void parseFunctionDeclaration() {
        this.assertCurrentToken(PyTokenTypes.DEF_KEYWORD);
        PsiBuilder.Marker functionMarker = this.myBuilder.mark();
        this.parseFunctionInnards(functionMarker);
    }

    protected IElementType getFunctionType() {
        return FUNCTION_TYPE;
    }

    protected void parseFunctionInnards(PsiBuilder.Marker functionMarker) {
        this.myBuilder.advanceLexer();
        this.parseIdentifierOrSkip();
        this.parseParameterList();
        this.parseReturnTypeAnnotation();
        this.checkMatches(PyTokenTypes.COLON, PyBundle.message("PARSE.expected.colon", new Object[0]));
        this.getStatementParser().parseSuite(functionMarker, this.getFunctionType(), this.myContext.emptyParsingScope().withFunction(true));
    }

    public void parseReturnTypeAnnotation() {
        if (this.myContext.getLanguageLevel().isPy3K() && this.myBuilder.getTokenType() == PyTokenTypes.MINUS) {
            PsiBuilder.Marker maybeReturnAnnotation = this.myBuilder.mark();
            this.nextToken();
            if (this.matchToken(PyTokenTypes.GT)) {
                if (!this.myContext.getExpressionParser().parseSingleExpression(false)) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
                maybeReturnAnnotation.done(PyElementTypes.ANNOTATION);
            } else {
                maybeReturnAnnotation.rollbackTo();
            }
        }
    }

    public void parseDecoratedDeclaration(ParsingScope scope) {
        this.assertCurrentToken(PyTokenTypes.AT);
        PsiBuilder.Marker decoratorStartMarker = this.myBuilder.mark();
        PsiBuilder.Marker decoListMarker = this.myBuilder.mark();
        boolean decorated = false;
        while (this.myBuilder.getTokenType() == PyTokenTypes.AT) {
            PsiBuilder.Marker decoratorMarker = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            this.getStatementParser().parseDottedName();
            if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
                this.getExpressionParser().parseArgumentList();
            } else {
                PsiBuilder.Marker argListMarker = this.myBuilder.mark();
                argListMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                argListMarker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
            }
            if (this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                decoratorMarker.done(PyElementTypes.DECORATOR_CALL);
                this.nextToken();
            } else {
                this.myBuilder.error(PyBundle.message("PARSE.expected.statement.break", new Object[0]));
                decoratorMarker.done(PyElementTypes.DECORATOR_CALL);
            }
            decorated = true;
        }
        if (decorated) {
            decoListMarker.done(PyElementTypes.DECORATOR_LIST);
        }
        this.parseDeclarationAfterDecorator(decoratorStartMarker, scope);
    }

    protected void parseDeclarationAfterDecorator(PsiBuilder.Marker endMarker, ParsingScope scope) {
        if (this.myBuilder.getTokenType() == PyTokenTypes.DEF_KEYWORD) {
            this.parseFunctionInnards(endMarker);
        } else if (this.myBuilder.getTokenType() == PyTokenTypes.CLASS_KEYWORD) {
            this.getStatementParser().parseClassDeclaration(endMarker, scope);
        } else {
            this.myBuilder.error(PyBundle.message("PARSE.expected.@.or.def", new Object[0]));
            PsiBuilder.Marker parameterList = this.myBuilder.mark();
            parameterList.done(PyElementTypes.PARAMETER_LIST);
            this.myBuilder.mark().done((IElementType)PyElementTypes.STATEMENT_LIST);
            endMarker.done(this.getFunctionType());
        }
    }

    public void parseParameterList() {
        if (this.myBuilder.getTokenType() != PyTokenTypes.LPAR) {
            this.myBuilder.error(PyBundle.message("PARSE.expected.lpar", new Object[0]));
            PsiBuilder.Marker parameterList = this.myBuilder.mark();
            parameterList.done(PyElementTypes.PARAMETER_LIST);
            return;
        }
        this.parseParameterListContents(PyTokenTypes.RPAR, true, false);
    }

    public void parseParameterListContents(IElementType endToken, boolean advanceLexer, boolean isLambda) {
        PsiBuilder.Marker parameterList = this.myBuilder.mark();
        if (advanceLexer) {
            this.myBuilder.advanceLexer();
        }
        boolean first = true;
        boolean afterStarParameter = false;
        while (this.myBuilder.getTokenType() != endToken) {
            if (first) {
                first = false;
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.COMMA) {
                this.myBuilder.advanceLexer();
            } else {
                this.myBuilder.error(PyBundle.message("PARSE.expected.comma.lpar.rpar", new Object[0]));
                break;
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
                this.parseParameterSubList();
                continue;
            }
            boolean isStarParameter = this.atAnyOfTokens(PyTokenTypes.MULT, PyTokenTypes.EXP);
            if (!this.parseParameter(endToken, isLambda)) {
                if (!afterStarParameter) break;
                this.myBuilder.error("expression expected");
                break;
            }
            if (!isStarParameter) continue;
            afterStarParameter = true;
        }
        if (this.myBuilder.getTokenType() == endToken && endToken == PyTokenTypes.RPAR) {
            this.myBuilder.advanceLexer();
        }
        parameterList.done(PyElementTypes.PARAMETER_LIST);
        if (this.myBuilder.getTokenType() == endToken && endToken == PyTokenTypes.COLON) {
            this.myBuilder.advanceLexer();
        }
    }

    protected boolean parseParameter(IElementType endToken, boolean isLambda) {
        PsiBuilder.Marker parameter = this.myBuilder.mark();
        boolean isStarParameter = false;
        if (this.myBuilder.getTokenType() == PyTokenTypes.MULT) {
            this.myBuilder.advanceLexer();
            if (this.myContext.getLanguageLevel().isPy3K() && this.myBuilder.getTokenType() == PyTokenTypes.COMMA || this.myBuilder.getTokenType() == endToken) {
                parameter.done(PyElementTypes.SINGLE_STAR_PARAMETER);
                return true;
            }
            isStarParameter = true;
        } else if (this.myBuilder.getTokenType() == PyTokenTypes.EXP) {
            this.myBuilder.advanceLexer();
            isStarParameter = true;
        }
        if (this.matchToken(PyTokenTypes.IDENTIFIER)) {
            if (!isLambda && this.myContext.getLanguageLevel().isPy3K() && this.atToken(PyTokenTypes.COLON)) {
                PsiBuilder.Marker annotationMarker = this.myBuilder.mark();
                this.nextToken();
                if (!this.getExpressionParser().parseSingleExpression(false)) {
                    this.myBuilder.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
                }
                annotationMarker.done(PyElementTypes.ANNOTATION);
            }
            if (!isStarParameter && this.matchToken(PyTokenTypes.EQ) && !this.getExpressionParser().parseSingleExpression(false)) {
                PsiBuilder.Marker invalidElements = this.myBuilder.mark();
                while (!this.atAnyOfTokens(endToken, PyTokenTypes.LINE_BREAK, PyTokenTypes.COMMA, null)) {
                    this.nextToken();
                }
                invalidElements.error(PyBundle.message("PARSE.expected.expression", new Object[0]));
            }
        } else {
            parameter.rollbackTo();
            if (this.atToken(endToken)) {
                return false;
            }
            PsiBuilder.Marker invalidElements = this.myBuilder.mark();
            while (!(this.atToken(endToken) || this.atToken(PyTokenTypes.LINE_BREAK) || this.atToken(PyTokenTypes.COMMA) || this.atToken(null))) {
                this.nextToken();
            }
            invalidElements.error(PyBundle.message("PARSE.expected.formal.param.name", new Object[0]));
            return this.atToken(endToken) || this.atToken(PyTokenTypes.COMMA);
        }
        parameter.done(PyElementTypes.NAMED_PARAMETER);
        return true;
    }

    private void parseParameterSubList() {
        this.assertCurrentToken(PyTokenTypes.LPAR);
        PsiBuilder.Marker tuple = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (true) {
            if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
                PsiBuilder.Marker parameter = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                parameter.done(PyElementTypes.NAMED_PARAMETER);
            } else if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
                this.parseParameterSubList();
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.RPAR) {
                this.myBuilder.advanceLexer();
                break;
            }
            if (this.myBuilder.getTokenType() != PyTokenTypes.COMMA) {
                this.myBuilder.error(PyBundle.message("PARSE.expected.comma.lpar.rpar", new Object[0]));
                break;
            }
            this.myBuilder.advanceLexer();
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.EQ) {
            this.myBuilder.advanceLexer();
            this.getExpressionParser().parseSingleExpression(false);
        }
        tuple.done(PyElementTypes.TUPLE_PARAMETER);
    }
}

