/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlrpc.AsyncCallback;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagementService
extends PackageManagementService {
    @NotNull
    private static final Pattern PATTERN_ERROR_LINE = Pattern.compile(".*error:.*", 2);
    private final Project myProject;
    private final Sdk mySdk;
    @NonNls
    private static final String TEXT_PREFIX = "<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: 12pt; margin: 2px 2px        }    </style></head><body style=\"font-family: Arial,serif; font-size: 12pt; margin: 5px 5px;\">";
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    @NonNls
    private static final String HTML_PREFIX = "<a href=\"";
    @NonNls
    private static final String HTML_SUFFIX = "</a>";

    public PyPackageManagementService(Project project, Sdk sdk) {
        this.myProject = project;
        this.mySdk = sdk;
    }

    public Sdk getSdk() {
        return this.mySdk;
    }

    @Override
    public List<String> getAllRepositories() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("https://pypi.python.org/pypi");
        result.addAll(PyPackageService.getInstance().additionalRepositories);
        return result;
    }

    @Override
    public void addRepository(String repositoryUrl) {
        PyPackageService.getInstance().addRepository(repositoryUrl);
    }

    @Override
    public void removeRepository(String repositoryUrl) {
        PyPackageService.getInstance().removeRepository(repositoryUrl);
    }

    @Override
    public List<RepoPackage> getAllPackages() throws IOException {
        Map<String, String> packageToVersionMap;
        try {
            packageToVersionMap = PyPIPackageUtil.INSTANCE.loadAndGetPackages();
        }
        catch (IOException e) {
            throw new IOException("Could not reach URL " + e.getMessage() + ". Please, check your internet connection.");
        }
        List<RepoPackage> packages = PyPackageManagementService.versionMapToPackageList(packageToVersionMap);
        packages.addAll(PyPIPackageUtil.INSTANCE.getAdditionalPackageNames());
        return packages;
    }

    private static List<RepoPackage> versionMapToPackageList(Map<String, String> packageToVersionMap) {
        boolean customRepoConfigured = !PyPackageService.getInstance().additionalRepositories.isEmpty();
        String url = customRepoConfigured ? "https://pypi.python.org/pypi" : "";
        ArrayList<RepoPackage> packages = new ArrayList<RepoPackage>();
        for (Map.Entry<String, String> entry : packageToVersionMap.entrySet()) {
            packages.add(new RepoPackage(entry.getKey(), url, entry.getValue()));
        }
        return packages;
    }

    @Override
    public List<RepoPackage> reloadAllPackages() throws IOException {
        PyPackageService service = PyPackageService.getInstance();
        PyPIPackageUtil.INSTANCE.updatePyPICache(service);
        service.LAST_TIME_CHECKED = System.currentTimeMillis();
        return this.getAllPackages();
    }

    @Override
    public List<RepoPackage> getAllPackagesCached() {
        return PyPackageManagementService.versionMapToPackageList(PyPIPackageUtil.getPyPIPackages());
    }

    @Override
    public boolean canInstallToUser() {
        return !PythonSdkType.isVirtualEnv(this.mySdk);
    }

    @Override
    public String getInstallToUserText() {
        String userSiteText = "Install to user's site packages directory";
        if (!PythonSdkType.isRemote(this.mySdk)) {
            userSiteText = userSiteText + " (" + PySdkUtil.getUserSite() + ")";
        }
        return userSiteText;
    }

    @Override
    public boolean isInstallToUserSelected() {
        return PyPackageService.getInstance().useUserSite(this.mySdk.getHomePath());
    }

    @Override
    public void installToUserChanged(boolean newValue) {
        PyPackageService.getInstance().addSdkToUserSite(this.mySdk.getHomePath(), newValue);
    }

    @Override
    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        List<PyPackage> packages;
        try {
            packages = PyPackageManager.getInstance(this.mySdk).getPackages(false);
            if (packages != null) {
                Collections.sort(packages, new Comparator<PyPackage>(){

                    @Override
                    public int compare(@NotNull PyPackage pkg1, @NotNull PyPackage pkg2) {
                        if (pkg1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg1", "com/jetbrains/python/packaging/ui/PyPackageManagementService$1", "compare"));
                        }
                        if (pkg2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg2", "com/jetbrains/python/packaging/ui/PyPackageManagementService$1", "compare"));
                        }
                        return pkg1.getName().compareTo(pkg2.getName());
                    }
                });
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        return packages != null ? new ArrayList<InstalledPackage>(packages) : new ArrayList();
    }

    @Override
    public void installPackage(RepoPackage repoPackage, String version, boolean forceUpgrade, String extraOptions, final PackageManagementService.Listener listener, boolean installToUser) {
        final String packageName = repoPackage.getName();
        String repository = "https://pypi.python.org/pypi".equals(repoPackage.getRepoUrl()) ? null : repoPackage.getRepoUrl();
        ArrayList<String> extraArgs = new ArrayList<String>();
        if (installToUser) {
            extraArgs.add("--user");
        }
        if (extraOptions != null) {
            Collections.addAll(extraArgs, extraOptions.split(" +"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)repository)) {
            extraArgs.add("--extra-index-url");
            extraArgs.add(repository);
        }
        if (forceUpgrade) {
            extraArgs.add("-U");
        }
        PyRequirement req = version != null ? new PyRequirement(packageName, version) : new PyRequirement(packageName);
        PyPackageManagerUI ui = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener.operationStarted(packageName);
            }

            @Override
            public void finished(@Nullable List<ExecutionException> exceptions) {
                listener.operationFinished(packageName, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ui.install(Collections.singletonList(req), extraArgs);
    }

    @Nullable
    public static PackageManagementService.ErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "toErrorDescription"));
        }
        if (exceptions != null && !exceptions.isEmpty() && !PyPackageManagementService.isCancelled(exceptions)) {
            return PyPackageManagementService.createDescription(exceptions.get(0), sdk);
        }
        return null;
    }

    @Override
    public void uninstallPackages(List<InstalledPackage> installedPackages, final PackageManagementService.Listener listener) {
        final String packageName = installedPackages.size() == 1 ? installedPackages.get(0).getName() : null;
        PyPackageManagerUI ui = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener.operationStarted(packageName);
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
                listener.operationFinished(packageName, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ArrayList<PyPackage> pyPackages = new ArrayList<PyPackage>();
        for (InstalledPackage aPackage : installedPackages) {
            if (!(aPackage instanceof PyPackage)) continue;
            pyPackages.add((PyPackage)aPackage);
        }
        ui.uninstall(pyPackages);
    }

    @Override
    public void fetchPackageVersions(final String packageName, final CatchingConsumer<List<String>, Exception> consumer) {
        PyPIPackageUtil.INSTANCE.usePackageReleases(packageName, new AsyncCallback(){

            public void handleResult(Object result, URL url, String method) {
                List releases = (List)result;
                PyPIPackageUtil.INSTANCE.addPackageReleases(packageName, releases);
                consumer.consume((Object)releases);
            }

            public void handleError(Exception exception, URL url, String method) {
                consumer.consume((Throwable)exception);
            }
        });
    }

    @Override
    public void fetchPackageDetails(final String packageName, final CatchingConsumer<String, Exception> consumer) {
        PyPIPackageUtil.INSTANCE.fillPackageDetails(packageName, new AsyncCallback(){

            public void handleResult(Object result, URL url, String method) {
                Hashtable details = (Hashtable)result;
                PyPIPackageUtil.INSTANCE.addPackageDetails(packageName, details);
                consumer.consume((Object)PyPackageManagementService.formatPackageDetails(details));
            }

            public void handleError(Exception exception, URL url, String method) {
                consumer.consume((Throwable)exception);
            }
        });
    }

    private static String formatPackageDetails(Hashtable details) {
        Object homePage;
        Object authorEmail;
        Object author;
        Object version;
        Object description = details.get("summary");
        StringBuilder stringBuilder = new StringBuilder(TEXT_PREFIX);
        if (description instanceof String) {
            stringBuilder.append(description).append("<br/>");
        }
        if ((version = details.get("version")) instanceof String && !StringUtil.isEmpty((String)((String)version))) {
            stringBuilder.append("<h4>Version</h4>");
            stringBuilder.append(version);
        }
        if ((author = details.get("author")) instanceof String && !StringUtil.isEmpty((String)((String)author))) {
            stringBuilder.append("<h4>Author</h4>");
            stringBuilder.append(author).append("<br/><br/>");
        }
        if ((authorEmail = details.get("author_email")) instanceof String && !StringUtil.isEmpty((String)((String)authorEmail))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref("mailto:" + authorEmail));
        }
        if ((homePage = details.get("home_page")) instanceof String && !StringUtil.isEmpty((String)((String)homePage))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref((String)homePage));
        }
        stringBuilder.append(TEXT_SUFFIX);
        return stringBuilder.toString();
    }

    private static String composeHref(String vendorUrl) {
        return HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
    }

    private static boolean isCancelled(@NotNull List<ExecutionException> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "isCancelled"));
        }
        for (ExecutionException e : exceptions) {
            if (!(e instanceof RunCanceledByUserException)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PackageManagementService.ErrorDescription createDescription(@NotNull ExecutionException e, @NotNull Sdk sdk) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "createDescription"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "createDescription"));
        }
        if (e instanceof PyExecutionException) {
            PyExecutionException ee = (PyExecutionException)e;
            String stdoutCause = PyPackageManagementService.findErrorCause(ee.getStdout());
            String stderrCause = PyPackageManagementService.findErrorCause(ee.getStderr());
            String cause = stdoutCause != null ? stdoutCause : stderrCause;
            String message = cause != null ? cause : ee.getMessage();
            String command = ee.getCommand() + " " + StringUtil.join(ee.getArgs(), (String)" ");
            PackageManagementService.ErrorDescription errorDescription = new PackageManagementService.ErrorDescription(message, command, ee.getStdout() + "\n" + ee.getStderr(), PyPackageManagementService.findErrorSolution(ee, cause, sdk));
            if (errorDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "createDescription"));
            }
            return errorDescription;
        }
        PackageManagementService.ErrorDescription errorDescription = PackageManagementService.ErrorDescription.fromMessage(e.getMessage());
        if (errorDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "createDescription"));
        }
        return errorDescription;
    }

    @Nullable
    private static String findErrorSolution(@NotNull PyExecutionException e, @Nullable String cause, @NotNull Sdk sdk) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "findErrorSolution"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "findErrorSolution"));
        }
        if (cause != null && StringUtil.containsIgnoreCase((String)cause, (String)"SyntaxError")) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
            return "Make sure that you use a version of Python supported by this package. Currently you are using Python " + (Object)((Object)languageLevel) + ".";
        }
        if (SystemInfo.isLinux && (PyPackageManagementService.containsInOutput(e, "pyconfig.h") || PyPackageManagementService.containsInOutput(e, "Python.h"))) {
            return "Make sure that you have installed Python development packages for your operating system.";
        }
        if ("pip".equals(e.getCommand())) {
            return "Try to run this command from the system terminal. Make sure that you use the correct version of 'pip' installed for your Python interpreter located at '" + sdk.getHomePath() + "'.";
        }
        return null;
    }

    private static boolean containsInOutput(@NotNull PyExecutionException e, @NotNull String text) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "containsInOutput"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "containsInOutput"));
        }
        return StringUtil.containsIgnoreCase((String)e.getStdout(), (String)text) || StringUtil.containsIgnoreCase((String)e.getStderr(), (String)text);
    }

    @Nullable
    private static String findErrorCause(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/jetbrains/python/packaging/ui/PyPackageManagementService", "findErrorCause"));
        }
        Matcher m = PATTERN_ERROR_LINE.matcher(output);
        if (m.find()) {
            String result = m.group();
            return result != null ? result.trim() : null;
        }
        return null;
    }
}

