/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.Consumer;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.InstalledPackagesPanel;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInstalledPackagesPanel
extends InstalledPackagesPanel {
    private boolean myHasManagement = false;

    public PyInstalledPackagesPanel(Project project, PackagesNotificationPanel area) {
        super(project, area);
    }

    private Sdk getSelectedSdk() {
        PyPackageManagementService service = (PyPackageManagementService)this.myPackageManagementService;
        return service != null ? service.getSdk() : null;
    }

    public void updateNotifications(final @Nullable Sdk selectedSdk) {
        if (selectedSdk == null) {
            this.myNotificationArea.hide();
            return;
        }
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                PyExecutionException exception = null;
                try {
                    PyInstalledPackagesPanel.this.myHasManagement = PyPackageManager.getInstance(selectedSdk).hasManagement(false);
                    if (!PyInstalledPackagesPanel.this.myHasManagement) {
                        throw new PyExecutionException("Python packaging tools not found", "pip", Collections.<String>emptyList(), "", "", 0, (List<? extends PyExecutionFix>)ImmutableList.of((Object)new PyInstallPackageManagementFix()));
                    }
                }
                catch (PyExecutionException e) {
                    exception = e;
                }
                catch (ExecutionException e) {
                    return;
                }
                final PyExecutionException problem = exception;
                application.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (selectedSdk == PyInstalledPackagesPanel.this.getSelectedSdk()) {
                            PyInstalledPackagesPanel.this.myNotificationArea.hide();
                            if (problem != null) {
                                boolean invalid = PythonSdkType.isInvalid(selectedSdk);
                                if (!invalid) {
                                    StringBuilder builder = new StringBuilder(problem.getMessage());
                                    builder.append(". ");
                                    for (final PyExecutionFix pyExecutionFix : problem.getFixes()) {
                                        final String key = "id" + pyExecutionFix.hashCode();
                                        String link = "<a href=\"" + key + "\">" + pyExecutionFix.getName() + "</a>";
                                        builder.append(link);
                                        builder.append(" ");
                                        PyInstalledPackagesPanel.this.myNotificationArea.addLinkHandler(key, new Runnable(){

                                            @Override
                                            public void run() {
                                                Sdk sdk = PyInstalledPackagesPanel.this.getSelectedSdk();
                                                if (sdk != null) {
                                                    pyExecutionFix.run(sdk);
                                                    PyInstalledPackagesPanel.this.myNotificationArea.removeLinkHandler(key);
                                                    PyInstalledPackagesPanel.this.updatePackages(new PyPackageManagementService(PyInstalledPackagesPanel.this.myProject, sdk));
                                                    PyInstalledPackagesPanel.this.updateNotifications(sdk);
                                                }
                                            }
                                        });
                                    }
                                    PyInstalledPackagesPanel.this.myNotificationArea.showWarning(builder.toString());
                                }
                                PyInstalledPackagesPanel.this.myInstallButton.setEnabled(!invalid && PyInstalledPackagesPanel.this.myHasManagement);
                            }
                        }
                    }
                }, ModalityState.any());
            }
        });
    }

    @Override
    protected Set<String> getPackagesToPostpone() {
        return Sets.newHashSet((Object[])new String[]{"pip", "distutils", "setuptools"});
    }

    @Override
    protected boolean canUninstallPackage(InstalledPackage pkg) {
        String location;
        if (!this.myHasManagement) {
            return false;
        }
        if (PythonSdkType.isVirtualEnv(this.getSelectedSdk()) && pkg instanceof PyPackage && (location = ((PyPackage)pkg).getLocation()) != null && location.startsWith(PySdkUtil.getUserSite())) {
            return false;
        }
        String name = pkg.getName();
        return !"pip".equals(name) && !"setuptools".equals(name) && !"distribute".equals(name);
    }

    @Override
    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyPackage", "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel", "canInstallPackage"));
        }
        return this.myHasManagement;
    }

    @Override
    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        return this.myHasManagement;
    }

    class PyInstallPackageManagementFix
    implements PyExecutionFix {
        PyInstallPackageManagementFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Install packaging tools" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix", "getName"));
            }
            return "Install packaging tools";
        }

        @Override
        public void run(final @NotNull Sdk sdk) {
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix", "run"));
            }
            PyPackageManagerUI ui = new PyPackageManagerUI(PyInstalledPackagesPanel.this.myProject, sdk, new PyPackageManagerUI.Listener(){

                @Override
                public void started() {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                    PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
                    PackageManagementService.ErrorDescription description = PyPackageManagementService.toErrorDescription(exceptions, sdk);
                    if (description != null) {
                        PackagesNotificationPanel.showError("Failed to install Python packaging tools", description);
                    }
                    packageManager.refresh();
                    PyInstalledPackagesPanel.this.updatePackages(new PyPackageManagementService(PyInstalledPackagesPanel.this.myProject, sdk));
                    for (Consumer listener : PyInstalledPackagesPanel.this.myPathChangedListeners) {
                        listener.consume((Object)sdk);
                    }
                    PyInstalledPackagesPanel.this.updateNotifications(sdk);
                }
            });
            ui.installManagement();
        }
    }
}

