/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.jetbrains.python.packaging.PyRequirement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyChooseRequirementsDialog
extends DialogWrapper {
    private final ElementsChooser<PyRequirement> myRequirementsChooser;

    public PyChooseRequirementsDialog(@NotNull Project project, @NotNull List<PyRequirement> requirements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/packaging/ui/PyChooseRequirementsDialog", "<init>"));
        }
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/packaging/ui/PyChooseRequirementsDialog", "<init>"));
        }
        super(project, false);
        this.setTitle("Choose Packages to Install");
        this.setOKButtonText("Install");
        this.myRequirementsChooser = new ElementsChooser<PyRequirement>(true){

            @Override
            public String getItemText(@NotNull PyRequirement requirement) {
                if (requirement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirement", "com/jetbrains/python/packaging/ui/PyChooseRequirementsDialog$1", "getItemText"));
                }
                return requirement.toString();
            }
        };
        this.myRequirementsChooser.setElements(requirements, true);
        this.myRequirementsChooser.addElementsMarkListener(new ElementsChooser.ElementsMarkListener<PyRequirement>(){

            @Override
            public void elementMarkChanged(PyRequirement element, boolean isMarked) {
                PyChooseRequirementsDialog.this.setOKActionEnabled(!PyChooseRequirementsDialog.this.myRequirementsChooser.getMarkedElements().isEmpty());
            }
        });
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(400, 300));
        JBLabel label = new JBLabel("Choose packages to install:");
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        panel.add((Component)label, "North");
        panel.add(this.myRequirementsChooser, "Center");
        return panel;
    }

    public List<PyRequirement> getMarkedElements() {
        return this.myRequirementsChooser.getMarkedElements();
    }
}

