/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SetupTaskIntrospector {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.packaging.setupPy.SetupTaskIntrospector");
    private static final Map<String, List<SetupTask>> ourDistutilsTaskCache = new HashMap<String, List<SetupTask>>();
    private static final Map<String, List<SetupTask>> ourSetuptoolsTaskCache = new HashMap<String, List<SetupTask>>();
    private static final Set<String> SKIP_NAMES = ImmutableSet.of((Object)"__init__.py", (Object)"alias.py", (Object)"setopt.py", (Object)"savecfg.py");

    private static boolean usesSetuptools(PyFile file) {
        List<PyFromImportStatement> imports = file.getFromImports();
        for (PyFromImportStatement anImport : imports) {
            QualifiedName qName = anImport.getImportSourceQName();
            if (qName == null || !qName.matches(new String[]{"setuptools"})) continue;
            return true;
        }
        List<PyImportElement> importElements = file.getImportTargets();
        for (PyImportElement element : importElements) {
            QualifiedName qName = element.getImportedQName();
            if (qName == null || !qName.matches(new String[]{"setuptools"})) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static List<SetupTask.Option> getSetupTaskOptions(Module module, String taskName) {
        for (SetupTask task : SetupTaskIntrospector.getTaskList(module)) {
            if (!task.getName().equals(taskName)) continue;
            return task.getOptions();
        }
        return null;
    }

    public static List<SetupTask> getTaskList(Module module) {
        PyFile setupPy = PyPackageUtil.findSetupPy(module);
        return SetupTaskIntrospector.getTaskList(module, setupPy != null && SetupTaskIntrospector.usesSetuptools(setupPy));
    }

    private static List<SetupTask> getTaskList(Module module, boolean setuptools) {
        PsiDirectory distutilsCommandDir;
        String name = (setuptools ? "setuptools" : "distutils") + ".command.install.install";
        Map<String, List<SetupTask>> cache = setuptools ? ourSetuptoolsTaskCache : ourDistutilsTaskCache;
        PyClass installClass = PyClassNameIndex.findClass(name, module.getProject());
        if (installClass != null && (distutilsCommandDir = installClass.getContainingFile().getParent()) != null) {
            String path = distutilsCommandDir.getVirtualFile().getPath();
            List<SetupTask> tasks = cache.get(path);
            if (tasks == null) {
                tasks = SetupTaskIntrospector.collectTasks(distutilsCommandDir, setuptools);
                cache.put(path, tasks);
            }
            return tasks;
        }
        return Collections.emptyList();
    }

    private static List<SetupTask> collectTasks(PsiDirectory dir, boolean setuptools) {
        ArrayList<SetupTask> result = new ArrayList<SetupTask>();
        for (PsiFile commandFile : dir.getFiles()) {
            if (!(commandFile instanceof PyFile) || SKIP_NAMES.contains(commandFile.getName())) continue;
            String taskName = FileUtil.getNameWithoutExtension((String)commandFile.getName());
            result.add(SetupTaskIntrospector.createTaskFromFile((PyFile)commandFile, taskName, setuptools));
        }
        return result;
    }

    private static SetupTask createTaskFromFile(PyFile file, String name, boolean setuptools) {
        PyClass taskClass;
        SetupTask task = new SetupTask(name);
        PyClass pyClass = taskClass = name.equals("build_ext") && setuptools ? PyClassNameIndex.findClass("distutils.command.build_ext.build_ext", file.getProject()) : file.findTopLevelClass(name);
        if (taskClass != null) {
            String descriptionText;
            PyTargetExpression description = taskClass.findClassAttribute("description", true);
            if (description != null && (descriptionText = PyPsiUtils.strValue(PyPsiUtils.flattenParens(description.findAssignedValue()))) != null) {
                task.setDescription(descriptionText);
            }
            List<PyExpression> booleanOptions = SetupTaskIntrospector.resolveSequenceValue(taskClass, "boolean_options");
            ArrayList<String> booleanOptionsList = new ArrayList<String>();
            for (PyExpression option : booleanOptions) {
                String s = PyPsiUtils.strValue(option);
                if (s == null) continue;
                booleanOptionsList.add(s);
            }
            PyTargetExpression negativeOpt = taskClass.findClassAttribute("negative_opt", true);
            Map<String, String> negativeOptMap = negativeOpt == null ? Collections.emptyMap() : SetupTaskIntrospector.parseNegativeOpt(negativeOpt.findAssignedValue());
            List<PyExpression> userOptions = SetupTaskIntrospector.resolveSequenceValue(taskClass, "user_options");
            for (PyExpression element : userOptions) {
                SetupTask.Option option = SetupTaskIntrospector.createOptionFromTuple(element, booleanOptionsList, negativeOptMap);
                if (option == null) continue;
                task.addOption(option);
            }
        }
        return task;
    }

    private static List<PyExpression> resolveSequenceValue(PyClass aClass, String name) {
        ArrayList<PyExpression> result = new ArrayList<PyExpression>();
        SetupTaskIntrospector.collectSequenceElements((PsiElement)aClass.findClassAttribute(name, true), result);
        return result;
    }

    private static void collectSequenceElements(PsiElement value, List<PyExpression> result) {
        if (value instanceof PySequenceExpression) {
            Collections.addAll(result, ((PySequenceExpression)value).getElements());
        } else if (value instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)value;
            if (binaryExpression.isOperator("+")) {
                SetupTaskIntrospector.collectSequenceElements((PsiElement)binaryExpression.getLeftExpression(), result);
                SetupTaskIntrospector.collectSequenceElements((PsiElement)binaryExpression.getRightExpression(), result);
            }
        } else if (value instanceof PyReferenceExpression) {
            PsiElement resolveResult = ((PyReferenceExpression)value).getReference(PyResolveContext.noImplicits()).resolve();
            SetupTaskIntrospector.collectSequenceElements(resolveResult, result);
        } else if (value instanceof PyTargetExpression) {
            SetupTaskIntrospector.collectSequenceElements((PsiElement)((PyTargetExpression)value).findAssignedValue(), result);
        }
    }

    private static Map<String, String> parseNegativeOpt(PyExpression dict) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((dict = PyPsiUtils.flattenParens(dict)) instanceof PyDictLiteralExpression) {
            PyKeyValueExpression[] elements;
            for (PyKeyValueExpression element : elements = ((PyDictLiteralExpression)dict).getElements()) {
                String key = PyPsiUtils.strValue(PyPsiUtils.flattenParens(element.getKey()));
                String value = PyPsiUtils.strValue(PyPsiUtils.flattenParens(element.getValue()));
                if (key == null || value == null) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    @Nullable
    private static SetupTask.Option createOptionFromTuple(PyExpression tuple, List<String> booleanOptions, Map<String, String> negativeOptMap) {
        PyExpression[] elements;
        if ((tuple = PyPsiUtils.flattenParens(tuple)) instanceof PyTupleExpression && (elements = ((PyTupleExpression)tuple).getElements()).length == 3) {
            String name = PyPsiUtils.strValue(elements[0]);
            String description = PyPsiUtils.strValue(elements[2]);
            if (name != null && description != null) {
                if (negativeOptMap.containsKey(name)) {
                    return null;
                }
                if (description.contains("don't use") || description.contains("deprecated")) {
                    return null;
                }
                boolean checkbox = booleanOptions.contains(name);
                boolean negative = false;
                if (negativeOptMap.containsValue(name)) {
                    negative = true;
                    for (Map.Entry<String, String> entry : negativeOptMap.entrySet()) {
                        if (!entry.getValue().equals(name)) continue;
                        name = entry.getKey();
                        break;
                    }
                }
                return new SetupTask.Option(name, StringUtil.capitalize((String)description), checkbox, negative);
            }
        }
        return null;
    }
}

