/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ListChooseByNameModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import com.jetbrains.python.packaging.setupPy.SetupTaskDialog;
import com.jetbrains.python.packaging.setupPy.SetupTaskIntrospector;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.List;

public class SetupTaskChooserAction
extends AnAction {
    public SetupTaskChooserAction() {
        super("Run setup.py Task...");
    }

    public void actionPerformed(AnActionEvent e) {
        final Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        ListChooseByNameModel<SetupTask> model = new ListChooseByNameModel<SetupTask>(project, "Enter setup.py task name", "No tasks found", SetupTaskIntrospector.getTaskList(module));
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup(project, model, GotoActionBase.getPsiContext(e));
        popup.setShowListForEmptyPattern(true);
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
            }

            public void elementChosen(Object element) {
                if (element != null) {
                    final SetupTask task = (SetupTask)element;
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SetupTaskChooserAction.runSetupTask(task.getName(), module);
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        }, ModalityState.current(), false);
    }

    public void update(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        e.getPresentation().setEnabled(module != null && PyPackageUtil.findSetupPy(module) != null && PythonSdkType.findPythonSdk(module) != null);
    }

    public static void runSetupTask(String taskName, Module module) {
        PyFile setupPy = PyPackageUtil.findSetupPy(module);
        try {
            List<SetupTask.Option> options = SetupTaskIntrospector.getSetupTaskOptions(module, taskName);
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(taskName);
            if (options != null) {
                SetupTaskDialog dialog = new SetupTaskDialog(module.getProject(), taskName, options);
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                parameters.addAll(dialog.getCommandLine());
            }
            PythonTask task = new PythonTask(module, taskName);
            VirtualFile virtualFile = setupPy.getVirtualFile();
            task.setRunnerScript(virtualFile.getPath());
            task.setWorkingDirectory(virtualFile.getParent().getPath());
            task.setParameters(parameters);
            task.setAfterCompletion(new Runnable(){

                @Override
                public void run() {
                    LocalFileSystem.getInstance().refresh(true);
                }
            });
            task.run(null);
        }
        catch (ExecutionException ee) {
            Messages.showErrorDialog((Project)module.getProject(), (String)("Failed to run task: " + ee.getMessage()), (String)taskName);
        }
    }
}

