/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.Properties;

public class CreateSetupPyAction
extends CreateFromTemplateAction {
    private static final String AUTHOR_PROPERTY = "python.packaging.author";
    private static final String EMAIL_PROPERTY = "python.packaging.author.email";

    public CreateSetupPyAction() {
        super(FileTemplateManager.getInstance().getInternalTemplate("Setup Script"));
        this.getTemplatePresentation().setText("Create setup.py");
    }

    @Override
    public FileTemplate getTemplate() {
        return FileTemplateManager.getInstance().getInternalTemplate("Setup Script");
    }

    @Override
    public void update(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        e.getPresentation().setEnabled(module != null && PyPackageUtil.findSetupPy(module) == null);
    }

    @Override
    public AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        AttributesDefaults defaults = new AttributesDefaults("setup.py").withFixedName(true);
        if (project != null) {
            defaults.add("Package_name", project.getName());
            PropertiesComponent properties = PropertiesComponent.getInstance();
            defaults.add("Author", properties.getOrInit(AUTHOR_PROPERTY, SystemProperties.getUserName()));
            defaults.add("Author_Email", properties.getOrInit(EMAIL_PROPERTY, ""));
            defaults.addPredefined("PackageList", CreateSetupPyAction.getPackageList(dataContext));
            defaults.addPredefined("PackageDirs", CreateSetupPyAction.getPackageDirs(dataContext));
        }
        return defaults;
    }

    private static String getPackageList(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            return "['" + StringUtil.join(PyPackageUtil.getPackageNames(module), (String)"', '") + "']";
        }
        return "[]";
    }

    private static String getPackageDirs(DataContext dataContext) {
        VirtualFile[] sourceRoots;
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null && (sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()).length > 0) {
            for (VirtualFile sourceRoot : sourceRoots) {
                VirtualFile contentRoot = ProjectFileIndex.SERVICE.getInstance((Project)module.getProject()).getContentRootForFile(sourceRoot);
                if (contentRoot == null || Comparing.equal((Object)contentRoot, (Object)sourceRoot)) continue;
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceRoot, (VirtualFile)contentRoot, (char)'/');
                return "\n    package_dir={'': '" + relativePath + "'},";
            }
        }
        return "";
    }

    @Override
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        Collection<VirtualFile> sourceRoots;
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null && (sourceRoots = PyUtil.getSourceRoots(module)).size() > 0) {
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoots.iterator().next());
        }
        return super.getTargetDirectory(dataContext, view);
    }

    @Override
    protected void elementCreated(CreateFromTemplateDialog dialog, PsiElement createdElement) {
        String authorEmail;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Properties properties = dialog.getEnteredProperties();
        String author = properties.getProperty("Author");
        if (author != null) {
            propertiesComponent.setValue(AUTHOR_PROPERTY, author);
        }
        if ((authorEmail = properties.getProperty("Author_Email")) != null) {
            propertiesComponent.setValue(EMAIL_PROPERTY, authorEmail);
        }
    }
}

